/*
 * JBoss, Home of Professional Open Source.
 * Copyright 2007, Red Hat Middleware LLC, and individual contributors
 * as indicated by the @author tags. See the copyright.txt file in the
 * distribution for a full listing of individual contributors.
  *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.ejb3.test.jbpapp999.unit;

import junit.framework.Test;

import org.jboss.ejb3.test.jbpapp999.Greeter;
import org.jboss.test.JBossTestCase;

/**
 * Test whether we can define an interceptor in the descriptor which is
 * packaged in a java module of an ear.
 * 
 * @author <a href="mailto:carlo.dewolf@jboss.com">Carlo de Wolf</a>
 * @version $Revision: $
 */
public class SimpleInterceptorUnitTestCase extends JBossTestCase
{
   public SimpleInterceptorUnitTestCase(String name)
   {
      super(name);
   }

   @Override
   protected void setUp() throws Exception
   {
      super.setUp();
      serverFound();
   }
   
   public void test1() throws Exception
   {
      Greeter bean = (Greeter) getInitialContext().lookup("jbpapp999/GreeterBean/remote");
      
      String actual = bean.sayHi("jbpapp999");
      
      assertEquals("Intercepted Hi jbpapp999", actual);
   }
   
   public static Test suite() throws Exception
   {
      return getDeploySetup(SimpleInterceptorUnitTestCase.class, "jbpapp999.ear");
   }
}
