/*
 * Decompiled with CFR 0.152.
 */
package org.ajax4jsf.framework.renderer.compiler;

import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Map;
import javax.faces.FacesException;
import javax.faces.el.MethodNotFoundException;
import org.ajax4jsf.framework.renderer.compiler.InvokeData;
import org.ajax4jsf.framework.renderer.compiler.Invoker;
import org.ajax4jsf.framework.renderer.compiler.MethodCacheState;
import org.ajax4jsf.framework.renderer.compiler.MethodCallElement;
import org.ajax4jsf.framework.renderer.compiler.TemplateContext;
import org.ajax4jsf.framework.util.message.Messages;

class StaticInvoker
extends Invoker {
    String className;
    Class cls;
    Map methods = new HashMap();

    StaticInvoker(String methodName) {
        this.methodName = methodName;
        int i = methodName.lastIndexOf(46);
        this.className = methodName.substring(0, i);
        this.methodName = methodName.substring(i + 1);
        try {
            this.cls = Thread.currentThread().getContextClassLoader().loadClass(this.className);
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
    }

    InvokeData invokeMethod(TemplateContext context, MethodCacheState state) {
        if (this.cls == null) {
            throw new FacesException(this.className, (Throwable)new ClassNotFoundException(this.className));
        }
        return this.invokeMethod(context, this.methods, this.cls, null, state);
    }

    void handleInvocationTargetException(TemplateContext context, InvocationTargetException e) {
        MethodCallElement._log.error((Object)Messages.getMessage("METHOD_CALL_ERROR_1a", this.methodName, context.getComponent().getId()), (Throwable)e);
        throw new FacesException(Messages.getMessage("METHOD_CALL_ERROR_2a", new Object[]{this.methodName, context.getComponent().getId(), e.getCause().getMessage()}), (Throwable)e);
    }

    void handleIllegalAccessException(TemplateContext context, IllegalAccessException e) {
        MethodCallElement._log.error((Object)Messages.getMessage("METHOD_CALL_ERROR_3a", this.methodName, context.getComponent().getId()), (Throwable)e);
        throw new FacesException(Messages.getMessage("METHOD_CALL_ERROR_4a", new Object[]{this.methodName, context.getComponent().getId(), e.getCause().getMessage()}), (Throwable)e);
    }

    void handleMethodNotFoundException(TemplateContext context) throws MethodNotFoundException {
        MethodCallElement._log.error((Object)Messages.getMessage("METHOD_CALL_ERROR_5a", this.methodName, context.getComponent().getId()));
        throw new MethodNotFoundException(Messages.getMessage("METHOD_CALL_ERROR_6a", this.methodName));
    }
}

