/*
 * Decompiled with CFR 0.152.
 */
package cirrus.hibernate.map;

import cirrus.hibernate.Hibernate;
import cirrus.hibernate.MappingException;
import cirrus.hibernate.cache.Cache;
import cirrus.hibernate.cache.CacheConcurrencyStrategy;
import cirrus.hibernate.cache.HashBelt;
import cirrus.hibernate.cache.ReadOnlyCache;
import cirrus.hibernate.cache.ReadWriteCache;
import cirrus.hibernate.helpers.ReflectHelper;
import cirrus.hibernate.helpers.StringHelper;
import cirrus.hibernate.map.Column;
import cirrus.hibernate.map.Component;
import cirrus.hibernate.map.PersistentClass;
import cirrus.hibernate.map.PrimaryKey;
import cirrus.hibernate.map.Property;
import cirrus.hibernate.map.Root;
import cirrus.hibernate.map.Subclass;
import cirrus.hibernate.map.Table;
import cirrus.hibernate.map.Value;
import java.util.Collections;
import java.util.Iterator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class RootClass
extends PersistentClass {
    private static final String DEFAULT_IDENTIFIER_COLUMN_NAME = "id";
    private static final String DEFAULT_DISCRIMINATOR_COLUMN_NAME = "class";
    private static final Log log = LogFactory.getLog((Class)(class$cirrus$hibernate$map$RootClass == null ? (class$cirrus$hibernate$map$RootClass = RootClass.class$("cirrus.hibernate.map.RootClass")) : class$cirrus$hibernate$map$RootClass));
    private Property identifierProperty;
    private Value identifier;
    private Property version;
    private boolean polymorphic;
    private CacheConcurrencyStrategy cache;
    private Value discriminator;
    private final boolean mutable;
    private boolean embeddedIdentifier = false;
    private final boolean explicitPolymorphism;
    private Class persister;
    static /* synthetic */ Class class$cirrus$hibernate$map$RootClass;

    public String toString() {
        return "RootClass: " + this.getPersistentClass().getName();
    }

    public Property getIdentifierProperty() {
        return this.identifierProperty;
    }

    public Value getIdentifier() {
        return this.identifier;
    }

    public boolean hasIdentifierProperty() {
        return this.identifierProperty != null;
    }

    public Value getDiscriminator() {
        return this.discriminator;
    }

    public boolean isInherited() {
        return false;
    }

    public boolean isPolymorphic() {
        return this.polymorphic;
    }

    public void setPolymorphic(boolean polymorphic) {
        this.polymorphic = polymorphic;
    }

    public RootClass getRootClass() {
        return this;
    }

    public Iterator getPropertyClosureIterator() {
        return this.getPropertyIterator();
    }

    public Iterator getTableClosureIterator() {
        return Collections.singleton(this.getTable()).iterator();
    }

    protected void addSubclass(Subclass subclass) {
        super.addSubclass(subclass);
        this.setPolymorphic(true);
    }

    public boolean isExplicitPolymorphism() {
        return this.explicitPolymorphism;
    }

    public RootClass(Node node, Root root) throws MappingException {
        super(node);
        NamedNodeMap atts = node.getAttributes();
        Node tableNameNode = atts.getNamedItem("table");
        String tableName = tableNameNode == null ? StringHelper.unqualify(this.getPersistentClass().getName()) : tableNameNode.getNodeValue();
        Node schemaNode = atts.getNamedItem("schema");
        String schema = schemaNode == null ? root.getSchemaName() : schemaNode.getNodeValue();
        Table table = root.addTable(schema, tableName);
        this.setTable(table);
        Node persisterNode = atts.getNamedItem("persister");
        if (persisterNode != null) {
            try {
                this.persister = ReflectHelper.classForName(persisterNode.getNodeValue());
            }
            catch (ClassNotFoundException cnfe) {
                throw new MappingException("Could not find persister class: " + persisterNode.getNodeValue());
            }
        }
        Node discriminatorColumnNode = atts.getNamedItem("discriminator");
        if (discriminatorColumnNode != null) {
            this.discriminator = new Value(Hibernate.STRING, table, discriminatorColumnNode.getNodeValue());
            this.polymorphic = true;
        } else {
            this.discriminator = null;
            this.polymorphic = false;
        }
        Node mutableNode = atts.getNamedItem("mutable");
        this.mutable = mutableNode == null || mutableNode.getNodeValue().toLowerCase().equals("true");
        Node polyNode = atts.getNamedItem("polymorphism");
        this.explicitPolymorphism = polyNode != null && polyNode.getNodeValue().toLowerCase().equals("explicit");
        NodeList list = node.getChildNodes();
        int i = 0;
        while (i < list.getLength()) {
            Node subnode = list.item(i);
            String name = subnode.getNodeName();
            String propertyName = Property.getPropertyName(subnode);
            if (DEFAULT_IDENTIFIER_COLUMN_NAME.equals(name)) {
                if (propertyName == null) {
                    this.identifier = new Value(subnode, null, DEFAULT_IDENTIFIER_COLUMN_NAME, false, table, root);
                    if (this.identifier.getType() == null) {
                        throw new MappingException("must specify an identifier type: " + this.getPersistentClass().getName());
                    }
                    this.identifierProperty = null;
                } else {
                    this.identifier = new Value(subnode, null, propertyName, false, table, root);
                    this.identifier.setTypeByReflection(this.getPersistentClass(), propertyName);
                    this.identifierProperty = new Property(subnode, this.identifier, root);
                }
                if (this.identifier.getType().returnedClass().isArray()) {
                    throw new MappingException("illegal use of an array as an identifier (arrays don't reimplement equals)");
                }
            } else if ("composite-id".equals(name)) {
                if (propertyName == null) {
                    this.identifier = new Component(subnode, null, null, this, false, table, root);
                    this.embeddedIdentifier = ((Component)this.identifier).isEmbedded();
                    this.identifierProperty = null;
                } else {
                    Class reflectedClass = ReflectHelper.getGetter(this.getPersistentClass(), propertyName).getReturnType();
                    this.identifier = new Component(subnode, reflectedClass, null, this, false, table, root);
                    this.identifierProperty = new Property(subnode, this.identifier, root);
                }
            } else if ("version".equals(name) || "timestamp".equals(name)) {
                Value val = new Value(subnode, null, propertyName, false, table, root);
                if (val.getType() == null) {
                    val.setType("version".equals(name) ? Hibernate.INTEGER : Hibernate.TIMESTAMP);
                }
                this.version = new Property(subnode, val, root);
                this.addProperty(this.version);
            } else if ("discriminator".equals(name)) {
                this.discriminator = new Value(subnode, null, DEFAULT_DISCRIMINATOR_COLUMN_NAME, false, table, root);
                if (this.discriminator.getType() == null) {
                    this.discriminator.setType(Hibernate.STRING);
                    ((Column)this.discriminator.getColumnIterator().next()).setType(Hibernate.STRING);
                }
                this.polymorphic = true;
            } else if ("cache".equals(name)) {
                Cache c;
                Node cacheClass = subnode.getAttributes().getNamedItem("impl-class");
                if (cacheClass == null) {
                    c = new HashBelt();
                } else {
                    try {
                        c = (Cache)ReflectHelper.classForName(cacheClass.getNodeValue()).newInstance();
                        c.setClass(this.getPersistentClass().getName());
                    }
                    catch (Exception e) {
                        log.error((Object)"Could not instantiate cache", (Throwable)e);
                        throw new MappingException("Could not instantiate cache", e);
                    }
                }
                Node timeout = subnode.getAttributes().getNamedItem("timeout");
                c.setTimeout(timeout == null ? 0 : Integer.parseInt(timeout.getNodeValue()));
                String type = subnode.getAttributes().getNamedItem("type").getNodeValue();
                if (type.equals("readonly")) {
                    if (this.mutable) {
                        log.warn((Object)("readonly cache configured for mutable class: " + this.getPersistentClass().getName()));
                    }
                    this.cache = new ReadOnlyCache(c);
                } else if (type.equals("blocking")) {
                    log.warn((Object)"Blocking cache is no longer supported");
                    this.cache = new ReadWriteCache(c);
                } else {
                    this.cache = new ReadWriteCache(c);
                }
            } else if ("jcs-cache".equals(name)) {
                this.cache = root.createJCSCache(subnode, this.getPersistentClass().getName(), this);
            }
            ++i;
        }
        PrimaryKey pk = new PrimaryKey();
        pk.setTable(table);
        pk.setName(StringHelper.suffix(table.getName(), "PK"));
        Iterator iter = this.identifier.getColumnIterator();
        while (iter.hasNext()) {
            pk.addColumn((Column)iter.next());
        }
        table.setPrimaryKey(pk);
        this.propertiesFromXML(node, root);
    }

    public Property getVersion() {
        return this.version;
    }

    public void setVersion(Property version) {
        this.version = version;
    }

    public boolean isVersioned() {
        return this.version != null;
    }

    public CacheConcurrencyStrategy getCache() {
        return this.cache;
    }

    public boolean isMutable() {
        return this.mutable;
    }

    public boolean hasEmbeddedIdentifier() {
        return this.embeddedIdentifier;
    }

    public Class getPersister() {
        return this.persister;
    }

    public Table getRootTable() {
        return this.getTable();
    }

    public void setPersister(Class persister) {
        this.persister = persister;
    }

    public PersistentClass getSuperclass() {
        return null;
    }

    public Value getKey() {
        return this.getIdentifier();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

