/*
 * Decompiled with CFR 0.152.
 */
package cirrus.hibernate.metadata;

import cirrus.hibernate.HibernateException;
import cirrus.hibernate.SessionFactory;
import cirrus.hibernate.metadata.ClassMetadata;
import cirrus.hibernate.metadata.CollectionMetadata;
import cirrus.hibernate.type.AbstractComponentType;
import cirrus.hibernate.type.BagType;
import cirrus.hibernate.type.ListType;
import cirrus.hibernate.type.MapType;
import cirrus.hibernate.type.PersistentCollectionType;
import cirrus.hibernate.type.SetType;
import cirrus.hibernate.type.Type;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class Visitor {
    public static final boolean RECURSE = true;
    public static final boolean STOP = false;
    private SessionFactory factory;

    public Visitor(SessionFactory factory) {
        this.factory = factory;
    }

    public void visit(Object object) throws HibernateException {
        if (this.process(object)) {
            ClassMetadata cmd = this.factory.getClassMetadata(object.getClass());
            this.visitProperties(cmd.getPropertyValues(object), cmd.getPropertyTypes(), cmd.getPropertyNames(), object);
        }
    }

    public void visitProperties(Object[] values, Type[] types, String[] names, Object owner) throws HibernateException {
        int i = 0;
        while (i < values.length) {
            this.visitProperty(values[i], types[i], names[i], owner);
            ++i;
        }
    }

    public void visitProperty(Object value, Type type, String name, Object owner) throws HibernateException {
        if (type.isPersistentCollectionType()) {
            this.visitCollection(value, (PersistentCollectionType)type, owner);
        } else if (type.isComponentType()) {
            this.visitComponent(value, (AbstractComponentType)type, owner);
        } else if (type.isEntityType()) {
            this.visitAssociation(value, type, owner);
        } else {
            this.processPropertyValue(value, type, name, owner);
        }
    }

    public void visitElement(Object value, Type type, Object owner) throws HibernateException {
        if (type.isPersistentCollectionType()) {
            this.visitCollection(value, (PersistentCollectionType)type, owner);
        } else if (type.isComponentType()) {
            this.visitComponent(value, (AbstractComponentType)type, owner);
        } else if (type.isEntityType()) {
            this.visitAssociation(value, type, owner);
        } else {
            this.processElement(value, type, owner);
        }
    }

    public void visitAssociation(Object value, Type type, Object owner) throws HibernateException {
        if (this.processAssociation(value, owner)) {
            this.visit(value);
        }
    }

    public void visitComponent(Object value, AbstractComponentType type, Object owner) throws HibernateException {
        this.visitProperties(type.getPropertyValues(value), type.getSubtypes(), type.getPropertyNames(), owner);
    }

    public void visitCollection(Object collection, PersistentCollectionType type, Object owner) throws HibernateException {
        boolean shouldRecurse = true;
        if (type instanceof MapType) {
            shouldRecurse = this.processMap((Map)collection, owner);
        } else if (type instanceof SetType) {
            shouldRecurse = this.processSet((Set)collection, owner);
        } else if (type instanceof ListType) {
            shouldRecurse = this.processList((List)collection, owner);
        } else if (type instanceof BagType) {
            shouldRecurse = this.processBag((Collection)collection, owner);
        } else if (type.isArrayType()) {
            shouldRecurse = this.processArray(collection, owner);
        }
        if (shouldRecurse) {
            CollectionMetadata cmd = this.factory.getCollectionMetadata(type.getRole());
            Iterator iter = type.getElementsIterator(collection);
            while (iter.hasNext()) {
                this.visitElement(iter.next(), cmd.getElementType(), owner);
            }
        }
    }

    public boolean process(Object object) throws HibernateException {
        return true;
    }

    public boolean processMap(Map map, Object owner) throws HibernateException {
        return true;
    }

    public boolean processSet(Set set, Object owner) throws HibernateException {
        return true;
    }

    public boolean processList(List list, Object owner) throws HibernateException {
        return true;
    }

    public boolean processBag(Collection bag, Object owner) throws HibernateException {
        return true;
    }

    public boolean processArray(Object array, Object owner) throws HibernateException {
        return true;
    }

    public boolean processAssociation(Object value, Object owner) throws HibernateException {
        return false;
    }

    public void processPropertyValue(Object value, Type type, String propertyName, Object owner) throws HibernateException {
    }

    public void processElement(Object value, Type type, Object owner) throws HibernateException {
    }
}

