/*
 * Decompiled with CFR 0.152.
 */
package cirrus.hibernate.proxy;

import cirrus.hibernate.HibernateException;
import cirrus.hibernate.LazyInitializationException;
import cirrus.hibernate.engine.Key;
import cirrus.hibernate.engine.SessionImplementor;
import cirrus.hibernate.helpers.ReflectHelper;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.SQLException;
import org.apache.commons.logging.LogFactory;

public abstract class LazyInitializer {
    protected Object target = null;
    protected Serializable id;
    protected SessionImplementor session;
    protected Class persistentClass;
    protected Method getIdentifierMethod;
    protected boolean overridesEquals;
    static /* synthetic */ Class class$cirrus$hibernate$proxy$LazyInitializer;

    protected LazyInitializer(Class persistentClass, Serializable id, Method getIdentifierMethod, SessionImplementor session) {
        this.id = id;
        this.session = session;
        this.persistentClass = persistentClass;
        this.getIdentifierMethod = getIdentifierMethod;
        this.overridesEquals = ReflectHelper.overridesEquals(persistentClass);
    }

    public void initialize() throws HibernateException, SQLException {
        if (this.target == null) {
            if (this.session == null) {
                throw new HibernateException("Could not initialize proxy - no Session");
            }
            if (!this.session.isOpen()) {
                throw new HibernateException("Could not initialize proxy - the owning Session was closed");
            }
            this.target = this.session.immediateLoad(this.persistentClass, this.id);
        }
    }

    private void initializeWrapExceptions() {
        try {
            this.initialize();
        }
        catch (Exception e) {
            LogFactory.getLog((Class)(class$cirrus$hibernate$proxy$LazyInitializer == null ? (class$cirrus$hibernate$proxy$LazyInitializer = LazyInitializer.class$("cirrus.hibernate.proxy.LazyInitializer")) : class$cirrus$hibernate$proxy$LazyInitializer)).error((Object)"Exception initializing proxy", (Throwable)e);
            throw new LazyInitializationException(e);
        }
    }

    protected abstract Object serializableProxy();

    protected final Object invoke(Method method, Object[] args) throws Throwable {
        String methodName = method.getName();
        int params = method.getParameterTypes().length;
        if (params == 0) {
            if ("writeReplace".equals(methodName)) {
                if (this.target == null && this.session != null) {
                    this.target = this.session.getEntity(new Key(this.id, this.session.getFactory().getPersister(this.persistentClass)));
                }
                if (this.target == null) {
                    return this.serializableProxy();
                }
                return this.target;
            }
            if (!this.overridesEquals && "hashCode".equals(methodName)) {
                return new Integer(this.id.hashCode());
            }
            if (method.equals(this.getIdentifierMethod)) {
                return this.id;
            }
            if ("finalize".equals(method.getName())) {
                return null;
            }
        } else if (params == 1 && !this.overridesEquals && "equals".equals(methodName)) {
            return new Boolean(this.id.equals(this.getIdentifierMethod.invoke(args[0], null)));
        }
        try {
            return method.invoke(this.getImplementation(), args);
        }
        catch (InvocationTargetException ite) {
            throw ite.getTargetException();
        }
    }

    public final Serializable getIdentifier() {
        return this.id;
    }

    public final Class getPersistentClass() {
        return this.persistentClass;
    }

    public final boolean isUninitialized() {
        return this.target == null;
    }

    public final SessionImplementor getSession() {
        return this.session;
    }

    public final void setSession(SessionImplementor s) {
        if (s != this.session) {
            if (this.session != null && this.session.isOpen()) {
                throw new LazyInitializationException("Illegally attempted to associate a proxy with two open Sessions");
            }
            this.session = s;
        }
    }

    public final Object getImplementation() throws HibernateException, SQLException {
        this.initializeWrapExceptions();
        return this.target;
    }

    public final Object getImplementation(SessionImplementor s) throws HibernateException {
        return s.getEntity(new Key(this.getIdentifier(), s.getFactory().getPersister(this.getPersistentClass())));
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

