/*
 * JBoss, Home of Professional Open Source.
 * Copyright 2006, Red Hat Middleware LLC, and individual contributors
 * as indicated by the @author tags. See the copyright.txt file in the
 * distribution for a full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.ejb3.test.persistenceunits;

import java.util.List;

import javax.ejb.Remote;
import javax.ejb.Stateless;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import org.jboss.annotation.ejb.RemoteBinding;

/**
 * UserManagerBean
 *
 * @author Jaikiran Pai
 * @version $Revision: $
 */
@Stateless
@Remote (UserManager.class)
@RemoteBinding(jndiBinding = UserManager.JNDI_NAME)
public class UserManagerBean implements UserManager
{

   @PersistenceContext (unitName="same-name-pu")
   private EntityManager em;
   
   public User addUser(String name)
   {
      User user = new User();
      user.setName(name);
      this.em.persist(user);
      return user;
   }

   public List<User> getUsers()
   {
      return this.em.createNamedQuery(User.FIND_ALL).getResultList();
   }

}
