/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security.auth.message.config;

import java.util.Iterator;
import java.util.Map;
import javax.security.auth.Subject;
import javax.security.auth.message.AuthException;
import javax.security.auth.message.AuthParam;
import javax.security.auth.message.AuthStatus;
import javax.security.auth.message.config.ClientAuthContext;
import javax.security.auth.message.module.ClientAuthModule;
import org.jboss.security.auth.message.config.JBossClientAuthConfig;

public class JBossClientAuthContext
implements ClientAuthContext {
    private JBossClientAuthConfig config;

    public JBossClientAuthContext(JBossClientAuthConfig config) {
        if (config == null) {
            throw new IllegalArgumentException("config is null");
        }
        this.config = config;
    }

    public AuthStatus cleanSubject(Subject subject, Map sharedState) throws AuthException {
        AuthStatus status = null;
        Iterator iter = this.config.getClientAuthModules().iterator();
        while (iter.hasNext() && (status = ((ClientAuthModule)iter.next()).cleanSubject(subject, sharedState)) != AuthStatus.FAIL) {
        }
        return status;
    }

    public AuthStatus secureRequest(AuthParam authParam, Subject client, Map sharedState) throws AuthException {
        Iterator iter = this.config.getClientAuthModules().iterator();
        AuthStatus status = null;
        while (iter.hasNext() && (status = ((ClientAuthModule)iter.next()).secureRequest(authParam, client, sharedState)) != AuthStatus.FAIL) {
        }
        return status;
    }

    public AuthStatus validateResponse(AuthParam authParam, Subject client, Subject service, Map sharedState) throws AuthException {
        Iterator iter = this.config.getClientAuthModules().iterator();
        AuthStatus status = null;
        while (iter.hasNext() && (status = ((ClientAuthModule)iter.next()).validateResponse(authParam, client, service, sharedState)) != AuthStatus.FAIL) {
        }
        return status;
    }
}

