/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tm.remoting.server;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.management.ObjectName;
import javax.naming.InitialContext;
import org.jboss.remoting.InvokerLocator;
import org.jboss.system.ServiceMBeanSupport;
import org.jboss.tm.TMUtil;
import org.jboss.tm.TxManager;
import org.jboss.tm.remoting.RemoteProxy;
import org.jboss.tm.remoting.client.ClientUserTransaction;
import org.jboss.tm.remoting.interfaces.TransactionFactory;
import org.jboss.tm.remoting.server.DTMInvocationHandler;
import org.jboss.tm.remoting.server.DTMServant;
import org.jboss.tm.remoting.server.DistributedTransactionManagerMBean;

public class DistributedTransactionManager
extends ServiceMBeanSupport
implements DistributedTransactionManagerMBean {
    public static final String SUBSYSTEM = "DTM";
    private static final String[] addInvocationHandlerSignature = new String[]{"java.lang.String", "org.jboss.remoting.ServerInvocationHandler"};
    private static final String[] removeInvocationHandlerSignature = new String[]{"java.lang.String"};
    private static final Object[] removeInvocationHandlerParams = new Object[]{"DTM"};
    public static final String USER_TRANSACTION_JNDI_NAME = "UserTransaction";
    private List connectors;
    private InvokerLocator[] locators;
    private String[] locatorURIs;
    private boolean interpositionEnabled;

    protected void startService() throws Exception {
        DTMServant dtmServant = new DTMServant(this);
        ArrayList<InvokerLocator> locatorList = new ArrayList<InvokerLocator>();
        ArrayList<String> locatorURIList = new ArrayList<String>();
        Iterator i = this.connectors.iterator();
        while (i.hasNext()) {
            ObjectName objectName = (ObjectName)i.next();
            this.getServer().invoke(objectName, "addInvocationHandler", new Object[]{SUBSYSTEM, new DTMInvocationHandler(dtmServant)}, addInvocationHandlerSignature);
            this.getLog().debug("Added DTM invocation handler to connector " + objectName);
            InvokerLocator locator = (InvokerLocator)this.getServer().getAttribute(objectName, "Locator");
            locatorList.add(locator);
            String locatorURI = locator.getLocatorURI();
            locatorURIList.add(locatorURI);
        }
        this.locators = locatorList.toArray(new InvokerLocator[0]);
        this.locatorURIs = locatorURIList.toArray(new String[0]);
        TxManager tm = (TxManager)TMUtil.getTransactionManager();
        tm.setDTMEnabled(true);
        tm.setDTMCoordinatorFactory(dtmServant);
        tm.setDTMResourceFactory(dtmServant);
        tm.setDTMStringRemoteRefConverter(dtmServant);
        tm.setInterpositionEnabled(this.interpositionEnabled);
        InitialContext ctx = new InitialContext();
        TransactionFactory transactionFactory = (TransactionFactory)RemoteProxy.create(TransactionFactory.class, 0L, this.locators);
        ctx.bind("DTMTransactionFactory", (Object)transactionFactory);
        ctx.bind(USER_TRANSACTION_JNDI_NAME, (Object)ClientUserTransaction.getSingleton());
    }

    protected void stopService() throws Exception {
        TxManager tm = (TxManager)TMUtil.getTransactionManager();
        tm.setDTMResourceFactory(null);
        Iterator i = this.connectors.iterator();
        while (i.hasNext()) {
            ObjectName objectName = (ObjectName)i.next();
            this.getServer().invoke(objectName, "removeInvocationHandler", removeInvocationHandlerParams, removeInvocationHandlerSignature);
            this.getLog().debug("Removed DTM invocation handler from connector " + objectName);
        }
        tm.setDTMEnabled(false);
        tm.setDTMCoordinatorFactory(null);
        tm.setDTMResourceFactory(null);
        InitialContext ctx = new InitialContext();
        ctx.unbind("DTMTransactionFactory");
        ctx.unbind(USER_TRANSACTION_JNDI_NAME);
    }

    public List getConnectors() {
        return this.connectors;
    }

    public void setConnectors(List connectors) {
        this.connectors = connectors;
    }

    public InvokerLocator[] getLocators() {
        return this.locators;
    }

    public String[] getLocatorURIs() {
        return this.locatorURIs;
    }

    public boolean getInterpositionEnabled() {
        return this.interpositionEnabled;
    }

    public void setInterpositionEnabled(boolean newValue) {
        this.interpositionEnabled = newValue;
        if (this.getState() == 3) {
            TxManager tm = (TxManager)TMUtil.getTransactionManager();
            tm.setInterpositionEnabled(newValue);
        }
    }
}

