/*
 * Decompiled with CFR 0.152.
 */
package com.icesoft.faces.webapp.http.core;

import com.icesoft.faces.context.BridgeFacesContext;
import com.icesoft.faces.context.View;
import com.icesoft.faces.webapp.command.Command;
import com.icesoft.faces.webapp.command.SessionExpired;
import com.icesoft.faces.webapp.http.common.Request;
import com.icesoft.faces.webapp.http.common.Response;
import com.icesoft.faces.webapp.http.common.ResponseHandler;
import com.icesoft.faces.webapp.http.common.Server;
import com.icesoft.faces.webapp.http.common.standard.FixedXMLContentHandler;
import com.icesoft.faces.webapp.http.core.SessionExpiredException;
import com.icesoft.faces.webapp.http.servlet.SessionDispatcher;
import java.io.IOException;
import java.io.Writer;
import java.util.Map;
import javax.faces.FacesException;

public class ViewBoundServer
implements Server {
    private static final Command SessionExpired = new SessionExpired();
    private static final FixedXMLContentHandler SessionExpiredHandler = new FixedXMLContentHandler(){

        public void writeTo(Writer writer) throws IOException {
            SessionExpired.serializeTo(writer);
        }
    };
    private static final ResponseHandler MissingParameterHandler = new ResponseHandler(){

        public void respond(Response response) throws Exception {
            response.setStatus(500);
            response.writeBody().write("Cannot match view instance. 'ice.view' parameter is missing.".getBytes());
        }
    };
    private Map views;
    private SessionDispatcher.Monitor sessionMonitor;
    private Server server;

    public ViewBoundServer(Server server, SessionDispatcher.Monitor sessionMonitor, Map views) {
        this.server = server;
        this.sessionMonitor = sessionMonitor;
        this.views = views;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void service(Request request) throws Exception {
        String viewNumber = request.getParameter("ice.view");
        if (viewNumber == null) {
            request.respondWith(MissingParameterHandler);
        } else {
            View view = (View)this.views.get(viewNumber);
            if (view == null) {
                request.respondWith(SessionExpiredHandler);
            } else {
                BridgeFacesContext bridgeFacesContext = view.getFacesContext();
                synchronized (bridgeFacesContext) {
                    try {
                        view.updateOnXMLHttpRequest(request);
                        this.sessionMonitor.touchSession();
                        this.server.service(request);
                    }
                    catch (FacesException e) {
                        Throwable nestedException = e.getCause();
                        if (nestedException == null || nestedException instanceof Error) {
                            throw e;
                        }
                        throw (Exception)nestedException;
                    }
                    catch (SessionExpiredException e) {
                        request.respondWith(SessionExpiredHandler);
                    }
                    finally {
                        view.release();
                    }
                }
            }
        }
    }

    public void shutdown() {
        this.server.shutdown();
    }
}

