/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dbtech.jdbc.translators;

import com.sap.dbtech.jdbc.translators.CharDataTranslator;
import com.sap.dbtech.jdbc.translators.SQLParamController;
import com.sap.dbtech.util.StructuredMem;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;

class TimeTranslator
extends CharDataTranslator {
    protected TimeTranslator(int n, int n2, int n3, int n4, int n5, int n6) {
        super(n, n2, n3, n4, n5, n6);
    }

    public Object getObject(SQLParamController sQLParamController, StructuredMem structuredMem) throws SQLException {
        return this.getTime(sQLParamController, structuredMem);
    }

    public Time getTime(SQLParamController sQLParamController, StructuredMem structuredMem) throws SQLException {
        Time time = null;
        if (!this.isNull(sQLParamController, structuredMem)) {
            String string = structuredMem.getString(this.bufpos, this.physicalLength - 1);
            time = Time.valueOf(string);
        }
        return time;
    }

    public Timestamp getTimestamp(SQLParamController sQLParamController, StructuredMem structuredMem) throws SQLException {
        Time time = this.getTime(sQLParamController, structuredMem);
        if (time == null) {
            return null;
        }
        Timestamp timestamp = new Timestamp(time.getTime());
        return timestamp;
    }

    public boolean isCaseSensitive() {
        return false;
    }

    public Object transSpecificForInput(Object object) throws SQLException {
        Object object2 = null;
        if (object instanceof Time) {
            object2 = this.transTimeForInput((Time)object);
        }
        return object2;
    }

    public Object transStringForInput(String string) throws SQLException {
        if (string == null) {
            return null;
        }
        try {
            return this.transTimeForInput(Time.valueOf(string));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            try {
                Timestamp timestamp = Timestamp.valueOf(string);
                return this.transTimeForInput(new Time(timestamp.getTime()));
            }
            catch (IllegalArgumentException illegalArgumentException2) {
                throw this.newParseException(string, "Time");
            }
        }
    }

    public Object transTimeForInput(Time time) throws SQLException {
        if (time == null) {
            return null;
        }
        return time.toString();
    }
}

