/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.protocols;

import java.util.Arrays;
import java.util.Vector;
import junit.framework.TestCase;
import org.jgroups.Address;
import org.jgroups.Event;
import org.jgroups.TimeoutException;
import org.jgroups.View;
import org.jgroups.protocols.pbcast.Digest;
import org.jgroups.protocols.pbcast.NAKACK;
import org.jgroups.stack.IpAddress;
import org.jgroups.stack.Protocol;
import org.jgroups.util.Promise;

public class NAKACK_SET_DIGEST_Test
extends TestCase {
    private NAKACK nak;
    private Digest d1;
    private Digest d2;
    private Address a;
    private Address b;
    private Address c;

    protected void setUp() throws Exception {
        super.setUp();
        this.a = new IpAddress(5000);
        this.b = new IpAddress(6000);
        this.c = new IpAddress(7000);
        this.nak = new NAKACK();
        this.d1 = new Digest(2);
        this.d1.add(this.a, 0L, 10L, 10L);
        this.d1.add(this.b, 0L, 30L, 30L);
        this.d2 = new Digest(3);
        this.d2.add(this.a, 0L, 10L, 11L);
        this.d2.add(this.b, 0L, 35L, 35L);
        this.d2.add(this.c, 10L, 50L, 50L);
        this.nak.setDownProtocol(new Protocol(){

            public String getName() {
                return "blo";
            }

            public void down(Event evt) {
            }
        });
        View view = new View(this.a, 1L, new Vector<Address>(Arrays.asList(this.a, this.b, this.c)));
        this.nak.down(new Event(6, view));
    }

    public void testSetDigest() throws TimeoutException {
        MyProtocol prot = new MyProtocol();
        this.nak.setUpProtocol(prot);
        System.out.println("d1: " + this.d1);
        System.out.println("d2: " + this.d2);
        System.out.println("setting d2:");
        this.nak.down(new Event(41, this.d2));
        this.nak.down(new Event(39));
        Digest digest = (Digest)prot.promise.getResultWithTimeout(5000L);
        System.out.println("digest = " + digest);
        NAKACK_SET_DIGEST_Test.assertEquals((int)3, (int)digest.size());
        NAKACK_SET_DIGEST_Test.assertTrue((boolean)digest.contains(this.a));
        NAKACK_SET_DIGEST_Test.assertTrue((boolean)digest.contains(this.b));
        NAKACK_SET_DIGEST_Test.assertTrue((boolean)digest.contains(this.c));
        System.out.println("setting d1:");
        this.nak.down(new Event(41, this.d1));
        this.nak.down(new Event(39));
        digest = (Digest)prot.promise.getResultWithTimeout(5000L);
        System.out.println("digest = " + digest);
        NAKACK_SET_DIGEST_Test.assertEquals((int)3, (int)digest.size());
        NAKACK_SET_DIGEST_Test.assertTrue((boolean)digest.contains(this.a));
        NAKACK_SET_DIGEST_Test.assertTrue((boolean)digest.contains(this.b));
        NAKACK_SET_DIGEST_Test.assertTrue((boolean)digest.contains(this.c));
    }

    private static class MyProtocol
    extends Protocol {
        private Promise promise = new Promise();

        private MyProtocol() {
        }

        public String getName() {
            return "bla";
        }

        public void up(Event evt) {
            if (evt.getType() == 40) {
                this.promise.setResult(evt.getArg());
            }
        }
    }
}

