/*
 * Decompiled with CFR 0.152.
 */
package cirrus.hibernate.impl;

import cirrus.hibernate.HibernateException;
import cirrus.hibernate.LazyInitializationException;
import cirrus.hibernate.engine.SessionImplementor;
import cirrus.hibernate.type.Type;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class IteratorImpl
implements Iterator {
    private static final Log log = LogFactory.getLog((Class)(class$cirrus$hibernate$impl$IteratorImpl == null ? (class$cirrus$hibernate$impl$IteratorImpl = IteratorImpl.class$("cirrus.hibernate.impl.IteratorImpl")) : class$cirrus$hibernate$impl$IteratorImpl));
    private final ResultSet rs;
    private final SessionImplementor sess;
    private final Type[] types;
    private final boolean single;
    private Object[] nextResults;
    private Object[] currentResults;
    private boolean hasNext;
    private final String[][] names;
    static /* synthetic */ Class class$cirrus$hibernate$impl$IteratorImpl;

    public IteratorImpl(ResultSet rs, SessionImplementor sess, Type[] types, String[][] columnNames) throws HibernateException, SQLException {
        this.rs = rs;
        this.sess = sess;
        this.types = types;
        this.names = columnNames;
        this.single = types.length == 1;
        this.postNext(rs.next());
    }

    private void postNext(boolean hasNext) throws HibernateException, SQLException {
        this.hasNext = hasNext;
        if (!hasNext) {
            this.nextResults = null;
            this.rs.close();
        } else {
            this.nextResults = new Object[this.types.length];
            int i = 0;
            while (i < this.types.length) {
                this.nextResults[i] = this.types[i].nullSafeGet(this.rs, this.names[i], this.sess, null);
                ++i;
            }
        }
    }

    public boolean hasNext() {
        return this.hasNext;
    }

    public Object next() {
        if (this.nextResults == null) {
            throw new NoSuchElementException("No more results");
        }
        try {
            this.currentResults = this.nextResults;
            this.postNext(this.rs.next());
            if (this.single) {
                return this.currentResults[0];
            }
            return this.currentResults;
        }
        catch (Exception sqle) {
            log.error((Object)"could not get next result", (Throwable)sqle);
            throw new LazyInitializationException(sqle);
        }
    }

    public void remove() {
        if (!this.single) {
            throw new UnsupportedOperationException("Not a single column hibernate query result set");
        }
        if (this.currentResults == null) {
            throw new IllegalStateException("Called Iterator.remove() before next()");
        }
        try {
            this.sess.delete(this.currentResults[0]);
        }
        catch (Exception sqle) {
            log.error((Object)"could not remove", (Throwable)sqle);
            throw new LazyInitializationException(sqle);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

