/*
 * Decompiled with CFR 0.152.
 */
package cirrus.hibernate.odmg;

import cirrus.hibernate.HibernateException;
import cirrus.hibernate.Query;
import cirrus.hibernate.odmg.Database;
import cirrus.hibernate.odmg.Implementation;
import cirrus.hibernate.odmg.Transaction;
import java.sql.SQLException;
import org.odmg.ODMGRuntimeException;
import org.odmg.QueryException;
import org.odmg.QueryInvalidException;
import org.odmg.QueryParameterCountInvalidException;
import org.odmg.QueryParameterTypeInvalidException;

public class OQLQuery
implements org.odmg.OQLQuery {
    private Transaction tx;
    private Query query;
    private int param = 0;

    public OQLQuery(Database db) {
        this.tx = db.currentTransaction();
    }

    public OQLQuery(Transaction tx) {
        this.tx = tx;
    }

    public OQLQuery() {
        this.tx = (Transaction)Implementation.getInstance().currentTransaction();
    }

    public Query getQuery() {
        return this.query;
    }

    public void create(String queryString) throws QueryInvalidException {
        try {
            this.query = this.tx.getSession().createQuery(queryString);
        }
        catch (HibernateException he) {
            throw new ODMGRuntimeException(he.getMessage());
        }
    }

    public void bind(Object parameter) throws QueryParameterCountInvalidException, QueryParameterTypeInvalidException {
        try {
            this.query.setParameter(this.param++, parameter);
        }
        catch (HibernateException he) {
            throw new ODMGRuntimeException(he.getMessage());
        }
    }

    public Object execute() throws QueryException {
        try {
            return this.query.list();
        }
        catch (SQLException sqle) {
            throw new QueryException(sqle.getMessage());
        }
        catch (HibernateException he) {
            throw new QueryException(he.getMessage());
        }
    }
}

