/*
 * Decompiled with CFR 0.152.
 */
package cirrus.hibernate.tools;

import cirrus.hibernate.helpers.DTDEntityResolver;
import cirrus.hibernate.tools.codegen.ClassMapping;
import cirrus.hibernate.tools.codegen.Generator;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.input.SAXBuilder;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXParseException;

public class CodeGenerator {
    public static void main(String[] args) {
        try {
            ArrayList<String> mappingFiles = new ArrayList<String>();
            SAXBuilder builder = new SAXBuilder();
            builder.setEntityResolver((EntityResolver)new DTDEntityResolver());
            builder.setErrorHandler(new ErrorHandler(){

                public void error(SAXParseException error) {
                    System.err.println("Error parsing XML: " + error.getSystemId() + '(' + error.getLineNumber() + ')');
                    error.printStackTrace();
                }

                public void fatalError(SAXParseException error) {
                    this.error(error);
                }

                public void warning(SAXParseException error) {
                    System.err.println("Warning parsing XML: " + error.getSystemId() + '(' + error.getLineNumber() + ')');
                }
            });
            String outputDir = null;
            ArrayList<Generator> generators = new ArrayList<Generator>();
            int i = 0;
            while (i < args.length) {
                if (args[i].startsWith("--")) {
                    if (args[i].startsWith("--config=")) {
                        Document document = builder.build(new File(args[i].substring(9)));
                        Iterator generateElements = document.getRootElement().getChildren("generate").iterator();
                        while (generateElements.hasNext()) {
                            generators.add(new Generator((Element)generateElements.next()));
                        }
                    } else if (args[i].startsWith("--output=")) {
                        outputDir = args[i].substring(9);
                    }
                } else {
                    mappingFiles.add(args[i]);
                }
                ++i;
            }
            if (generators.size() == 0) {
                generators.add(new Generator());
            }
            HashMap<String, ClassMapping> classMappings = new HashMap<String, ClassMapping>();
            Iterator iter = mappingFiles.iterator();
            while (iter.hasNext()) {
                Document document = builder.build(new File((String)iter.next()));
                Iterator classElements = document.getRootElement().getChildren("class").iterator();
                while (classElements.hasNext()) {
                    ClassMapping cmap = new ClassMapping((Element)classElements.next());
                    classMappings.put(cmap.getCanonicalName(), cmap);
                }
            }
            Iterator iterator = generators.iterator();
            while (iterator.hasNext()) {
                Generator g = (Generator)iterator.next();
                g.setBaseDirName(outputDir);
                g.generate(classMappings);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

