/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.com.sun.xml.ws.encoding.soap;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.ws.Holder;
import org.jboss.com.sun.xml.ws.binding.BindingImpl;
import org.jboss.com.sun.xml.ws.encoding.internal.InternalEncoder;
import org.jboss.com.sun.xml.ws.encoding.jaxb.JAXBBridgeInfo;
import org.jboss.com.sun.xml.ws.encoding.soap.EncoderDecoder;
import org.jboss.com.sun.xml.ws.encoding.soap.SerializationException;
import org.jboss.com.sun.xml.ws.encoding.soap.internal.AttachmentBlock;
import org.jboss.com.sun.xml.ws.encoding.soap.internal.BodyBlock;
import org.jboss.com.sun.xml.ws.encoding.soap.internal.HeaderBlock;
import org.jboss.com.sun.xml.ws.encoding.soap.internal.InternalMessage;
import org.jboss.com.sun.xml.ws.model.CheckedException;
import org.jboss.com.sun.xml.ws.model.ExceptionType;
import org.jboss.com.sun.xml.ws.model.JavaMethod;
import org.jboss.com.sun.xml.ws.model.Parameter;
import org.jboss.com.sun.xml.ws.model.ParameterBinding;
import org.jboss.com.sun.xml.ws.model.RuntimeModel;
import org.jboss.com.sun.xml.ws.model.WrapperParameter;
import org.jboss.com.sun.xml.ws.model.soap.SOAPBinding;
import org.jboss.com.sun.xml.ws.model.soap.SOAPRuntimeModel;
import org.jboss.com.sun.xml.ws.pept.ept.MessageInfo;
import org.jboss.com.sun.xml.ws.server.RuntimeContext;
import org.jboss.com.sun.xml.ws.util.MessageInfoUtil;
import org.jboss.com.sun.xml.ws.util.StringUtils;

public class ServerEncoderDecoder
extends EncoderDecoder
implements InternalEncoder {
    public void toMessageInfo(Object intMessage, MessageInfo mi) {
        InternalMessage im = (InternalMessage)intMessage;
        RuntimeContext rtContext = (RuntimeContext)mi.getMetaData("org.jboss.com.sun.xml.ws.runtime.context");
        BodyBlock bodyBlock = im.getBody();
        JavaMethod jm = rtContext.getModel().getJavaMethod(mi.getMethod());
        mi.setMEP(jm.getMEP());
        List<HeaderBlock> headers = im.getHeaders();
        Map<String, AttachmentBlock> attachments = im.getAttachments();
        Iterator<Parameter> iter = jm.getRequestParameters().iterator();
        Object bodyValue = bodyBlock == null ? null : bodyBlock.getValue();
        int numInputParams = jm.getInputParametersCount();
        Object[] data = new Object[numInputParams];
        SOAPBinding soapBinding = (SOAPBinding)jm.getBinding();
        while (iter.hasNext()) {
            Parameter param = iter.next();
            ParameterBinding paramBinding = param.getInBinding();
            Object obj = null;
            if (paramBinding.isBody()) {
                obj = bodyValue;
            } else if (headers != null && paramBinding.isHeader()) {
                HeaderBlock header = this.getHeaderBlock(param.getName(), headers);
                obj = header != null ? header.getValue() : null;
            } else if (paramBinding.isAttachment()) {
                obj = this.getAttachment(rtContext, attachments, param, paramBinding);
            }
            this.fillData(rtContext, param, obj, data, soapBinding, paramBinding);
        }
        for (Parameter p : jm.getResponseParameters()) {
            this.createOUTHolders(p, data);
        }
        mi.setData(data);
    }

    public Object toInternalMessage(MessageInfo mi) {
        RuntimeContext rtContext = MessageInfoUtil.getRuntimeContext(mi);
        RuntimeModel model = rtContext.getModel();
        JavaMethod jm = model.getJavaMethod(mi.getMethod());
        Object[] data = mi.getData();
        Object result = mi.getResponse();
        InternalMessage im = new InternalMessage();
        if (rtContext.getHandlerContext() != null) {
            this.copyAttachmentProperty((Map<String, Object>)rtContext.getHandlerContext().getMessageContext(), im);
        }
        BindingImpl bindingImpl = (BindingImpl)rtContext.getRuntimeEndpointInfo().getBinding();
        String bindingId = bindingImpl.getBindingId();
        switch (mi.getResponseType()) {
            case 1: {
                if (!(result instanceof Exception)) {
                    throw new SerializationException("exception.incorrectType", result.getClass().toString());
                }
                CheckedException ce = jm.getCheckedException(result.getClass());
                if (ce == null) {
                    throw new SerializationException("exception.notfound", result.getClass().toString());
                }
                Object detail = this.getDetail(jm.getCheckedException(result.getClass()), result);
                JAXBBridgeInfo di = new JAXBBridgeInfo(model.getBridge(ce.getDetailType()), detail);
                if (bindingId.equals("http://schemas.xmlsoap.org/wsdl/soap/http")) {
                    SOAPRuntimeModel.createFaultInBody(result, null, di, im);
                } else if (bindingId.equals("http://www.w3.org/2003/05/soap/bindings/HTTP/")) {
                    SOAPRuntimeModel.createSOAP12FaultInBody(result, null, null, di, im);
                }
                return im;
            }
            case 2: {
                if (bindingId.equals("http://schemas.xmlsoap.org/wsdl/soap/http")) {
                    SOAPRuntimeModel.createFaultInBody(result, this.getActor(), null, im);
                } else if (bindingId.equals("http://www.w3.org/2003/05/soap/bindings/HTTP/")) {
                    SOAPRuntimeModel.createSOAP12FaultInBody(result, null, null, null, im);
                }
                return im;
            }
        }
        SOAPBinding soapBinding = (SOAPBinding)jm.getBinding();
        for (Parameter param : jm.getResponseParameters()) {
            ParameterBinding paramBinding = param.getOutBinding();
            Object obj = this.createPayload(rtContext, param, data, result, soapBinding, paramBinding);
            if (paramBinding.isBody()) {
                im.setBody(new BodyBlock(obj));
                continue;
            }
            if (paramBinding.isHeader()) {
                im.addHeader(new HeaderBlock((JAXBBridgeInfo)obj));
                continue;
            }
            if (!paramBinding.isAttachment()) continue;
            this.addAttachmentPart(rtContext, im, obj, param);
        }
        return im;
    }

    private Object getDetail(CheckedException ce, Object exception) {
        if (ce.getExceptionType().equals((Object)ExceptionType.UserDefined)) {
            return this.createDetailFromUserDefinedException(ce, exception);
        }
        try {
            Method m = exception.getClass().getMethod("getFaultInfo", new Class[0]);
            return m.invoke(exception, new Object[0]);
        }
        catch (Exception e) {
            throw new SerializationException(e);
        }
    }

    private Object createDetailFromUserDefinedException(CheckedException ce, Object exception) {
        Class detailBean = ce.getDetailBean();
        Field[] fields = detailBean.getDeclaredFields();
        try {
            Object detail = detailBean.newInstance();
            for (Field f : fields) {
                Method em = exception.getClass().getMethod(this.getReadMethod(f), new Class[0]);
                Method sm = detailBean.getMethod(this.getWriteMethod(f), em.getReturnType());
                sm.invoke(detail, em.invoke(exception, new Object[0]));
            }
            return detail;
        }
        catch (Exception e) {
            throw new SerializationException(e);
        }
    }

    private String getReadMethod(Field f) {
        if (f.getType().isAssignableFrom(Boolean.TYPE)) {
            return "is" + StringUtils.capitalize(f.getName());
        }
        return "get" + StringUtils.capitalize(f.getName());
    }

    private String getWriteMethod(Field f) {
        return "set" + StringUtils.capitalize(f.getName());
    }

    public String getActor() {
        return null;
    }

    private void createOUTHolders(Parameter param, Object[] data) {
        if (param.isWrapperStyle()) {
            for (Parameter p : ((WrapperParameter)param).getWrapperChildren()) {
                if (p.isResponse() || !p.isOUT()) continue;
                data[p.getIndex()] = new Holder();
            }
            return;
        }
        if (!param.isResponse() && param.isOUT()) {
            data[param.getIndex()] = new Holder();
        }
    }
}

