/*
 * Decompiled with CFR 0.152.
 */
package com.arjuna.ats.internal.jta.resources.arjunacore;

import com.arjuna.ats.arjuna.common.Uid;
import com.arjuna.ats.arjuna.coordinator.AbstractRecord;
import com.arjuna.ats.arjuna.gandiva.ClassName;
import com.arjuna.ats.arjuna.recovery.RecoveryManager;
import com.arjuna.ats.arjuna.recovery.RecoveryModule;
import com.arjuna.ats.arjuna.state.InputObjectState;
import com.arjuna.ats.arjuna.state.OutputObjectState;
import com.arjuna.ats.internal.jta.recovery.arjunacore.XARecoveryModule;
import com.arjuna.ats.internal.jta.resources.XAResourceErrorHandler;
import com.arjuna.ats.internal.jta.transaction.arjunacore.TransactionImple;
import com.arjuna.ats.jta.common.jtaPropertyManager;
import com.arjuna.ats.jta.logging.jtaLogger;
import com.arjuna.ats.jta.resources.EndXAResource;
import com.arjuna.ats.jta.resources.StartXAResource;
import com.arjuna.ats.jta.utils.XAHelper;
import com.arjuna.ats.jta.xa.RecoverableXAConnection;
import com.arjuna.ats.jta.xa.XidImple;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.NotSerializableException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Vector;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;

public class XAResourceRecord
extends AbstractRecord {
    public static final int XACONNECTION = 0;
    private static final Uid START_XARESOURCE;
    private static final Uid END_XARESOURCE;
    protected XAResource _theXAResource;
    private RecoverableXAConnection _recoveryObject;
    private Xid _tranID;
    private boolean _prepared;
    private boolean _valid;
    private int _heuristic;
    private TransactionImple _theTransaction;
    private boolean _recovered = false;
    private static boolean _rollbackOptimization;
    private static boolean _assumedComplete;

    public XAResourceRecord(TransactionImple tx, XAResource res, Xid xid, Object[] params) {
        super(new Uid(), null, 1);
        if (jtaLogger.logger.isDebugEnabled()) {
            jtaLogger.logger.debug(1L, 4L, 1L, "XAResourceRecord.XAResourceRecord ( " + xid + " )");
        }
        this._theXAResource = res;
        this._recoveryObject = null;
        this._tranID = xid;
        this._valid = true;
        if (params != null && params.length >= 0 && params[0] instanceof RecoverableXAConnection) {
            this._recoveryObject = (RecoverableXAConnection)params[0];
        }
        this._prepared = false;
        this._heuristic = 7;
        this._theTransaction = tx;
    }

    public void finalize() {
        if (this._theTransaction != null) {
            this._theTransaction = null;
        }
    }

    public final Xid getXid() {
        return this._tranID;
    }

    public Uid order() {
        if (this._theXAResource instanceof StartXAResource) {
            return START_XARESOURCE;
        }
        if (this._theXAResource instanceof EndXAResource) {
            return END_XARESOURCE;
        }
        return super.order();
    }

    public boolean propagateOnCommit() {
        return false;
    }

    public int typeIs() {
        return 171;
    }

    public ClassName className() {
        return new ClassName("RecordType.JTA_RECORD");
    }

    public Object value() {
        return this._theXAResource;
    }

    public void setValue(Object o) {
        if (jtaLogger.loggerI18N.isWarnEnabled()) {
            jtaLogger.loggerI18N.warn("com.arjuna.ats.internal.jta.resources.arjunacore.setvalue", new Object[]{"XAResourceRecord::set_value()"});
        }
    }

    public int nestedAbort() {
        return 7;
    }

    public int nestedCommit() {
        return 7;
    }

    public int nestedPrepare() {
        return 0;
    }

    public int topLevelPrepare() {
        if (jtaLogger.logger.isDebugEnabled()) {
            jtaLogger.logger.debug(16L, 4L, 1L, "XAResourceRecord.topLevelPrepare for " + this._tranID);
        }
        if (!this._valid || this._theXAResource == null) {
            this.removeConnection();
            return 2;
        }
        if (this._tranID == null) {
            if (jtaLogger.loggerI18N.isWarnEnabled()) {
                jtaLogger.loggerI18N.warn("com.arjuna.ats.internal.jta.resources.arjunacore.preparenulltx", new Object[]{"XAResourceRecord.prepare"});
            }
            this.removeConnection();
            return 1;
        }
        try {
            if (this.endAssociation()) {
                this._theXAResource.end(this._tranID, 0x4000000);
            }
            this._prepared = true;
            if (this._theXAResource.prepare(this._tranID) == 3) {
                return 2;
            }
            return 0;
        }
        catch (XAException e1) {
            if (jtaLogger.loggerI18N.isWarnEnabled()) {
                jtaLogger.loggerI18N.warn("com.arjuna.ats.internal.jta.resources.arjunacore.preparefailed", new Object[]{"XAResourceRecord.prepare", XAHelper.printXAErrorCode(e1)});
            }
            if (_rollbackOptimization) {
                this.removeConnection();
            }
            switch (e1.errorCode) {
                case -7: 
                case -6: 
                case -5: 
                case -4: 
                case -3: 
                case 100: 
                case 101: 
                case 102: 
                case 103: 
                case 104: 
                case 105: 
                case 106: 
                case 107: {
                    return 1;
                }
            }
            return 6;
        }
        catch (Exception e2) {
            if (jtaLogger.loggerI18N.isWarnEnabled()) {
                jtaLogger.loggerI18N.warn("com.arjuna.ats.internal.jta.resources.arjunacore.preparefailed", new Object[]{"XAResourceRecord.prepare", e2});
            }
            if (_rollbackOptimization) {
                this.removeConnection();
            }
            return 1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int topLevelAbort() {
        if (jtaLogger.logger.isDebugEnabled()) {
            jtaLogger.logger.debug(16L, 4L, 1L, "XAResourceRecord.topLevelAbort for " + this._tranID);
        }
        if (!this._valid) {
            return 8;
        }
        if (this._theTransaction != null && this._theTransaction.getXAResourceState(this._theXAResource) == 4) {
            return 7;
        }
        if (this._tranID == null) {
            if (!jtaLogger.loggerI18N.isWarnEnabled()) return 8;
            jtaLogger.loggerI18N.warn("com.arjuna.ats.internal.jta.resources.arjunacore.rollbacknulltx", new Object[]{"XAResourceRecord.rollback"});
            return 8;
        }
        if (this._theXAResource == null) {
            this._theXAResource = this.getNewXAResource();
        }
        if (this._theXAResource != null) {
            if (this._heuristic != 7) {
                return this._heuristic;
            }
            try {
                if (!this._prepared && this.endAssociation()) {
                    this._theXAResource.end(this._tranID, 0x4000000);
                }
                this._theXAResource.rollback(this._tranID);
                return 7;
            }
            catch (XAException e1) {
                if (this.notAProblem(e1, false)) {
                    return 7;
                }
                if (jtaLogger.loggerI18N.isWarnEnabled()) {
                    jtaLogger.loggerI18N.warn("com.arjuna.ats.internal.jta.resources.arjunacore.rollbackxaerror", new Object[]{"XAResourceRecord.rollback", XAHelper.printXAErrorCode(e1)});
                }
                switch (e1.errorCode) {
                    case -3: {
                        if (!this._prepared) {
                            return 7;
                        }
                    }
                    case 8: {
                        int n = 6;
                        return n;
                    }
                    case 7: {
                        int n = 4;
                        return n;
                    }
                    case 5: {
                        int n = 5;
                        return n;
                    }
                    case -4: {
                        if (!this._recovered) return 7;
                        return 7;
                    }
                    case 6: 
                    case 100: 
                    case 101: 
                    case 102: 
                    case 103: 
                    case 104: 
                    case 105: 
                    case 106: 
                    case 107: {
                        return 7;
                    }
                    default: {
                        int n = 8;
                        return n;
                    }
                }
            }
            catch (Exception e2) {
                e2.printStackTrace();
                int n = 8;
                return n;
            }
            finally {
                if (!this._prepared) {
                    this.removeConnection();
                }
            }
        } else {
            if (jtaLogger.loggerI18N.isWarnEnabled()) {
                jtaLogger.loggerI18N.warn("com.arjuna.ats.internal.jta.resources.arjunacore.noresource", new Object[]{this._tranID});
            }
            if (!_assumedComplete) return 8;
            if (!jtaLogger.loggerI18N.isInfoEnabled()) return 7;
            jtaLogger.loggerI18N.info("com.arjuna.ats.internal.jta.resources.arjunacore.assumecomplete", new Object[]{this._tranID});
            return 7;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int topLevelCommit() {
        if (jtaLogger.logger.isDebugEnabled()) {
            jtaLogger.logger.debug(16L, 4L, 1L, "XAResourceRecord.topLevelCommit for " + this._tranID);
        }
        if (!this._prepared) {
            return 9;
        }
        if (this._tranID == null) {
            if (!jtaLogger.loggerI18N.isWarnEnabled()) return 8;
            jtaLogger.loggerI18N.warn("com.arjuna.ats.internal.jta.resources.arjunacore.commitnulltx", new Object[]{"XAResourceRecord.commit"});
            return 8;
        }
        if (this._theXAResource == null) {
            this._theXAResource = this.getNewXAResource();
        }
        if (this._theXAResource != null) {
            if (this._heuristic != 7) {
                return this._heuristic;
            }
            try {
                this._theXAResource.commit(this._tranID, false);
                return 7;
            }
            catch (XAException e1) {
                if (this.notAProblem(e1, true)) {
                    return 7;
                }
                if (jtaLogger.loggerI18N.isWarnEnabled()) {
                    jtaLogger.loggerI18N.warn("com.arjuna.ats.internal.jta.resources.arjunacore.commitxaerror", new Object[]{"XAResourceRecord.commit", XAHelper.printXAErrorCode(e1)});
                }
                switch (e1.errorCode) {
                    case 8: {
                        int n = 6;
                        return n;
                    }
                    case 7: {
                        return 7;
                    }
                    case -3: 
                    case 6: 
                    case 100: 
                    case 101: 
                    case 102: 
                    case 103: 
                    case 104: 
                    case 105: 
                    case 106: 
                    case 107: {
                        int n = 3;
                        return n;
                    }
                    case 5: {
                        int n = 5;
                        return n;
                    }
                    case -4: {
                        if (this._recovered) {
                            return 7;
                        }
                    }
                    case -6: 
                    case 4: {
                        int n = 8;
                        return n;
                    }
                    case -7: 
                    case -5: {
                        int n = 6;
                        return n;
                    }
                    default: {
                        int n = 6;
                        return n;
                    }
                }
            }
            catch (Exception e2) {
                int n = 8;
                return n;
            }
            finally {
                this.removeConnection();
            }
        } else {
            if (jtaLogger.loggerI18N.isWarnEnabled()) {
                jtaLogger.loggerI18N.warn("com.arjuna.ats.internal.jta.resources.arjunacore.noresource", new Object[]{this._tranID});
            }
            if (!_assumedComplete) return 8;
            if (!jtaLogger.loggerI18N.isInfoEnabled()) return 7;
            jtaLogger.loggerI18N.info("com.arjuna.ats.internal.jta.resources.arjunacore.assumecomplete", new Object[]{this._tranID});
            return 7;
        }
    }

    protected boolean notAProblem(XAException ex, boolean commit) {
        return XAResourceErrorHandler.notAProblem(this._theXAResource, ex, commit);
    }

    public int nestedOnePhaseCommit() {
        return 8;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int topLevelOnePhaseCommit() {
        if (jtaLogger.logger.isDebugEnabled()) {
            jtaLogger.logger.debug(16L, 4L, 1L, "XAResourceRecord.topLevelOnePhaseCommit for " + this._tranID);
        }
        if (this._tranID == null) {
            if (!jtaLogger.loggerI18N.isWarnEnabled()) return 8;
            jtaLogger.loggerI18N.warn("com.arjuna.ats.internal.jta.resources.arjunacore.opcnulltx", new Object[]{"XAResourceRecord.1pc"});
            return 8;
        }
        if (this._theXAResource == null) return 8;
        if (this._heuristic != 7) {
            return this._heuristic;
        }
        try {
            if (this.endAssociation()) {
                this._theXAResource.end(this._tranID, 0x4000000);
            }
            this._theXAResource.commit(this._tranID, true);
            return 7;
        }
        catch (XAException e1) {
            if (e1.errorCode >= 100 && e1.errorCode < 107) {
                int n = 8;
                return n;
            }
            switch (e1.errorCode) {
                case 5: 
                case 8: {
                    int n = 6;
                    return n;
                }
                case 7: {
                    this.forget();
                    return 7;
                }
                case -3: 
                case 6: 
                case 100: 
                case 101: 
                case 102: 
                case 103: 
                case 104: 
                case 105: 
                case 106: 
                case 107: {
                    this.forget();
                    int n = 8;
                    return n;
                }
                case -4: {
                    int n = 6;
                    return n;
                }
                case -7: 
                case -6: 
                case -5: {
                    int n = 8;
                    return n;
                }
                default: {
                    int n = 8;
                    return n;
                }
            }
        }
        catch (Exception e2) {
            if (jtaLogger.loggerI18N.isWarnEnabled()) {
                jtaLogger.loggerI18N.warn("com.arjuna.ats.internal.jta.resources.arjunacore.opcerror", new Object[]{"XAResourceRecord.commit_one_phase", e2});
            }
            int n = 8;
            return n;
        }
        finally {
            this.removeConnection();
        }
    }

    public boolean forgetHeuristic() {
        if (jtaLogger.logger.isDebugEnabled()) {
            jtaLogger.logger.debug(16L, 4L, 1L, "XAResourceRecord.forget for " + this._tranID);
        }
        this.forget();
        this.removeConnection();
        return true;
    }

    private void forget() {
        if (this._theXAResource != null && this._tranID != null) {
            try {
                this._theXAResource.forget(this._tranID);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    protected int recover() {
        if (jtaLogger.logger.isDebugEnabled()) {
            jtaLogger.logger.debug(16L, 2L, 1L, "XAResourceRecord.recover");
        }
        return 2;
    }

    public static AbstractRecord create() {
        return new XAResourceRecord();
    }

    public static void remove(AbstractRecord toDelete) {
        toDelete = null;
    }

    public boolean save_state(OutputObjectState os, int t) {
        boolean res = false;
        try {
            os.packInt(this._heuristic);
            XidImple.pack(os, this._tranID);
            if (this._recoveryObject == null) {
                os.packInt(1);
                if (this._theXAResource instanceof Serializable) {
                    try {
                        ByteArrayOutputStream s = new ByteArrayOutputStream();
                        ObjectOutputStream o = new ObjectOutputStream(s);
                        o.writeObject(this._theXAResource);
                        o.close();
                        os.packBoolean(true);
                        os.packBytes(s.toByteArray());
                    }
                    catch (NotSerializableException ex) {
                        if (jtaLogger.loggerI18N.isWarnEnabled()) {
                            jtaLogger.loggerI18N.warn("com.arjuna.ats.internal.jta.resources.arjunacore.savestate");
                        }
                        return false;
                    }
                } else {
                    os.packBoolean(false);
                }
            } else {
                os.packInt(0);
                os.packString(this._recoveryObject.getClass().getName());
                this._recoveryObject.packInto(os);
            }
            res = true;
        }
        catch (Exception e) {
            e.printStackTrace();
            res = false;
        }
        if (res) {
            res = super.save_state(os, t);
        }
        return res;
    }

    /*
     * Unable to fully structure code
     */
    public boolean restore_state(InputObjectState os, int t) {
        res = false;
        try {
            this._heuristic = os.unpackInt();
            this._tranID = XidImple.unpack(os);
            this._theXAResource = null;
            this._recoveryObject = null;
            if (os.unpackInt() == 1) {
                haveXAResource = os.unpackBoolean();
                if (haveXAResource) {
                    try {
                        b = os.unpackBytes();
                        s = new ByteArrayInputStream(b);
                        o = new ObjectInputStream(s);
                        this._theXAResource = (XAResource)o.readObject();
                        o.close();
                        if (!jtaLogger.logger.isDebugEnabled()) ** GOTO lbl36
                        jtaLogger.logger.debug(16L, 4L, 1L, "XAResourceRecord.restore_state - XAResource de-serialized");
                    }
                    catch (Exception ex) {
                        if (jtaLogger.loggerI18N.isWarnEnabled()) {
                            jtaLogger.loggerI18N.warn("com.arjuna.ats.internal.jta.resources.arjunacore.restorestate", (Throwable)ex);
                        }
                        return false;
                    }
                } else {
                    this._theXAResource = this.getNewXAResource();
                    if (this._theXAResource == null) {
                        jtaLogger.loggerI18N.warn("com.arjuna.ats.internal.jta.resources.arjunacore.norecoveryxa", new Object[]{this._tranID});
                        res = true;
                    }
                }
            } else {
                creatorName = os.unpackString();
                c = Thread.currentThread().getContextClassLoader().loadClass(creatorName);
                this._recoveryObject = (RecoverableXAConnection)c.newInstance();
                this._recoveryObject.unpackFrom(os);
                this._theXAResource = this._recoveryObject.getResource();
                if (jtaLogger.logger.isDebugEnabled()) {
                    jtaLogger.logger.debug(16L, 4L, 1L, "XAResourceRecord.restore_state - XAResource got from " + creatorName);
                }
            }
lbl36:
            // 6 sources

            res = true;
        }
        catch (Exception e) {
            e.printStackTrace();
            res = false;
        }
        if (res) {
            res = super.restore_state(os, t);
        }
        return res;
    }

    public String type() {
        return XAResourceRecord.typeName();
    }

    public static String typeName() {
        return "/StateManager/AbstractRecord/XAResourceRecord";
    }

    public boolean doSave() {
        return true;
    }

    public void merge(AbstractRecord a) {
    }

    public void alter(AbstractRecord a) {
    }

    public boolean shouldAdd(AbstractRecord a) {
        return false;
    }

    public boolean shouldAlter(AbstractRecord a) {
        return false;
    }

    public boolean shouldMerge(AbstractRecord a) {
        return false;
    }

    public boolean shouldReplace(AbstractRecord a) {
        return false;
    }

    protected XAResourceRecord() {
        this._theXAResource = null;
        this._recoveryObject = null;
        this._tranID = null;
        this._prepared = true;
        this._heuristic = 7;
        this._valid = true;
        this._theTransaction = null;
        this._recovered = true;
    }

    protected XAResourceRecord(Uid u) {
        super(u, null, 1);
        this._theXAResource = null;
        this._recoveryObject = null;
        this._tranID = null;
        this._prepared = true;
        this._heuristic = 7;
        this._valid = true;
        this._theTransaction = null;
        this._recovered = true;
    }

    protected synchronized void setXAResource(XAResource res) {
        this._theXAResource = res;
    }

    private final XAResource getNewXAResource() {
        RecoveryManager recMan = RecoveryManager.manager();
        Vector recoveryModules = recMan.getModules();
        if (recoveryModules != null) {
            Enumeration modules = recoveryModules.elements();
            while (modules.hasMoreElements()) {
                RecoveryModule m = (RecoveryModule)modules.nextElement();
                if (!(m instanceof XARecoveryModule)) continue;
                return ((XARecoveryModule)m).getNewXAResource(this._tranID);
            }
        }
        return null;
    }

    private final void removeConnection() {
        if (this._recoveryObject != null) {
            this._recoveryObject.close();
            this._recoveryObject = null;
        }
        if (this._theTransaction != null) {
            this._theTransaction = null;
        }
    }

    private final boolean endAssociation() {
        boolean doEnd = true;
        if (this._theTransaction != null) {
            if (this._theTransaction.getXAResourceState(this._theXAResource) == 1) {
                doEnd = false;
            }
        } else {
            doEnd = false;
        }
        return doEnd;
    }

    static {
        String assumedComplete;
        START_XARESOURCE = Uid.minUid();
        END_XARESOURCE = Uid.maxUid();
        _rollbackOptimization = false;
        _assumedComplete = false;
        String optimization = jtaPropertyManager.propertyManager.getProperty("com.arjuna.ats.jta.jtaTMImplementation", "OFF");
        if (optimization.equals("ON")) {
            _rollbackOptimization = true;
        }
        if ((assumedComplete = jtaPropertyManager.propertyManager.getProperty("com.arjuna.ats.jta.xaAssumeRecoveryComplete", "FALSE")).equalsIgnoreCase("true")) {
            _assumedComplete = true;
        }
    }
}

