/*
 * Decompiled with CFR 0.152.
 */
package com.arjuna.ats.jta.utils;

import com.arjuna.ats.jta.logging.jtaLogger;
import javax.transaction.xa.XAException;
import javax.transaction.xa.Xid;

public class XAHelper {
    public static String printXAErrorCode(XAException e) {
        if (e == null) {
            return jtaLogger.logMesg.getString("com.arjuna.ats.jta.utils.nullexception");
        }
        switch (e.errorCode) {
            case 100: {
                return "XAException.XA_RBROLLBACK";
            }
            case 101: {
                return "XAException.XA_RBCOMMFAIL";
            }
            case 102: {
                return "XAException.XA_RBDEADLOCK";
            }
            case 103: {
                return "XAException.XA_RBINTEGRITY";
            }
            case 104: {
                return "XAException.XA_RBOTHER";
            }
            case 105: {
                return "XAException.XA_RBPROTO";
            }
            case 106: {
                return "XAException.XA_RBTIMEOUT";
            }
            case 107: {
                return "XAException.XA_RBTRANSIENT";
            }
            case 9: {
                return "XAException.XA_NOMIGRATE";
            }
            case 8: {
                return "XAException.XA_HEURHAZ";
            }
            case 7: {
                return "XAException.XA_HEURCOM";
            }
            case 6: {
                return "XAException.XA_HEURRB";
            }
            case 5: {
                return "XAException.XA_HEURMIX";
            }
            case 3: {
                return "XAException.XA_RDONLY";
            }
            case -3: {
                return "XAException.XAER_RMERR";
            }
            case -4: {
                return "XAException.XAER_NOTA";
            }
            case -5: {
                return "XAException.XAER_INVAL";
            }
            case -6: {
                return "XAException.XAER_PROTO";
            }
            case -7: {
                return "XAException.XAER_RMFAIL";
            }
            case -8: {
                return "XAException.XAER_DUPID";
            }
            case -9: {
                return "XAException.XAER_OUTSIDE";
            }
            case 4: {
                return "XAException.XA_RETRY";
            }
        }
        return jtaLogger.logMesg.getString("com.arjuna.ats.jta.utils.unknownerrorcode") + e.errorCode;
    }

    public static boolean sameXID(Xid x1, Xid x2) {
        if (x1 == x2) {
            return true;
        }
        if (x1.getFormatId() == x2.getFormatId()) {
            int bqual2Len;
            byte[] gtrid2;
            byte[] gtrid1 = x1.getGlobalTransactionId();
            if (gtrid1.length == (gtrid2 = x2.getGlobalTransactionId()).length) {
                for (int i = 0; i < gtrid1.length; ++i) {
                    if (gtrid1[i] == gtrid2[i]) continue;
                    return false;
                }
            } else {
                return false;
            }
            byte[] bqual1 = x1.getBranchQualifier();
            int bqual1Len = bqual1 == null ? 0 : bqual1.length;
            byte[] bqual2 = x2.getBranchQualifier();
            int n = bqual2Len = bqual2 == null ? 0 : bqual2.length;
            if (bqual1Len == bqual2Len) {
                for (int i = 0; i < bqual1Len; ++i) {
                    if (bqual1[i] == bqual2[i]) continue;
                    return false;
                }
            } else {
                return false;
            }
            return true;
        }
        return false;
    }

    public static boolean sameTransaction(Xid x1, Xid x2) {
        if (x1 == x2) {
            return true;
        }
        if (x1.getFormatId() == x2.getFormatId()) {
            byte[] gtrid2;
            byte[] gtrid1 = x1.getGlobalTransactionId();
            if (gtrid1.length == (gtrid2 = x2.getGlobalTransactionId()).length) {
                for (int i = 0; i < gtrid1.length; ++i) {
                    if (gtrid1[i] == gtrid2[i]) continue;
                    return false;
                }
                return true;
            }
            return false;
        }
        return false;
    }

    public static String xidToString(Xid xid) {
        String globalTranId = new String(xid.getGlobalTransactionId());
        byte[] qualifier = xid.getBranchQualifier();
        if (qualifier != null && qualifier.length > 0) {
            String branchQualifier = new String(qualifier);
            return new String("< " + xid.getFormatId() + ", " + globalTranId + ", " + branchQualifier + " >");
        }
        return new String("< " + xid.getFormatId() + ", " + globalTranId + " >");
    }
}

