/*
 * JBoss, Home of Professional Open Source.
 * Copyright 2009, Red Hat Middleware LLC, and individual contributors
 * as indicated by the @author tags. See the copyright.txt file in the
 * distribution for a full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.ejb3.test.jbpapp1951;

import java.io.Serializable;

import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.annotation.Resource;
import javax.ejb.EJB;
import javax.ejb.EJBAccessException;
import javax.ejb.MessageDrivenContext;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.QueueConnection;
import javax.jms.QueueConnectionFactory;
import javax.jms.QueueSender;
import javax.jms.QueueSession;
import javax.jms.TextMessage;

import org.jboss.logging.Logger;

/**
 * @author <a href="mailto:cdewolf@redhat.com">Carlo de Wolf</a>
 * @version $Revision: $
 */
public class ReplierMDB implements MessageListener
{
   private static final Logger log = Logger.getLogger(ReplierMDB.class);
   
   @Resource
   private MessageDrivenContext ctx;
   
   @Resource(mappedName="java:/ConnectionFactory")
   private QueueConnectionFactory factory;
   
   private QueueConnection connection;
   private QueueSession session;
   private QueueSender sender;
   
   @EJB
   private WhoAmI bean;
   
   public void onMessage(Message message)
   {
      log.info("callerPrincipal = " + ctx.getCallerPrincipal());
      boolean isCallerInRoleRoot;
      try
      {
         isCallerInRoleRoot = bean.isCallerInRoleRoot();
      }
      catch(EJBAccessException e)
      {
         log.info("not allowed " + e.getMessage());
         isCallerInRoleRoot = false;
      }
      log.info("isCallerInRoleRoot = " + isCallerInRoleRoot);
      try
      {
         String text = ((TextMessage) message).getText();
         
         try
         {
            sendReply(message.getJMSReplyTo(), bean.getCallerPrincipal().getName() + ": " + text + ": " + bean.isCallerInRole("root"));
         }
         catch(Exception e)
         {
            sendReply(message.getJMSReplyTo(), e);
         }
      }
      catch(JMSException e)
      {
         throw new RuntimeException(e);
      }
   }
   
   protected void sendReply(Destination destination, Serializable obj) throws JMSException
   {
      Message message = session.createObjectMessage(obj);
      sender.send(destination, message);
   }
   
   @PostConstruct
   public void postConstruct()
   {
      try
      {
         connection = factory.createQueueConnection();
         session = connection.createQueueSession(false, QueueSession.AUTO_ACKNOWLEDGE);
         sender = session.createSender(null);
      }
      catch(JMSException e)
      {
         throw new RuntimeException(e);
      }
   }
   
   @PreDestroy
   public void preDestroy()
   {
      try
      {
         if(sender != null)
            sender.close();
         if(session != null)
            session.close();
         if(connection != null)
            connection.close();
      }
      catch(JMSException e)
      {
         throw new RuntimeException(e);
      }
   }
}
