/*
* JBoss, Home of Professional Open Source.
* Copyright 2008, Red Hat Middleware LLC, and individual contributors
* as indicated by the @author tags. See the copyright.txt file in the
* distribution for a full listing of individual contributors.
*
* This is free software; you can redistribute it and/or modify it
* under the terms of the GNU Lesser General Public License as
* published by the Free Software Foundation; either version 2.1 of
* the License, or (at your option) any later version.
*
* This software is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
* Lesser General Public License for more details.
*
* You should have received a copy of the GNU Lesser General Public
* License along with this software; if not, write to the Free
* Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
* 02110-1301 USA, or see the FSF site: http://www.fsf.org.
*/
package org.jboss.test.security.ejb.jbas6006;

import javax.ejb.CreateException;
import javax.ejb.EJBException;
import javax.ejb.SessionBean;
import javax.ejb.SessionContext;

/**
 * 
 * @author darran.lofthouse@jboss.com
 * @since 30th September 2008
 */
public class StatefulSessionBean implements SessionBean
{
   
   private static final long serialVersionUID = -2925108063260951440L;
   
   private SessionContext ctx;

   public void ejbCreate(final String expectedCaller) throws CreateException
   {
      // Although this method is defined on the remote interface this is
      // a direct call so does not pass the interceptors again.
      testCaller(expectedCaller);
   }

   public void testCaller(final String expectedCaller)
   {
      String callerPrincipal = ctx.getCallerPrincipal().getName();
      if (expectedCaller.equals(callerPrincipal) == false)
      {
         throw new EJBException("Wrong CallerPrincipal expected='" + expectedCaller + "' actual='" + callerPrincipal
               + "'");
      }
   }

   /**
    * @see javax.ejb.SessionBean#ejbActivate()
    */
   public void ejbActivate()
   {
   }

   /**
    * @see javax.ejb.SessionBean#ejbPassivate()
    */
   public void ejbPassivate()
   {
   }

   /**
    * @see javax.ejb.SessionBean#ejbRemove()
    */
   public void ejbRemove()
   {
   }

   /**
    * @see javax.ejb.SessionBean#setSessionContext(javax.ejb.SessionContext)
    */
   public void setSessionContext(SessionContext ctx)
   {
      this.ctx = ctx;
   }

}
