/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.remoting.transport.multiplex;

import java.io.IOException;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.nio.channels.ServerSocketChannel;
import java.util.HashMap;
import java.util.Map;
import javax.net.ServerSocketFactory;
import org.jboss.logging.Logger;
import org.jboss.remoting.transport.multiplex.MultiplexingInputStream;
import org.jboss.remoting.transport.multiplex.MultiplexingManager;
import org.jboss.remoting.transport.multiplex.MultiplexingOutputStream;
import org.jboss.remoting.transport.multiplex.Protocol;
import org.jboss.remoting.transport.multiplex.SocketId;
import org.jboss.remoting.transport.multiplex.VirtualSocket;

public class MasterServerSocket
extends ServerSocket
implements Serializable {
    private static final Logger log = Logger.getLogger(MasterServerSocket.class);
    private Map configuration = new HashMap();
    private ServerSocket ss;
    private ServerSocketChannel ssc;
    private static final long serialVersionUID = 402293949935889044L;

    public MasterServerSocket() throws IOException {
        this(true);
    }

    public MasterServerSocket(int port) throws IOException {
        this(true, port);
    }

    public MasterServerSocket(int port, int backlog) throws IOException {
        this(true, port, backlog);
    }

    public MasterServerSocket(int port, int backlog, InetAddress bindAddr) throws IOException {
        this(true, port, backlog, bindAddr);
    }

    public MasterServerSocket(boolean nio) throws IOException {
        if (nio) {
            this.ssc = ServerSocketChannel.open();
            this.ss = this.ssc.socket();
        } else {
            this.ss = new ServerSocket();
        }
    }

    public MasterServerSocket(boolean nio, int port) throws IOException {
        if (nio) {
            this.ssc = ServerSocketChannel.open();
            this.ss = this.ssc.socket();
            this.ss.bind(new InetSocketAddress(port));
        } else {
            this.ss = new ServerSocket(port);
        }
    }

    public MasterServerSocket(boolean nio, int port, int backlog) throws IOException {
        if (nio) {
            this.ssc = ServerSocketChannel.open();
            this.ss = this.ssc.socket();
            this.ss.bind(new InetSocketAddress(port), backlog);
        } else {
            this.ss = new ServerSocket(port, backlog);
        }
    }

    public MasterServerSocket(boolean nio, int port, int backlog, InetAddress bindAddr) throws IOException {
        if (nio) {
            this.ssc = ServerSocketChannel.open();
            this.ss = this.ssc.socket();
            this.ss.bind(new InetSocketAddress(bindAddr, port), backlog);
        } else {
            this.ss = new ServerSocket(port, backlog, bindAddr);
        }
    }

    public MasterServerSocket(int port, int backlog, InetAddress bindAddr, Map conf) throws IOException {
        if (conf != null) {
            this.configuration.putAll(conf);
        }
        if (conf == null || conf.get("multiplex.ServerSocketFactory") == null) {
            this.ssc = ServerSocketChannel.open();
            this.ss = this.ssc.socket();
            this.ss.bind(new InetSocketAddress(bindAddr, port), backlog);
        } else {
            Object obj = conf.get("multiplex.ServerSocketFactory");
            if (!(obj instanceof ServerSocketFactory)) {
                String msg = "configuration map contains invalid entry for Multiplex.SERVER_SOCKET_FACTORY: " + obj;
                log.error((Object)msg);
                throw new IOException(msg);
            }
            ServerSocketFactory ssf = (ServerSocketFactory)obj;
            this.ss = ssf.createServerSocket(port, backlog, bindAddr);
        }
    }

    public MasterServerSocket(ServerSocketFactory ssf) throws IOException {
        this.ss = ssf.createServerSocket();
    }

    public MasterServerSocket(ServerSocketFactory ssf, int port) throws IOException {
        this.ss = ssf.createServerSocket(port);
    }

    public MasterServerSocket(ServerSocketFactory ssf, int port, int backlog) throws IOException {
        this.ss = ssf.createServerSocket(port, backlog);
    }

    public MasterServerSocket(ServerSocketFactory ssf, int port, int backlog, InetAddress bindAddr) throws IOException {
        this.ss = ssf.createServerSocket(port, backlog, bindAddr);
    }

    /*
     * Loose catch block
     */
    public Socket accept() throws IOException {
        SocketId clientPort;
        Protocol protocol;
        MultiplexingManager manager;
        int timeout;
        long start = System.currentTimeMillis();
        int savedTimeout = timeout = this.getSoTimeout();
        int timeLeft = 0;
        Socket socket = null;
        SocketTimeoutException savedException = null;
        while (true) {
            block24: {
                if (timeout > 0 && (timeLeft = timeout - (int)(System.currentTimeMillis() - start)) <= 0) {
                    throw new SocketTimeoutException("Accept timed out");
                }
                this.setSoTimeout(timeLeft);
                socket = this.ss.accept();
                Object var10_11 = null;
                try {
                    this.setSoTimeout(savedTimeout);
                }
                catch (Exception e) {
                    // empty catch block
                }
                if (savedException != null) {
                    throw savedException;
                }
                break block24;
                {
                    catch (SocketTimeoutException e) {
                        savedException = new SocketTimeoutException("Accept timed out");
                        throw savedException;
                    }
                }
                catch (Throwable throwable) {
                    var10_11 = null;
                    try {
                        this.setSoTimeout(savedTimeout);
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    if (savedException != null) {
                        throw savedException;
                    }
                    throw throwable;
                }
            }
            manager = MultiplexingManager.getaManager(socket, this.configuration);
            MultiplexingInputStream is = null;
            protocol = null;
            clientPort = null;
            try {
                is = manager.getAnInputStream(SocketId.SERVER_SOCKET_ID, null);
                protocol = manager.getProtocol();
                if (timeout > 0 && (timeLeft = timeout - (int)(System.currentTimeMillis() - start)) <= 0) {
                    throw new SocketTimeoutException("Accept timed out");
                }
                clientPort = protocol.acceptConnect(is, timeLeft);
            }
            catch (SocketTimeoutException e) {
                log.debug((Object)"i/o exception in MasterServerSocket.accept()");
                manager.decrementReferences();
                throw e;
            }
            catch (IOException e) {
                log.error((Object)"i/o exception in MasterServerSocket.accept()", (Throwable)e);
                manager.decrementReferences();
                throw e;
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("accept(): clientPort:  " + clientPort.getPort()));
            }
            if (clientPort.getPort() >= 0) break;
            MultiplexingOutputStream os = new MultiplexingOutputStream(manager, SocketId.SERVER_SOCKET_CONNECT_ID);
            try {
                protocol.answerConnect(os, -3);
            }
            catch (IOException e) {
                log.error((Object)"unable to respond to connect request");
                manager.decrementReferences();
                if (e instanceof SocketTimeoutException) {
                    throw new SocketTimeoutException("Accept timed out");
                }
                throw e;
            }
        }
        VirtualSocket virtualSocket = null;
        try {
            virtualSocket = new VirtualSocket(manager, clientPort, this.configuration);
        }
        catch (IOException e) {
            manager.decrementReferences();
            throw e;
        }
        int localPort = virtualSocket.getLocalVirtualPort();
        try {
            protocol.answerConnect((MultiplexingOutputStream)virtualSocket.getOutputStream(), localPort);
        }
        catch (IOException e) {
            log.error((Object)"unable to respond to connect request");
            virtualSocket.close();
            throw e;
        }
        return virtualSocket;
    }

    public void bind(SocketAddress endpoint) throws IOException {
        this.ss.bind(endpoint);
    }

    public void bind(SocketAddress endpoint, int backlog) throws IOException {
        this.ss.bind(endpoint, backlog);
    }

    public void close() throws IOException {
        log.debug((Object)"MasterServerSocket: closing");
        this.ss.close();
    }

    public ServerSocketChannel getChannel() {
        return this.ss.getChannel();
    }

    public InetAddress getInetAddress() {
        return this.ss.getInetAddress();
    }

    public int getLocalPort() {
        return this.ss.getLocalPort();
    }

    public SocketAddress getLocalSocketAddress() {
        return this.ss.getLocalSocketAddress();
    }

    public int getReceiveBufferSize() throws SocketException {
        return this.ss.getReceiveBufferSize();
    }

    public boolean getReuseAddress() throws SocketException {
        return this.ss.getReuseAddress();
    }

    public int getSoTimeout() throws IOException {
        return this.ss.getSoTimeout();
    }

    public boolean isBound() {
        return this.ss.isBound();
    }

    public boolean isClosed() {
        return this.ss.isClosed();
    }

    public void setReceiveBufferSize(int size) throws SocketException {
        this.ss.setReceiveBufferSize(size);
    }

    public void setReuseAddress(boolean on) throws SocketException {
        this.ss.setReuseAddress(on);
    }

    public void setSoTimeout(int timeout) throws SocketException {
        this.ss.setSoTimeout(timeout);
    }

    public String toString() {
        if (!this.isBound()) {
            return "MasterServerSocket[unbound]";
        }
        return "MasterServerSocket[" + this.ss.toString() + "]";
    }

    public int acceptServerSocketConnection() throws IOException {
        int timeout;
        long start = System.currentTimeMillis();
        int savedTimeout = timeout = this.getSoTimeout();
        int timeLeft = 0;
        Socket socket = null;
        socket = this.ssc == null ? this.ss.accept() : this.ssc.accept().socket();
        MultiplexingManager manager = MultiplexingManager.getaManager(socket, this.configuration);
        manager.setCreatedForRemoteServerSocket();
        MultiplexingInputStream is = null;
        Protocol protocol = null;
        SocketId clientPort = null;
        try {
            is = manager.getAnInputStream(SocketId.SERVER_SOCKET_ID, null);
            protocol = manager.getProtocol();
            if (timeout > 0 && (timeLeft = timeout - (int)(System.currentTimeMillis() - start)) <= 0) {
                throw new SocketTimeoutException("Accept timed out");
            }
            clientPort = protocol.acceptConnect(is, timeLeft);
        }
        catch (IOException e) {
            log.error((Object)"i/o exception in MasterServerSocket.acceptServerSocketConnection()", (Throwable)e);
            manager.decrementReferences();
            if (e instanceof SocketTimeoutException) {
                throw new SocketTimeoutException("Accept timed out");
            }
            throw e;
        }
        if (clientPort.getPort() != -2) {
            manager.decrementReferences();
            String message = "received connect request not from a VirtualServerSocket";
            log.error((Object)message);
            throw new IOException(message);
        }
        MultiplexingOutputStream os = new MultiplexingOutputStream(manager, SocketId.SERVER_SOCKET_CONNECT_ID);
        try {
            protocol.answerConnect(os, -3);
        }
        catch (IOException e) {
            log.error((Object)"unable to respond to connect request");
            manager.decrementReferences();
            throw e;
        }
        return manager.getSocket().getLocalPort();
    }

    public void setConfiguration(Map configuration) {
        this.configuration.putAll(configuration);
    }
}

