/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import javax.xml.namespace.QName;
import org.opensaml.MalformedException;
import org.opensaml.SAMLCondition;
import org.opensaml.SAMLException;
import org.opensaml.XML;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class SAMLAudienceRestrictionCondition
extends SAMLCondition
implements Cloneable {
    protected ArrayList audiences = new ArrayList();

    public SAMLAudienceRestrictionCondition() {
    }

    public SAMLAudienceRestrictionCondition(Collection collection) throws SAMLException {
        if (collection != null) {
            this.audiences.addAll(collection);
        }
    }

    public SAMLAudienceRestrictionCondition(Element element) throws SAMLException {
        this.fromDOM(element);
    }

    public SAMLAudienceRestrictionCondition(InputStream inputStream) throws SAMLException {
        this.fromDOM(SAMLAudienceRestrictionCondition.fromStream(inputStream));
    }

    public void fromDOM(Element element) throws SAMLException {
        Object object;
        super.fromDOM(element);
        if (this.config.getBooleanProperty("org.opensaml.strict-dom-checking") && !XML.isElementNamed(element, "urn:oasis:names:tc:SAML:1.0:assertion", "AudienceRestrictionCondition")) {
            object = XML.getQNameAttribute(element, "http://www.w3.org/2001/XMLSchema-instance", "type");
            if (!(XML.isElementNamed(element, "urn:oasis:names:tc:SAML:1.0:assertion", "Condition") && object != null && "urn:oasis:names:tc:SAML:1.0:assertion".equals(((QName)object).getNamespaceURI()) && "AudienceRestrictionConditionType".equals(((QName)object).getLocalPart()))) {
                throw new MalformedException(SAMLException.RESPONDER, "SAMLAudienceRestrictionCondition() requires saml:AudienceRestrictionCondition at root");
            }
        }
        object = XML.getFirstChildElement(element);
        while (object != null) {
            if (object.hasChildNodes()) {
                this.audiences.add(object.getFirstChild().getNodeValue());
            }
            object = XML.getNextSiblingElement((Node)object);
        }
        this.checkValidity();
    }

    public Iterator getAudiences() {
        return this.audiences.iterator();
    }

    public void setAudiences(Collection collection) {
        this.audiences.clear();
        if (collection != null) {
            this.audiences.addAll(collection);
        }
        this.setDirty(true);
    }

    public void addAudience(String string) {
        if (XML.isEmpty(string)) {
            throw new IllegalArgumentException("audience cannot be null or empty");
        }
        this.audiences.add(string);
        this.setDirty(true);
    }

    public void removeAudience(int n) {
        this.audiences.remove(n);
        this.setDirty(true);
    }

    protected Element buildRoot(Document document, boolean bl) {
        Element element = document.createElementNS("urn:oasis:names:tc:SAML:1.0:assertion", "AudienceRestrictionCondition");
        if (bl) {
            element.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns", "urn:oasis:names:tc:SAML:1.0:assertion");
        }
        return element;
    }

    public Node toDOM(Document document, boolean bl) throws SAMLException {
        super.toDOM(document, bl);
        Element element = (Element)this.root;
        if (this.dirty) {
            Iterator iterator = this.audiences.iterator();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                if (XML.isEmpty(string)) continue;
                element.appendChild(document.createElementNS("urn:oasis:names:tc:SAML:1.0:assertion", "Audience")).appendChild(document.createTextNode(string));
            }
            this.setDirty(false);
        } else if (bl) {
            element.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns", "urn:oasis:names:tc:SAML:1.0:assertion");
        }
        return this.root;
    }

    public boolean eval(Collection collection) {
        if (collection == null || collection.size() == 0) {
            return false;
        }
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            if (!this.audiences.contains(iterator.next())) continue;
            return true;
        }
        return false;
    }

    public void checkValidity() throws SAMLException {
        if (this.audiences == null || this.audiences.size() == 0) {
            throw new MalformedException(SAMLException.RESPONDER, "AudienceRestrictionCondition is invalid, requires at least one audience");
        }
    }

    public Object clone() throws CloneNotSupportedException {
        SAMLAudienceRestrictionCondition sAMLAudienceRestrictionCondition = (SAMLAudienceRestrictionCondition)super.clone();
        sAMLAudienceRestrictionCondition.audiences = (ArrayList)this.audiences.clone();
        return sAMLAudienceRestrictionCondition;
    }
}

