/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3.deployers;

import org.jboss.deployers.spi.DeploymentException;
import org.jboss.deployers.spi.deployer.DeploymentStages;
import org.jboss.deployers.spi.deployer.helpers.AbstractDeployer;
import org.jboss.deployers.structure.spi.DeploymentUnit;
import org.jboss.ejb3.common.metadata.MetadataUtil;
import org.jboss.ejb3.deployers.Ejb3MetadataProcessingDeployer;
import org.jboss.logging.Logger;
import org.jboss.metadata.ejb.jboss.JBossMetaData;

public class EjbMetadataJndiPolicyDecoratorDeployer
extends AbstractDeployer {
    private static final Logger log = Logger.getLogger(EjbMetadataJndiPolicyDecoratorDeployer.class);
    private static final String INPUT = Ejb3MetadataProcessingDeployer.OUTPUT;
    public static final String EJB_DECORATED_FLAG = EjbMetadataJndiPolicyDecoratorDeployer.class.getSimpleName();

    public EjbMetadataJndiPolicyDecoratorDeployer() {
        this.setStage(DeploymentStages.POST_CLASSLOADER);
        this.addInput(INPUT);
        this.addOutput(EJB_DECORATED_FLAG);
    }

    public void deploy(DeploymentUnit du) throws DeploymentException {
        JBossMetaData md = (JBossMetaData)du.getAttachment(INPUT, JBossMetaData.class);
        if (md == null) {
            return;
        }
        if (!md.isEJB3x()) {
            return;
        }
        log.debug((Object)("Decorating EJB3 EJBs in " + md + " with JNDI Policy"));
        MetadataUtil.decorateEjbsWithJndiPolicy((JBossMetaData)md, (ClassLoader)du.getClassLoader());
        du.addAttachment(EJB_DECORATED_FLAG, (Object)true, Boolean.class);
    }
}

