/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.cache.jbc2.builder;

import java.util.Properties;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.hibernate.cache.CacheException;
import org.hibernate.cache.jbc2.builder.MultiplexingCacheInstanceManager;
import org.hibernate.cfg.Settings;
import org.hibernate.util.NamingHelper;
import org.hibernate.util.PropertiesHelper;
import org.jboss.cache.CacheManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JndiMultiplexingCacheInstanceManager
extends MultiplexingCacheInstanceManager {
    private static final Logger log = LoggerFactory.getLogger(JndiMultiplexingCacheInstanceManager.class);
    public static final String CACHE_FACTORY_RESOURCE_PROP = "hibernate.cache.region.jbc2.cachefactory";

    public void start(Settings settings, Properties properties) throws CacheException {
        String name = PropertiesHelper.getString((String)CACHE_FACTORY_RESOURCE_PROP, (Properties)properties, null);
        if (name == null) {
            throw new CacheException("Configuration property hibernate.cache.region.jbc2.cachefactory not set");
        }
        CacheManager cf = this.locateCacheFactory(name, NamingHelper.getJndiProperties((Properties)properties));
        this.setCacheFactory(cf);
        super.start(settings, properties);
    }

    private CacheManager locateCacheFactory(String jndiNamespace, Properties jndiProperties) {
        InitialContext ctx = null;
        try {
            ctx = new InitialContext(jndiProperties);
            CacheManager cacheManager = (CacheManager)ctx.lookup(jndiNamespace);
            return cacheManager;
        }
        catch (NamingException ne) {
            String msg = "Unable to retreive Cache from JNDI [" + jndiNamespace + "]";
            log.info(msg, (Throwable)ne);
            throw new CacheException(msg);
        }
        finally {
            if (ctx != null) {
                try {
                    ctx.close();
                }
                catch (NamingException ne) {
                    log.info("Unable to release initial context", (Throwable)ne);
                }
            }
        }
    }
}

