/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.model.io.xpp3;

import java.io.IOException;
import java.io.Serializable;
import java.io.Writer;
import java.util.Iterator;
import org.apache.maven.model.Activation;
import org.apache.maven.model.ActivationFile;
import org.apache.maven.model.ActivationOS;
import org.apache.maven.model.ActivationProperty;
import org.apache.maven.model.Build;
import org.apache.maven.model.BuildBase;
import org.apache.maven.model.CiManagement;
import org.apache.maven.model.ConfigurationContainer;
import org.apache.maven.model.Contributor;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.DependencyManagement;
import org.apache.maven.model.DeploymentRepository;
import org.apache.maven.model.Developer;
import org.apache.maven.model.DistributionManagement;
import org.apache.maven.model.Exclusion;
import org.apache.maven.model.Extension;
import org.apache.maven.model.FileSet;
import org.apache.maven.model.IssueManagement;
import org.apache.maven.model.License;
import org.apache.maven.model.MailingList;
import org.apache.maven.model.Model;
import org.apache.maven.model.ModelBase;
import org.apache.maven.model.Notifier;
import org.apache.maven.model.Organization;
import org.apache.maven.model.Parent;
import org.apache.maven.model.PatternSet;
import org.apache.maven.model.Plugin;
import org.apache.maven.model.PluginConfiguration;
import org.apache.maven.model.PluginContainer;
import org.apache.maven.model.PluginExecution;
import org.apache.maven.model.PluginManagement;
import org.apache.maven.model.Prerequisites;
import org.apache.maven.model.Profile;
import org.apache.maven.model.Relocation;
import org.apache.maven.model.ReportPlugin;
import org.apache.maven.model.ReportSet;
import org.apache.maven.model.Reporting;
import org.apache.maven.model.Repository;
import org.apache.maven.model.RepositoryBase;
import org.apache.maven.model.RepositoryPolicy;
import org.apache.maven.model.Resource;
import org.apache.maven.model.Scm;
import org.apache.maven.model.Site;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.codehaus.plexus.util.xml.pull.MXSerializer;
import org.codehaus.plexus.util.xml.pull.XmlSerializer;

public class MavenXpp3Writer {
    private String NAMESPACE;

    public void write(Writer writer, Model model) throws IOException {
        MXSerializer serializer = new MXSerializer();
        serializer.setProperty("http://xmlpull.org/v1/doc/properties.html#serializer-indentation", "  ");
        serializer.setProperty("http://xmlpull.org/v1/doc/properties.html#serializer-line-separator", "\n");
        serializer.setOutput(writer);
        serializer.startDocument(model.getModelEncoding(), null);
        this.writeModel(model, "project", serializer);
        serializer.endDocument();
    }

    private void writeActivation(Activation activation, String tagName, XmlSerializer serializer) throws IOException {
        if (activation != null) {
            serializer.startTag(this.NAMESPACE, tagName);
            if (activation.isActiveByDefault()) {
                serializer.startTag(this.NAMESPACE, "activeByDefault").text(String.valueOf(activation.isActiveByDefault())).endTag(this.NAMESPACE, "activeByDefault");
            }
            if (activation.getJdk() != null) {
                serializer.startTag(this.NAMESPACE, "jdk").text(activation.getJdk()).endTag(this.NAMESPACE, "jdk");
            }
            if (activation.getOs() != null) {
                this.writeActivationOS(activation.getOs(), "os", serializer);
            }
            if (activation.getProperty() != null) {
                this.writeActivationProperty(activation.getProperty(), "property", serializer);
            }
            if (activation.getFile() != null) {
                this.writeActivationFile(activation.getFile(), "file", serializer);
            }
            serializer.endTag(this.NAMESPACE, tagName);
        }
    }

    private void writeActivationFile(ActivationFile activationFile, String tagName, XmlSerializer serializer) throws IOException {
        if (activationFile != null) {
            serializer.startTag(this.NAMESPACE, tagName);
            if (activationFile.getMissing() != null) {
                serializer.startTag(this.NAMESPACE, "missing").text(activationFile.getMissing()).endTag(this.NAMESPACE, "missing");
            }
            if (activationFile.getExists() != null) {
                serializer.startTag(this.NAMESPACE, "exists").text(activationFile.getExists()).endTag(this.NAMESPACE, "exists");
            }
            serializer.endTag(this.NAMESPACE, tagName);
        }
    }

    private void writeActivationOS(ActivationOS activationOS, String tagName, XmlSerializer serializer) throws IOException {
        if (activationOS != null) {
            serializer.startTag(this.NAMESPACE, tagName);
            if (activationOS.getName() != null) {
                serializer.startTag(this.NAMESPACE, "name").text(activationOS.getName()).endTag(this.NAMESPACE, "name");
            }
            if (activationOS.getFamily() != null) {
                serializer.startTag(this.NAMESPACE, "family").text(activationOS.getFamily()).endTag(this.NAMESPACE, "family");
            }
            if (activationOS.getArch() != null) {
                serializer.startTag(this.NAMESPACE, "arch").text(activationOS.getArch()).endTag(this.NAMESPACE, "arch");
            }
            if (activationOS.getVersion() != null) {
                serializer.startTag(this.NAMESPACE, "version").text(activationOS.getVersion()).endTag(this.NAMESPACE, "version");
            }
            serializer.endTag(this.NAMESPACE, tagName);
        }
    }

    private void writeActivationProperty(ActivationProperty activationProperty, String tagName, XmlSerializer serializer) throws IOException {
        if (activationProperty != null) {
            serializer.startTag(this.NAMESPACE, tagName);
            if (activationProperty.getName() != null) {
                serializer.startTag(this.NAMESPACE, "name").text(activationProperty.getName()).endTag(this.NAMESPACE, "name");
            }
            if (activationProperty.getValue() != null) {
                serializer.startTag(this.NAMESPACE, "value").text(activationProperty.getValue()).endTag(this.NAMESPACE, "value");
            }
            serializer.endTag(this.NAMESPACE, tagName);
        }
    }

    private void writeBuild(Build build, String tagName, XmlSerializer serializer) throws IOException {
        if (build != null) {
            Serializable o;
            Iterator iter;
            serializer.startTag(this.NAMESPACE, tagName);
            if (build.getSourceDirectory() != null) {
                serializer.startTag(this.NAMESPACE, "sourceDirectory").text(build.getSourceDirectory()).endTag(this.NAMESPACE, "sourceDirectory");
            }
            if (build.getScriptSourceDirectory() != null) {
                serializer.startTag(this.NAMESPACE, "scriptSourceDirectory").text(build.getScriptSourceDirectory()).endTag(this.NAMESPACE, "scriptSourceDirectory");
            }
            if (build.getTestSourceDirectory() != null) {
                serializer.startTag(this.NAMESPACE, "testSourceDirectory").text(build.getTestSourceDirectory()).endTag(this.NAMESPACE, "testSourceDirectory");
            }
            if (build.getOutputDirectory() != null) {
                serializer.startTag(this.NAMESPACE, "outputDirectory").text(build.getOutputDirectory()).endTag(this.NAMESPACE, "outputDirectory");
            }
            if (build.getTestOutputDirectory() != null) {
                serializer.startTag(this.NAMESPACE, "testOutputDirectory").text(build.getTestOutputDirectory()).endTag(this.NAMESPACE, "testOutputDirectory");
            }
            if (build.getExtensions() != null && build.getExtensions().size() > 0) {
                serializer.startTag(this.NAMESPACE, "extensions");
                iter = build.getExtensions().iterator();
                while (iter.hasNext()) {
                    o = (Extension)iter.next();
                    this.writeExtension((Extension)o, "extension", serializer);
                }
                serializer.endTag(this.NAMESPACE, "extensions");
            }
            if (build.getDefaultGoal() != null) {
                serializer.startTag(this.NAMESPACE, "defaultGoal").text(build.getDefaultGoal()).endTag(this.NAMESPACE, "defaultGoal");
            }
            if (build.getResources() != null && build.getResources().size() > 0) {
                serializer.startTag(this.NAMESPACE, "resources");
                iter = build.getResources().iterator();
                while (iter.hasNext()) {
                    o = (Resource)iter.next();
                    this.writeResource((Resource)o, "resource", serializer);
                }
                serializer.endTag(this.NAMESPACE, "resources");
            }
            if (build.getTestResources() != null && build.getTestResources().size() > 0) {
                serializer.startTag(this.NAMESPACE, "testResources");
                iter = build.getTestResources().iterator();
                while (iter.hasNext()) {
                    o = (Resource)iter.next();
                    this.writeResource((Resource)o, "testResource", serializer);
                }
                serializer.endTag(this.NAMESPACE, "testResources");
            }
            if (build.getDirectory() != null) {
                serializer.startTag(this.NAMESPACE, "directory").text(build.getDirectory()).endTag(this.NAMESPACE, "directory");
            }
            if (build.getFinalName() != null) {
                serializer.startTag(this.NAMESPACE, "finalName").text(build.getFinalName()).endTag(this.NAMESPACE, "finalName");
            }
            if (build.getFilters() != null && build.getFilters().size() > 0) {
                serializer.startTag(this.NAMESPACE, "filters");
                iter = build.getFilters().iterator();
                while (iter.hasNext()) {
                    String filter = (String)iter.next();
                    serializer.startTag(this.NAMESPACE, "filter").text(filter).endTag(this.NAMESPACE, "filter");
                }
                serializer.endTag(this.NAMESPACE, "filters");
            }
            if (build.getPluginManagement() != null) {
                this.writePluginManagement(build.getPluginManagement(), "pluginManagement", serializer);
            }
            if (build.getPlugins() != null && build.getPlugins().size() > 0) {
                serializer.startTag(this.NAMESPACE, "plugins");
                iter = build.getPlugins().iterator();
                while (iter.hasNext()) {
                    o = (Plugin)iter.next();
                    this.writePlugin((Plugin)o, "plugin", serializer);
                }
                serializer.endTag(this.NAMESPACE, "plugins");
            }
            serializer.endTag(this.NAMESPACE, tagName);
        }
    }

    private void writeBuildBase(BuildBase buildBase, String tagName, XmlSerializer serializer) throws IOException {
        if (buildBase != null) {
            Serializable o;
            Iterator iter;
            serializer.startTag(this.NAMESPACE, tagName);
            if (buildBase.getDefaultGoal() != null) {
                serializer.startTag(this.NAMESPACE, "defaultGoal").text(buildBase.getDefaultGoal()).endTag(this.NAMESPACE, "defaultGoal");
            }
            if (buildBase.getResources() != null && buildBase.getResources().size() > 0) {
                serializer.startTag(this.NAMESPACE, "resources");
                iter = buildBase.getResources().iterator();
                while (iter.hasNext()) {
                    o = (Resource)iter.next();
                    this.writeResource((Resource)o, "resource", serializer);
                }
                serializer.endTag(this.NAMESPACE, "resources");
            }
            if (buildBase.getTestResources() != null && buildBase.getTestResources().size() > 0) {
                serializer.startTag(this.NAMESPACE, "testResources");
                iter = buildBase.getTestResources().iterator();
                while (iter.hasNext()) {
                    o = (Resource)iter.next();
                    this.writeResource((Resource)o, "testResource", serializer);
                }
                serializer.endTag(this.NAMESPACE, "testResources");
            }
            if (buildBase.getDirectory() != null) {
                serializer.startTag(this.NAMESPACE, "directory").text(buildBase.getDirectory()).endTag(this.NAMESPACE, "directory");
            }
            if (buildBase.getFinalName() != null) {
                serializer.startTag(this.NAMESPACE, "finalName").text(buildBase.getFinalName()).endTag(this.NAMESPACE, "finalName");
            }
            if (buildBase.getFilters() != null && buildBase.getFilters().size() > 0) {
                serializer.startTag(this.NAMESPACE, "filters");
                iter = buildBase.getFilters().iterator();
                while (iter.hasNext()) {
                    String filter = (String)iter.next();
                    serializer.startTag(this.NAMESPACE, "filter").text(filter).endTag(this.NAMESPACE, "filter");
                }
                serializer.endTag(this.NAMESPACE, "filters");
            }
            if (buildBase.getPluginManagement() != null) {
                this.writePluginManagement(buildBase.getPluginManagement(), "pluginManagement", serializer);
            }
            if (buildBase.getPlugins() != null && buildBase.getPlugins().size() > 0) {
                serializer.startTag(this.NAMESPACE, "plugins");
                iter = buildBase.getPlugins().iterator();
                while (iter.hasNext()) {
                    o = (Plugin)iter.next();
                    this.writePlugin((Plugin)o, "plugin", serializer);
                }
                serializer.endTag(this.NAMESPACE, "plugins");
            }
            serializer.endTag(this.NAMESPACE, tagName);
        }
    }

    private void writeCiManagement(CiManagement ciManagement, String tagName, XmlSerializer serializer) throws IOException {
        if (ciManagement != null) {
            serializer.startTag(this.NAMESPACE, tagName);
            if (ciManagement.getSystem() != null) {
                serializer.startTag(this.NAMESPACE, "system").text(ciManagement.getSystem()).endTag(this.NAMESPACE, "system");
            }
            if (ciManagement.getUrl() != null) {
                serializer.startTag(this.NAMESPACE, "url").text(ciManagement.getUrl()).endTag(this.NAMESPACE, "url");
            }
            if (ciManagement.getNotifiers() != null && ciManagement.getNotifiers().size() > 0) {
                serializer.startTag(this.NAMESPACE, "notifiers");
                Iterator iter = ciManagement.getNotifiers().iterator();
                while (iter.hasNext()) {
                    Notifier o = (Notifier)iter.next();
                    this.writeNotifier(o, "notifier", serializer);
                }
                serializer.endTag(this.NAMESPACE, "notifiers");
            }
            serializer.endTag(this.NAMESPACE, tagName);
        }
    }

    private void writeConfigurationContainer(ConfigurationContainer configurationContainer, String tagName, XmlSerializer serializer) throws IOException {
        if (configurationContainer != null) {
            serializer.startTag(this.NAMESPACE, tagName);
            if (configurationContainer.getInherited() != null) {
                serializer.startTag(this.NAMESPACE, "inherited").text(configurationContainer.getInherited()).endTag(this.NAMESPACE, "inherited");
            }
            if (configurationContainer.getConfiguration() != null) {
                ((Xpp3Dom)configurationContainer.getConfiguration()).writeToSerializer(this.NAMESPACE, serializer);
            }
            serializer.endTag(this.NAMESPACE, tagName);
        }
    }

    private void writeContributor(Contributor contributor, String tagName, XmlSerializer serializer) throws IOException {
        if (contributor != null) {
            Iterator<Object> iter;
            serializer.startTag(this.NAMESPACE, tagName);
            if (contributor.getName() != null) {
                serializer.startTag(this.NAMESPACE, "name").text(contributor.getName()).endTag(this.NAMESPACE, "name");
            }
            if (contributor.getEmail() != null) {
                serializer.startTag(this.NAMESPACE, "email").text(contributor.getEmail()).endTag(this.NAMESPACE, "email");
            }
            if (contributor.getUrl() != null) {
                serializer.startTag(this.NAMESPACE, "url").text(contributor.getUrl()).endTag(this.NAMESPACE, "url");
            }
            if (contributor.getOrganization() != null) {
                serializer.startTag(this.NAMESPACE, "organization").text(contributor.getOrganization()).endTag(this.NAMESPACE, "organization");
            }
            if (contributor.getOrganizationUrl() != null) {
                serializer.startTag(this.NAMESPACE, "organizationUrl").text(contributor.getOrganizationUrl()).endTag(this.NAMESPACE, "organizationUrl");
            }
            if (contributor.getRoles() != null && contributor.getRoles().size() > 0) {
                serializer.startTag(this.NAMESPACE, "roles");
                iter = contributor.getRoles().iterator();
                while (iter.hasNext()) {
                    String role = (String)iter.next();
                    serializer.startTag(this.NAMESPACE, "role").text(role).endTag(this.NAMESPACE, "role");
                }
                serializer.endTag(this.NAMESPACE, "roles");
            }
            if (contributor.getTimezone() != null) {
                serializer.startTag(this.NAMESPACE, "timezone").text(contributor.getTimezone()).endTag(this.NAMESPACE, "timezone");
            }
            if (contributor.getProperties() != null && contributor.getProperties().size() > 0) {
                serializer.startTag(this.NAMESPACE, "properties");
                iter = contributor.getProperties().keySet().iterator();
                while (iter.hasNext()) {
                    String key = (String)iter.next();
                    String value = (String)contributor.getProperties().get(key);
                    serializer.startTag(this.NAMESPACE, "" + key + "").text(value).endTag(this.NAMESPACE, "" + key + "");
                }
                serializer.endTag(this.NAMESPACE, "properties");
            }
            serializer.endTag(this.NAMESPACE, tagName);
        }
    }

    private void writeDependency(Dependency dependency, String tagName, XmlSerializer serializer) throws IOException {
        if (dependency != null) {
            serializer.startTag(this.NAMESPACE, tagName);
            if (dependency.getGroupId() != null) {
                serializer.startTag(this.NAMESPACE, "groupId").text(dependency.getGroupId()).endTag(this.NAMESPACE, "groupId");
            }
            if (dependency.getArtifactId() != null) {
                serializer.startTag(this.NAMESPACE, "artifactId").text(dependency.getArtifactId()).endTag(this.NAMESPACE, "artifactId");
            }
            if (dependency.getVersion() != null) {
                serializer.startTag(this.NAMESPACE, "version").text(dependency.getVersion()).endTag(this.NAMESPACE, "version");
            }
            if (dependency.getType() != null && !dependency.getType().equals("jar")) {
                serializer.startTag(this.NAMESPACE, "type").text(dependency.getType()).endTag(this.NAMESPACE, "type");
            }
            if (dependency.getClassifier() != null) {
                serializer.startTag(this.NAMESPACE, "classifier").text(dependency.getClassifier()).endTag(this.NAMESPACE, "classifier");
            }
            if (dependency.getScope() != null) {
                serializer.startTag(this.NAMESPACE, "scope").text(dependency.getScope()).endTag(this.NAMESPACE, "scope");
            }
            if (dependency.getSystemPath() != null) {
                serializer.startTag(this.NAMESPACE, "systemPath").text(dependency.getSystemPath()).endTag(this.NAMESPACE, "systemPath");
            }
            if (dependency.getExclusions() != null && dependency.getExclusions().size() > 0) {
                serializer.startTag(this.NAMESPACE, "exclusions");
                Iterator iter = dependency.getExclusions().iterator();
                while (iter.hasNext()) {
                    Exclusion o = (Exclusion)iter.next();
                    this.writeExclusion(o, "exclusion", serializer);
                }
                serializer.endTag(this.NAMESPACE, "exclusions");
            }
            if (dependency.isOptional()) {
                serializer.startTag(this.NAMESPACE, "optional").text(String.valueOf(dependency.isOptional())).endTag(this.NAMESPACE, "optional");
            }
            serializer.endTag(this.NAMESPACE, tagName);
        }
    }

    private void writeDependencyManagement(DependencyManagement dependencyManagement, String tagName, XmlSerializer serializer) throws IOException {
        if (dependencyManagement != null) {
            serializer.startTag(this.NAMESPACE, tagName);
            if (dependencyManagement.getDependencies() != null && dependencyManagement.getDependencies().size() > 0) {
                serializer.startTag(this.NAMESPACE, "dependencies");
                Iterator iter = dependencyManagement.getDependencies().iterator();
                while (iter.hasNext()) {
                    Dependency o = (Dependency)iter.next();
                    this.writeDependency(o, "dependency", serializer);
                }
                serializer.endTag(this.NAMESPACE, "dependencies");
            }
            serializer.endTag(this.NAMESPACE, tagName);
        }
    }

    private void writeDeploymentRepository(DeploymentRepository deploymentRepository, String tagName, XmlSerializer serializer) throws IOException {
        if (deploymentRepository != null) {
            serializer.startTag(this.NAMESPACE, tagName);
            if (!deploymentRepository.isUniqueVersion()) {
                serializer.startTag(this.NAMESPACE, "uniqueVersion").text(String.valueOf(deploymentRepository.isUniqueVersion())).endTag(this.NAMESPACE, "uniqueVersion");
            }
            if (deploymentRepository.getId() != null) {
                serializer.startTag(this.NAMESPACE, "id").text(deploymentRepository.getId()).endTag(this.NAMESPACE, "id");
            }
            if (deploymentRepository.getName() != null) {
                serializer.startTag(this.NAMESPACE, "name").text(deploymentRepository.getName()).endTag(this.NAMESPACE, "name");
            }
            if (deploymentRepository.getUrl() != null) {
                serializer.startTag(this.NAMESPACE, "url").text(deploymentRepository.getUrl()).endTag(this.NAMESPACE, "url");
            }
            if (deploymentRepository.getLayout() != null && !deploymentRepository.getLayout().equals("default")) {
                serializer.startTag(this.NAMESPACE, "layout").text(deploymentRepository.getLayout()).endTag(this.NAMESPACE, "layout");
            }
            serializer.endTag(this.NAMESPACE, tagName);
        }
    }

    private void writeDeveloper(Developer developer, String tagName, XmlSerializer serializer) throws IOException {
        if (developer != null) {
            Iterator<Object> iter;
            serializer.startTag(this.NAMESPACE, tagName);
            if (developer.getId() != null) {
                serializer.startTag(this.NAMESPACE, "id").text(developer.getId()).endTag(this.NAMESPACE, "id");
            }
            if (developer.getName() != null) {
                serializer.startTag(this.NAMESPACE, "name").text(developer.getName()).endTag(this.NAMESPACE, "name");
            }
            if (developer.getEmail() != null) {
                serializer.startTag(this.NAMESPACE, "email").text(developer.getEmail()).endTag(this.NAMESPACE, "email");
            }
            if (developer.getUrl() != null) {
                serializer.startTag(this.NAMESPACE, "url").text(developer.getUrl()).endTag(this.NAMESPACE, "url");
            }
            if (developer.getOrganization() != null) {
                serializer.startTag(this.NAMESPACE, "organization").text(developer.getOrganization()).endTag(this.NAMESPACE, "organization");
            }
            if (developer.getOrganizationUrl() != null) {
                serializer.startTag(this.NAMESPACE, "organizationUrl").text(developer.getOrganizationUrl()).endTag(this.NAMESPACE, "organizationUrl");
            }
            if (developer.getRoles() != null && developer.getRoles().size() > 0) {
                serializer.startTag(this.NAMESPACE, "roles");
                iter = developer.getRoles().iterator();
                while (iter.hasNext()) {
                    String role = (String)iter.next();
                    serializer.startTag(this.NAMESPACE, "role").text(role).endTag(this.NAMESPACE, "role");
                }
                serializer.endTag(this.NAMESPACE, "roles");
            }
            if (developer.getTimezone() != null) {
                serializer.startTag(this.NAMESPACE, "timezone").text(developer.getTimezone()).endTag(this.NAMESPACE, "timezone");
            }
            if (developer.getProperties() != null && developer.getProperties().size() > 0) {
                serializer.startTag(this.NAMESPACE, "properties");
                iter = developer.getProperties().keySet().iterator();
                while (iter.hasNext()) {
                    String key = (String)iter.next();
                    String value = (String)developer.getProperties().get(key);
                    serializer.startTag(this.NAMESPACE, "" + key + "").text(value).endTag(this.NAMESPACE, "" + key + "");
                }
                serializer.endTag(this.NAMESPACE, "properties");
            }
            serializer.endTag(this.NAMESPACE, tagName);
        }
    }

    private void writeDistributionManagement(DistributionManagement distributionManagement, String tagName, XmlSerializer serializer) throws IOException {
        if (distributionManagement != null) {
            serializer.startTag(this.NAMESPACE, tagName);
            if (distributionManagement.getRepository() != null) {
                this.writeDeploymentRepository(distributionManagement.getRepository(), "repository", serializer);
            }
            if (distributionManagement.getSnapshotRepository() != null) {
                this.writeDeploymentRepository(distributionManagement.getSnapshotRepository(), "snapshotRepository", serializer);
            }
            if (distributionManagement.getSite() != null) {
                this.writeSite(distributionManagement.getSite(), "site", serializer);
            }
            if (distributionManagement.getDownloadUrl() != null) {
                serializer.startTag(this.NAMESPACE, "downloadUrl").text(distributionManagement.getDownloadUrl()).endTag(this.NAMESPACE, "downloadUrl");
            }
            if (distributionManagement.getRelocation() != null) {
                this.writeRelocation(distributionManagement.getRelocation(), "relocation", serializer);
            }
            if (distributionManagement.getStatus() != null) {
                serializer.startTag(this.NAMESPACE, "status").text(distributionManagement.getStatus()).endTag(this.NAMESPACE, "status");
            }
            serializer.endTag(this.NAMESPACE, tagName);
        }
    }

    private void writeExclusion(Exclusion exclusion, String tagName, XmlSerializer serializer) throws IOException {
        if (exclusion != null) {
            serializer.startTag(this.NAMESPACE, tagName);
            if (exclusion.getArtifactId() != null) {
                serializer.startTag(this.NAMESPACE, "artifactId").text(exclusion.getArtifactId()).endTag(this.NAMESPACE, "artifactId");
            }
            if (exclusion.getGroupId() != null) {
                serializer.startTag(this.NAMESPACE, "groupId").text(exclusion.getGroupId()).endTag(this.NAMESPACE, "groupId");
            }
            serializer.endTag(this.NAMESPACE, tagName);
        }
    }

    private void writeExtension(Extension extension, String tagName, XmlSerializer serializer) throws IOException {
        if (extension != null) {
            serializer.startTag(this.NAMESPACE, tagName);
            if (extension.getGroupId() != null) {
                serializer.startTag(this.NAMESPACE, "groupId").text(extension.getGroupId()).endTag(this.NAMESPACE, "groupId");
            }
            if (extension.getArtifactId() != null) {
                serializer.startTag(this.NAMESPACE, "artifactId").text(extension.getArtifactId()).endTag(this.NAMESPACE, "artifactId");
            }
            if (extension.getVersion() != null) {
                serializer.startTag(this.NAMESPACE, "version").text(extension.getVersion()).endTag(this.NAMESPACE, "version");
            }
            serializer.endTag(this.NAMESPACE, tagName);
        }
    }

    private void writeFileSet(FileSet fileSet, String tagName, XmlSerializer serializer) throws IOException {
        if (fileSet != null) {
            Iterator iter;
            serializer.startTag(this.NAMESPACE, tagName);
            if (fileSet.getDirectory() != null) {
                serializer.startTag(this.NAMESPACE, "directory").text(fileSet.getDirectory()).endTag(this.NAMESPACE, "directory");
            }
            if (fileSet.getIncludes() != null && fileSet.getIncludes().size() > 0) {
                serializer.startTag(this.NAMESPACE, "includes");
                iter = fileSet.getIncludes().iterator();
                while (iter.hasNext()) {
                    String include = (String)iter.next();
                    serializer.startTag(this.NAMESPACE, "include").text(include).endTag(this.NAMESPACE, "include");
                }
                serializer.endTag(this.NAMESPACE, "includes");
            }
            if (fileSet.getExcludes() != null && fileSet.getExcludes().size() > 0) {
                serializer.startTag(this.NAMESPACE, "excludes");
                iter = fileSet.getExcludes().iterator();
                while (iter.hasNext()) {
                    String exclude = (String)iter.next();
                    serializer.startTag(this.NAMESPACE, "exclude").text(exclude).endTag(this.NAMESPACE, "exclude");
                }
                serializer.endTag(this.NAMESPACE, "excludes");
            }
            serializer.endTag(this.NAMESPACE, tagName);
        }
    }

    private void writeIssueManagement(IssueManagement issueManagement, String tagName, XmlSerializer serializer) throws IOException {
        if (issueManagement != null) {
            serializer.startTag(this.NAMESPACE, tagName);
            if (issueManagement.getSystem() != null) {
                serializer.startTag(this.NAMESPACE, "system").text(issueManagement.getSystem()).endTag(this.NAMESPACE, "system");
            }
            if (issueManagement.getUrl() != null) {
                serializer.startTag(this.NAMESPACE, "url").text(issueManagement.getUrl()).endTag(this.NAMESPACE, "url");
            }
            serializer.endTag(this.NAMESPACE, tagName);
        }
    }

    private void writeLicense(License license, String tagName, XmlSerializer serializer) throws IOException {
        if (license != null) {
            serializer.startTag(this.NAMESPACE, tagName);
            if (license.getName() != null) {
                serializer.startTag(this.NAMESPACE, "name").text(license.getName()).endTag(this.NAMESPACE, "name");
            }
            if (license.getUrl() != null) {
                serializer.startTag(this.NAMESPACE, "url").text(license.getUrl()).endTag(this.NAMESPACE, "url");
            }
            if (license.getDistribution() != null) {
                serializer.startTag(this.NAMESPACE, "distribution").text(license.getDistribution()).endTag(this.NAMESPACE, "distribution");
            }
            if (license.getComments() != null) {
                serializer.startTag(this.NAMESPACE, "comments").text(license.getComments()).endTag(this.NAMESPACE, "comments");
            }
            serializer.endTag(this.NAMESPACE, tagName);
        }
    }

    private void writeMailingList(MailingList mailingList, String tagName, XmlSerializer serializer) throws IOException {
        if (mailingList != null) {
            serializer.startTag(this.NAMESPACE, tagName);
            if (mailingList.getName() != null) {
                serializer.startTag(this.NAMESPACE, "name").text(mailingList.getName()).endTag(this.NAMESPACE, "name");
            }
            if (mailingList.getSubscribe() != null) {
                serializer.startTag(this.NAMESPACE, "subscribe").text(mailingList.getSubscribe()).endTag(this.NAMESPACE, "subscribe");
            }
            if (mailingList.getUnsubscribe() != null) {
                serializer.startTag(this.NAMESPACE, "unsubscribe").text(mailingList.getUnsubscribe()).endTag(this.NAMESPACE, "unsubscribe");
            }
            if (mailingList.getPost() != null) {
                serializer.startTag(this.NAMESPACE, "post").text(mailingList.getPost()).endTag(this.NAMESPACE, "post");
            }
            if (mailingList.getArchive() != null) {
                serializer.startTag(this.NAMESPACE, "archive").text(mailingList.getArchive()).endTag(this.NAMESPACE, "archive");
            }
            if (mailingList.getOtherArchives() != null && mailingList.getOtherArchives().size() > 0) {
                serializer.startTag(this.NAMESPACE, "otherArchives");
                Iterator iter = mailingList.getOtherArchives().iterator();
                while (iter.hasNext()) {
                    String otherArchive = (String)iter.next();
                    serializer.startTag(this.NAMESPACE, "otherArchive").text(otherArchive).endTag(this.NAMESPACE, "otherArchive");
                }
                serializer.endTag(this.NAMESPACE, "otherArchives");
            }
            serializer.endTag(this.NAMESPACE, tagName);
        }
    }

    private void writeModel(Model model, String tagName, XmlSerializer serializer) throws IOException {
        if (model != null) {
            Serializable o;
            Iterator<Object> iter;
            serializer.startTag(this.NAMESPACE, tagName);
            if (model.getParent() != null) {
                this.writeParent(model.getParent(), "parent", serializer);
            }
            if (model.getModelVersion() != null) {
                serializer.startTag(this.NAMESPACE, "modelVersion").text(model.getModelVersion()).endTag(this.NAMESPACE, "modelVersion");
            }
            if (model.getGroupId() != null) {
                serializer.startTag(this.NAMESPACE, "groupId").text(model.getGroupId()).endTag(this.NAMESPACE, "groupId");
            }
            if (model.getArtifactId() != null) {
                serializer.startTag(this.NAMESPACE, "artifactId").text(model.getArtifactId()).endTag(this.NAMESPACE, "artifactId");
            }
            if (model.getPackaging() != null && !model.getPackaging().equals("jar")) {
                serializer.startTag(this.NAMESPACE, "packaging").text(model.getPackaging()).endTag(this.NAMESPACE, "packaging");
            }
            if (model.getName() != null) {
                serializer.startTag(this.NAMESPACE, "name").text(model.getName()).endTag(this.NAMESPACE, "name");
            }
            if (model.getVersion() != null) {
                serializer.startTag(this.NAMESPACE, "version").text(model.getVersion()).endTag(this.NAMESPACE, "version");
            }
            if (model.getDescription() != null) {
                serializer.startTag(this.NAMESPACE, "description").text(model.getDescription()).endTag(this.NAMESPACE, "description");
            }
            if (model.getUrl() != null) {
                serializer.startTag(this.NAMESPACE, "url").text(model.getUrl()).endTag(this.NAMESPACE, "url");
            }
            if (model.getPrerequisites() != null) {
                this.writePrerequisites(model.getPrerequisites(), "prerequisites", serializer);
            }
            if (model.getIssueManagement() != null) {
                this.writeIssueManagement(model.getIssueManagement(), "issueManagement", serializer);
            }
            if (model.getCiManagement() != null) {
                this.writeCiManagement(model.getCiManagement(), "ciManagement", serializer);
            }
            if (model.getInceptionYear() != null) {
                serializer.startTag(this.NAMESPACE, "inceptionYear").text(model.getInceptionYear()).endTag(this.NAMESPACE, "inceptionYear");
            }
            if (model.getMailingLists() != null && model.getMailingLists().size() > 0) {
                serializer.startTag(this.NAMESPACE, "mailingLists");
                iter = model.getMailingLists().iterator();
                while (iter.hasNext()) {
                    o = (MailingList)iter.next();
                    this.writeMailingList((MailingList)o, "mailingList", serializer);
                }
                serializer.endTag(this.NAMESPACE, "mailingLists");
            }
            if (model.getDevelopers() != null && model.getDevelopers().size() > 0) {
                serializer.startTag(this.NAMESPACE, "developers");
                iter = model.getDevelopers().iterator();
                while (iter.hasNext()) {
                    o = (Developer)iter.next();
                    this.writeDeveloper((Developer)o, "developer", serializer);
                }
                serializer.endTag(this.NAMESPACE, "developers");
            }
            if (model.getContributors() != null && model.getContributors().size() > 0) {
                serializer.startTag(this.NAMESPACE, "contributors");
                iter = model.getContributors().iterator();
                while (iter.hasNext()) {
                    o = (Contributor)iter.next();
                    this.writeContributor((Contributor)o, "contributor", serializer);
                }
                serializer.endTag(this.NAMESPACE, "contributors");
            }
            if (model.getLicenses() != null && model.getLicenses().size() > 0) {
                serializer.startTag(this.NAMESPACE, "licenses");
                iter = model.getLicenses().iterator();
                while (iter.hasNext()) {
                    o = (License)iter.next();
                    this.writeLicense((License)o, "license", serializer);
                }
                serializer.endTag(this.NAMESPACE, "licenses");
            }
            if (model.getScm() != null) {
                this.writeScm(model.getScm(), "scm", serializer);
            }
            if (model.getOrganization() != null) {
                this.writeOrganization(model.getOrganization(), "organization", serializer);
            }
            if (model.getBuild() != null) {
                this.writeBuild(model.getBuild(), "build", serializer);
            }
            if (model.getProfiles() != null && model.getProfiles().size() > 0) {
                serializer.startTag(this.NAMESPACE, "profiles");
                iter = model.getProfiles().iterator();
                while (iter.hasNext()) {
                    o = (Profile)iter.next();
                    this.writeProfile((Profile)o, "profile", serializer);
                }
                serializer.endTag(this.NAMESPACE, "profiles");
            }
            if (model.getModules() != null && model.getModules().size() > 0) {
                serializer.startTag(this.NAMESPACE, "modules");
                iter = model.getModules().iterator();
                while (iter.hasNext()) {
                    String module = (String)iter.next();
                    serializer.startTag(this.NAMESPACE, "module").text(module).endTag(this.NAMESPACE, "module");
                }
                serializer.endTag(this.NAMESPACE, "modules");
            }
            if (model.getRepositories() != null && model.getRepositories().size() > 0) {
                serializer.startTag(this.NAMESPACE, "repositories");
                iter = model.getRepositories().iterator();
                while (iter.hasNext()) {
                    o = (Repository)iter.next();
                    this.writeRepository((Repository)o, "repository", serializer);
                }
                serializer.endTag(this.NAMESPACE, "repositories");
            }
            if (model.getPluginRepositories() != null && model.getPluginRepositories().size() > 0) {
                serializer.startTag(this.NAMESPACE, "pluginRepositories");
                iter = model.getPluginRepositories().iterator();
                while (iter.hasNext()) {
                    o = (Repository)iter.next();
                    this.writeRepository((Repository)o, "pluginRepository", serializer);
                }
                serializer.endTag(this.NAMESPACE, "pluginRepositories");
            }
            if (model.getDependencies() != null && model.getDependencies().size() > 0) {
                serializer.startTag(this.NAMESPACE, "dependencies");
                iter = model.getDependencies().iterator();
                while (iter.hasNext()) {
                    o = (Dependency)iter.next();
                    this.writeDependency((Dependency)o, "dependency", serializer);
                }
                serializer.endTag(this.NAMESPACE, "dependencies");
            }
            if (model.getReports() != null) {
                ((Xpp3Dom)model.getReports()).writeToSerializer(this.NAMESPACE, serializer);
            }
            if (model.getReporting() != null) {
                this.writeReporting(model.getReporting(), "reporting", serializer);
            }
            if (model.getDependencyManagement() != null) {
                this.writeDependencyManagement(model.getDependencyManagement(), "dependencyManagement", serializer);
            }
            if (model.getDistributionManagement() != null) {
                this.writeDistributionManagement(model.getDistributionManagement(), "distributionManagement", serializer);
            }
            if (model.getProperties() != null && model.getProperties().size() > 0) {
                serializer.startTag(this.NAMESPACE, "properties");
                iter = model.getProperties().keySet().iterator();
                while (iter.hasNext()) {
                    String key = (String)iter.next();
                    String value = (String)model.getProperties().get(key);
                    serializer.startTag(this.NAMESPACE, "" + key + "").text(value).endTag(this.NAMESPACE, "" + key + "");
                }
                serializer.endTag(this.NAMESPACE, "properties");
            }
            serializer.endTag(this.NAMESPACE, tagName);
        }
    }

    private void writeModelBase(ModelBase modelBase, String tagName, XmlSerializer serializer) throws IOException {
        if (modelBase != null) {
            Serializable o;
            Iterator<Object> iter;
            serializer.startTag(this.NAMESPACE, tagName);
            if (modelBase.getModules() != null && modelBase.getModules().size() > 0) {
                serializer.startTag(this.NAMESPACE, "modules");
                iter = modelBase.getModules().iterator();
                while (iter.hasNext()) {
                    String module = (String)iter.next();
                    serializer.startTag(this.NAMESPACE, "module").text(module).endTag(this.NAMESPACE, "module");
                }
                serializer.endTag(this.NAMESPACE, "modules");
            }
            if (modelBase.getRepositories() != null && modelBase.getRepositories().size() > 0) {
                serializer.startTag(this.NAMESPACE, "repositories");
                iter = modelBase.getRepositories().iterator();
                while (iter.hasNext()) {
                    o = (Repository)iter.next();
                    this.writeRepository((Repository)o, "repository", serializer);
                }
                serializer.endTag(this.NAMESPACE, "repositories");
            }
            if (modelBase.getPluginRepositories() != null && modelBase.getPluginRepositories().size() > 0) {
                serializer.startTag(this.NAMESPACE, "pluginRepositories");
                iter = modelBase.getPluginRepositories().iterator();
                while (iter.hasNext()) {
                    o = (Repository)iter.next();
                    this.writeRepository((Repository)o, "pluginRepository", serializer);
                }
                serializer.endTag(this.NAMESPACE, "pluginRepositories");
            }
            if (modelBase.getDependencies() != null && modelBase.getDependencies().size() > 0) {
                serializer.startTag(this.NAMESPACE, "dependencies");
                iter = modelBase.getDependencies().iterator();
                while (iter.hasNext()) {
                    o = (Dependency)iter.next();
                    this.writeDependency((Dependency)o, "dependency", serializer);
                }
                serializer.endTag(this.NAMESPACE, "dependencies");
            }
            if (modelBase.getReports() != null) {
                ((Xpp3Dom)modelBase.getReports()).writeToSerializer(this.NAMESPACE, serializer);
            }
            if (modelBase.getReporting() != null) {
                this.writeReporting(modelBase.getReporting(), "reporting", serializer);
            }
            if (modelBase.getDependencyManagement() != null) {
                this.writeDependencyManagement(modelBase.getDependencyManagement(), "dependencyManagement", serializer);
            }
            if (modelBase.getDistributionManagement() != null) {
                this.writeDistributionManagement(modelBase.getDistributionManagement(), "distributionManagement", serializer);
            }
            if (modelBase.getProperties() != null && modelBase.getProperties().size() > 0) {
                serializer.startTag(this.NAMESPACE, "properties");
                iter = modelBase.getProperties().keySet().iterator();
                while (iter.hasNext()) {
                    String key = (String)iter.next();
                    String value = (String)modelBase.getProperties().get(key);
                    serializer.startTag(this.NAMESPACE, "" + key + "").text(value).endTag(this.NAMESPACE, "" + key + "");
                }
                serializer.endTag(this.NAMESPACE, "properties");
            }
            serializer.endTag(this.NAMESPACE, tagName);
        }
    }

    private void writeNotifier(Notifier notifier, String tagName, XmlSerializer serializer) throws IOException {
        if (notifier != null) {
            serializer.startTag(this.NAMESPACE, tagName);
            if (notifier.getType() != null && !notifier.getType().equals("mail")) {
                serializer.startTag(this.NAMESPACE, "type").text(notifier.getType()).endTag(this.NAMESPACE, "type");
            }
            if (!notifier.isSendOnError()) {
                serializer.startTag(this.NAMESPACE, "sendOnError").text(String.valueOf(notifier.isSendOnError())).endTag(this.NAMESPACE, "sendOnError");
            }
            if (!notifier.isSendOnFailure()) {
                serializer.startTag(this.NAMESPACE, "sendOnFailure").text(String.valueOf(notifier.isSendOnFailure())).endTag(this.NAMESPACE, "sendOnFailure");
            }
            if (!notifier.isSendOnSuccess()) {
                serializer.startTag(this.NAMESPACE, "sendOnSuccess").text(String.valueOf(notifier.isSendOnSuccess())).endTag(this.NAMESPACE, "sendOnSuccess");
            }
            if (!notifier.isSendOnWarning()) {
                serializer.startTag(this.NAMESPACE, "sendOnWarning").text(String.valueOf(notifier.isSendOnWarning())).endTag(this.NAMESPACE, "sendOnWarning");
            }
            if (notifier.getAddress() != null) {
                serializer.startTag(this.NAMESPACE, "address").text(notifier.getAddress()).endTag(this.NAMESPACE, "address");
            }
            if (notifier.getConfiguration() != null && notifier.getConfiguration().size() > 0) {
                serializer.startTag(this.NAMESPACE, "configuration");
                Iterator<Object> iter = notifier.getConfiguration().keySet().iterator();
                while (iter.hasNext()) {
                    String key = (String)iter.next();
                    String value = (String)notifier.getConfiguration().get(key);
                    serializer.startTag(this.NAMESPACE, "" + key + "").text(value).endTag(this.NAMESPACE, "" + key + "");
                }
                serializer.endTag(this.NAMESPACE, "configuration");
            }
            serializer.endTag(this.NAMESPACE, tagName);
        }
    }

    private void writeOrganization(Organization organization, String tagName, XmlSerializer serializer) throws IOException {
        if (organization != null) {
            serializer.startTag(this.NAMESPACE, tagName);
            if (organization.getName() != null) {
                serializer.startTag(this.NAMESPACE, "name").text(organization.getName()).endTag(this.NAMESPACE, "name");
            }
            if (organization.getUrl() != null) {
                serializer.startTag(this.NAMESPACE, "url").text(organization.getUrl()).endTag(this.NAMESPACE, "url");
            }
            serializer.endTag(this.NAMESPACE, tagName);
        }
    }

    private void writeParent(Parent parent, String tagName, XmlSerializer serializer) throws IOException {
        if (parent != null) {
            serializer.startTag(this.NAMESPACE, tagName);
            if (parent.getArtifactId() != null) {
                serializer.startTag(this.NAMESPACE, "artifactId").text(parent.getArtifactId()).endTag(this.NAMESPACE, "artifactId");
            }
            if (parent.getGroupId() != null) {
                serializer.startTag(this.NAMESPACE, "groupId").text(parent.getGroupId()).endTag(this.NAMESPACE, "groupId");
            }
            if (parent.getVersion() != null) {
                serializer.startTag(this.NAMESPACE, "version").text(parent.getVersion()).endTag(this.NAMESPACE, "version");
            }
            if (parent.getRelativePath() != null && !parent.getRelativePath().equals("../pom.xml")) {
                serializer.startTag(this.NAMESPACE, "relativePath").text(parent.getRelativePath()).endTag(this.NAMESPACE, "relativePath");
            }
            serializer.endTag(this.NAMESPACE, tagName);
        }
    }

    private void writePatternSet(PatternSet patternSet, String tagName, XmlSerializer serializer) throws IOException {
        if (patternSet != null) {
            Iterator iter;
            serializer.startTag(this.NAMESPACE, tagName);
            if (patternSet.getIncludes() != null && patternSet.getIncludes().size() > 0) {
                serializer.startTag(this.NAMESPACE, "includes");
                iter = patternSet.getIncludes().iterator();
                while (iter.hasNext()) {
                    String include = (String)iter.next();
                    serializer.startTag(this.NAMESPACE, "include").text(include).endTag(this.NAMESPACE, "include");
                }
                serializer.endTag(this.NAMESPACE, "includes");
            }
            if (patternSet.getExcludes() != null && patternSet.getExcludes().size() > 0) {
                serializer.startTag(this.NAMESPACE, "excludes");
                iter = patternSet.getExcludes().iterator();
                while (iter.hasNext()) {
                    String exclude = (String)iter.next();
                    serializer.startTag(this.NAMESPACE, "exclude").text(exclude).endTag(this.NAMESPACE, "exclude");
                }
                serializer.endTag(this.NAMESPACE, "excludes");
            }
            serializer.endTag(this.NAMESPACE, tagName);
        }
    }

    private void writePlugin(Plugin plugin, String tagName, XmlSerializer serializer) throws IOException {
        if (plugin != null) {
            Serializable o;
            Iterator iter;
            serializer.startTag(this.NAMESPACE, tagName);
            if (plugin.getGroupId() != null && !plugin.getGroupId().equals("org.apache.maven.plugins")) {
                serializer.startTag(this.NAMESPACE, "groupId").text(plugin.getGroupId()).endTag(this.NAMESPACE, "groupId");
            }
            if (plugin.getArtifactId() != null) {
                serializer.startTag(this.NAMESPACE, "artifactId").text(plugin.getArtifactId()).endTag(this.NAMESPACE, "artifactId");
            }
            if (plugin.getVersion() != null) {
                serializer.startTag(this.NAMESPACE, "version").text(plugin.getVersion()).endTag(this.NAMESPACE, "version");
            }
            if (plugin.isExtensions()) {
                serializer.startTag(this.NAMESPACE, "extensions").text(String.valueOf(plugin.isExtensions())).endTag(this.NAMESPACE, "extensions");
            }
            if (plugin.getExecutions() != null && plugin.getExecutions().size() > 0) {
                serializer.startTag(this.NAMESPACE, "executions");
                iter = plugin.getExecutions().iterator();
                while (iter.hasNext()) {
                    o = (PluginExecution)iter.next();
                    this.writePluginExecution((PluginExecution)o, "execution", serializer);
                }
                serializer.endTag(this.NAMESPACE, "executions");
            }
            if (plugin.getDependencies() != null && plugin.getDependencies().size() > 0) {
                serializer.startTag(this.NAMESPACE, "dependencies");
                iter = plugin.getDependencies().iterator();
                while (iter.hasNext()) {
                    o = (Dependency)iter.next();
                    this.writeDependency((Dependency)o, "dependency", serializer);
                }
                serializer.endTag(this.NAMESPACE, "dependencies");
            }
            if (plugin.getGoals() != null) {
                ((Xpp3Dom)plugin.getGoals()).writeToSerializer(this.NAMESPACE, serializer);
            }
            if (plugin.getInherited() != null) {
                serializer.startTag(this.NAMESPACE, "inherited").text(plugin.getInherited()).endTag(this.NAMESPACE, "inherited");
            }
            if (plugin.getConfiguration() != null) {
                ((Xpp3Dom)plugin.getConfiguration()).writeToSerializer(this.NAMESPACE, serializer);
            }
            serializer.endTag(this.NAMESPACE, tagName);
        }
    }

    private void writePluginConfiguration(PluginConfiguration pluginConfiguration, String tagName, XmlSerializer serializer) throws IOException {
        if (pluginConfiguration != null) {
            serializer.startTag(this.NAMESPACE, tagName);
            if (pluginConfiguration.getPluginManagement() != null) {
                this.writePluginManagement(pluginConfiguration.getPluginManagement(), "pluginManagement", serializer);
            }
            if (pluginConfiguration.getPlugins() != null && pluginConfiguration.getPlugins().size() > 0) {
                serializer.startTag(this.NAMESPACE, "plugins");
                Iterator iter = pluginConfiguration.getPlugins().iterator();
                while (iter.hasNext()) {
                    Plugin o = (Plugin)iter.next();
                    this.writePlugin(o, "plugin", serializer);
                }
                serializer.endTag(this.NAMESPACE, "plugins");
            }
            serializer.endTag(this.NAMESPACE, tagName);
        }
    }

    private void writePluginContainer(PluginContainer pluginContainer, String tagName, XmlSerializer serializer) throws IOException {
        if (pluginContainer != null) {
            serializer.startTag(this.NAMESPACE, tagName);
            if (pluginContainer.getPlugins() != null && pluginContainer.getPlugins().size() > 0) {
                serializer.startTag(this.NAMESPACE, "plugins");
                Iterator iter = pluginContainer.getPlugins().iterator();
                while (iter.hasNext()) {
                    Plugin o = (Plugin)iter.next();
                    this.writePlugin(o, "plugin", serializer);
                }
                serializer.endTag(this.NAMESPACE, "plugins");
            }
            serializer.endTag(this.NAMESPACE, tagName);
        }
    }

    private void writePluginExecution(PluginExecution pluginExecution, String tagName, XmlSerializer serializer) throws IOException {
        if (pluginExecution != null) {
            serializer.startTag(this.NAMESPACE, tagName);
            if (pluginExecution.getId() != null && !pluginExecution.getId().equals("default")) {
                serializer.startTag(this.NAMESPACE, "id").text(pluginExecution.getId()).endTag(this.NAMESPACE, "id");
            }
            if (pluginExecution.getPhase() != null) {
                serializer.startTag(this.NAMESPACE, "phase").text(pluginExecution.getPhase()).endTag(this.NAMESPACE, "phase");
            }
            if (pluginExecution.getGoals() != null && pluginExecution.getGoals().size() > 0) {
                serializer.startTag(this.NAMESPACE, "goals");
                Iterator iter = pluginExecution.getGoals().iterator();
                while (iter.hasNext()) {
                    String goal = (String)iter.next();
                    serializer.startTag(this.NAMESPACE, "goal").text(goal).endTag(this.NAMESPACE, "goal");
                }
                serializer.endTag(this.NAMESPACE, "goals");
            }
            if (pluginExecution.getInherited() != null) {
                serializer.startTag(this.NAMESPACE, "inherited").text(pluginExecution.getInherited()).endTag(this.NAMESPACE, "inherited");
            }
            if (pluginExecution.getConfiguration() != null) {
                ((Xpp3Dom)pluginExecution.getConfiguration()).writeToSerializer(this.NAMESPACE, serializer);
            }
            serializer.endTag(this.NAMESPACE, tagName);
        }
    }

    private void writePluginManagement(PluginManagement pluginManagement, String tagName, XmlSerializer serializer) throws IOException {
        if (pluginManagement != null) {
            serializer.startTag(this.NAMESPACE, tagName);
            if (pluginManagement.getPlugins() != null && pluginManagement.getPlugins().size() > 0) {
                serializer.startTag(this.NAMESPACE, "plugins");
                Iterator iter = pluginManagement.getPlugins().iterator();
                while (iter.hasNext()) {
                    Plugin o = (Plugin)iter.next();
                    this.writePlugin(o, "plugin", serializer);
                }
                serializer.endTag(this.NAMESPACE, "plugins");
            }
            serializer.endTag(this.NAMESPACE, tagName);
        }
    }

    private void writePrerequisites(Prerequisites prerequisites, String tagName, XmlSerializer serializer) throws IOException {
        if (prerequisites != null) {
            serializer.startTag(this.NAMESPACE, tagName);
            if (prerequisites.getMaven() != null && !prerequisites.getMaven().equals("2.0")) {
                serializer.startTag(this.NAMESPACE, "maven").text(prerequisites.getMaven()).endTag(this.NAMESPACE, "maven");
            }
            serializer.endTag(this.NAMESPACE, tagName);
        }
    }

    private void writeProfile(Profile profile, String tagName, XmlSerializer serializer) throws IOException {
        if (profile != null) {
            Serializable o;
            Iterator<Object> iter;
            serializer.startTag(this.NAMESPACE, tagName);
            if (profile.getId() != null) {
                serializer.startTag(this.NAMESPACE, "id").text(profile.getId()).endTag(this.NAMESPACE, "id");
            }
            if (profile.getActivation() != null) {
                this.writeActivation(profile.getActivation(), "activation", serializer);
            }
            if (profile.getBuild() != null) {
                this.writeBuildBase(profile.getBuild(), "build", serializer);
            }
            if (profile.getModules() != null && profile.getModules().size() > 0) {
                serializer.startTag(this.NAMESPACE, "modules");
                iter = profile.getModules().iterator();
                while (iter.hasNext()) {
                    String module = (String)iter.next();
                    serializer.startTag(this.NAMESPACE, "module").text(module).endTag(this.NAMESPACE, "module");
                }
                serializer.endTag(this.NAMESPACE, "modules");
            }
            if (profile.getRepositories() != null && profile.getRepositories().size() > 0) {
                serializer.startTag(this.NAMESPACE, "repositories");
                iter = profile.getRepositories().iterator();
                while (iter.hasNext()) {
                    o = (Repository)iter.next();
                    this.writeRepository((Repository)o, "repository", serializer);
                }
                serializer.endTag(this.NAMESPACE, "repositories");
            }
            if (profile.getPluginRepositories() != null && profile.getPluginRepositories().size() > 0) {
                serializer.startTag(this.NAMESPACE, "pluginRepositories");
                iter = profile.getPluginRepositories().iterator();
                while (iter.hasNext()) {
                    o = (Repository)iter.next();
                    this.writeRepository((Repository)o, "pluginRepository", serializer);
                }
                serializer.endTag(this.NAMESPACE, "pluginRepositories");
            }
            if (profile.getDependencies() != null && profile.getDependencies().size() > 0) {
                serializer.startTag(this.NAMESPACE, "dependencies");
                iter = profile.getDependencies().iterator();
                while (iter.hasNext()) {
                    o = (Dependency)iter.next();
                    this.writeDependency((Dependency)o, "dependency", serializer);
                }
                serializer.endTag(this.NAMESPACE, "dependencies");
            }
            if (profile.getReports() != null) {
                ((Xpp3Dom)profile.getReports()).writeToSerializer(this.NAMESPACE, serializer);
            }
            if (profile.getReporting() != null) {
                this.writeReporting(profile.getReporting(), "reporting", serializer);
            }
            if (profile.getDependencyManagement() != null) {
                this.writeDependencyManagement(profile.getDependencyManagement(), "dependencyManagement", serializer);
            }
            if (profile.getDistributionManagement() != null) {
                this.writeDistributionManagement(profile.getDistributionManagement(), "distributionManagement", serializer);
            }
            if (profile.getProperties() != null && profile.getProperties().size() > 0) {
                serializer.startTag(this.NAMESPACE, "properties");
                iter = profile.getProperties().keySet().iterator();
                while (iter.hasNext()) {
                    String key = (String)iter.next();
                    String value = (String)profile.getProperties().get(key);
                    serializer.startTag(this.NAMESPACE, "" + key + "").text(value).endTag(this.NAMESPACE, "" + key + "");
                }
                serializer.endTag(this.NAMESPACE, "properties");
            }
            serializer.endTag(this.NAMESPACE, tagName);
        }
    }

    private void writeRelocation(Relocation relocation, String tagName, XmlSerializer serializer) throws IOException {
        if (relocation != null) {
            serializer.startTag(this.NAMESPACE, tagName);
            if (relocation.getGroupId() != null) {
                serializer.startTag(this.NAMESPACE, "groupId").text(relocation.getGroupId()).endTag(this.NAMESPACE, "groupId");
            }
            if (relocation.getArtifactId() != null) {
                serializer.startTag(this.NAMESPACE, "artifactId").text(relocation.getArtifactId()).endTag(this.NAMESPACE, "artifactId");
            }
            if (relocation.getVersion() != null) {
                serializer.startTag(this.NAMESPACE, "version").text(relocation.getVersion()).endTag(this.NAMESPACE, "version");
            }
            if (relocation.getMessage() != null) {
                serializer.startTag(this.NAMESPACE, "message").text(relocation.getMessage()).endTag(this.NAMESPACE, "message");
            }
            serializer.endTag(this.NAMESPACE, tagName);
        }
    }

    private void writeReportPlugin(ReportPlugin reportPlugin, String tagName, XmlSerializer serializer) throws IOException {
        if (reportPlugin != null) {
            serializer.startTag(this.NAMESPACE, tagName);
            if (reportPlugin.getGroupId() != null && !reportPlugin.getGroupId().equals("org.apache.maven.plugins")) {
                serializer.startTag(this.NAMESPACE, "groupId").text(reportPlugin.getGroupId()).endTag(this.NAMESPACE, "groupId");
            }
            if (reportPlugin.getArtifactId() != null) {
                serializer.startTag(this.NAMESPACE, "artifactId").text(reportPlugin.getArtifactId()).endTag(this.NAMESPACE, "artifactId");
            }
            if (reportPlugin.getVersion() != null) {
                serializer.startTag(this.NAMESPACE, "version").text(reportPlugin.getVersion()).endTag(this.NAMESPACE, "version");
            }
            if (reportPlugin.getInherited() != null) {
                serializer.startTag(this.NAMESPACE, "inherited").text(reportPlugin.getInherited()).endTag(this.NAMESPACE, "inherited");
            }
            if (reportPlugin.getConfiguration() != null) {
                ((Xpp3Dom)reportPlugin.getConfiguration()).writeToSerializer(this.NAMESPACE, serializer);
            }
            if (reportPlugin.getReportSets() != null && reportPlugin.getReportSets().size() > 0) {
                serializer.startTag(this.NAMESPACE, "reportSets");
                Iterator iter = reportPlugin.getReportSets().iterator();
                while (iter.hasNext()) {
                    ReportSet o = (ReportSet)iter.next();
                    this.writeReportSet(o, "reportSet", serializer);
                }
                serializer.endTag(this.NAMESPACE, "reportSets");
            }
            serializer.endTag(this.NAMESPACE, tagName);
        }
    }

    private void writeReportSet(ReportSet reportSet, String tagName, XmlSerializer serializer) throws IOException {
        if (reportSet != null) {
            serializer.startTag(this.NAMESPACE, tagName);
            if (reportSet.getId() != null && !reportSet.getId().equals("default")) {
                serializer.startTag(this.NAMESPACE, "id").text(reportSet.getId()).endTag(this.NAMESPACE, "id");
            }
            if (reportSet.getConfiguration() != null) {
                ((Xpp3Dom)reportSet.getConfiguration()).writeToSerializer(this.NAMESPACE, serializer);
            }
            if (reportSet.getInherited() != null) {
                serializer.startTag(this.NAMESPACE, "inherited").text(reportSet.getInherited()).endTag(this.NAMESPACE, "inherited");
            }
            if (reportSet.getReports() != null && reportSet.getReports().size() > 0) {
                serializer.startTag(this.NAMESPACE, "reports");
                Iterator iter = reportSet.getReports().iterator();
                while (iter.hasNext()) {
                    String report = (String)iter.next();
                    serializer.startTag(this.NAMESPACE, "report").text(report).endTag(this.NAMESPACE, "report");
                }
                serializer.endTag(this.NAMESPACE, "reports");
            }
            serializer.endTag(this.NAMESPACE, tagName);
        }
    }

    private void writeReporting(Reporting reporting, String tagName, XmlSerializer serializer) throws IOException {
        if (reporting != null) {
            serializer.startTag(this.NAMESPACE, tagName);
            if (reporting.isExcludeDefaults()) {
                serializer.startTag(this.NAMESPACE, "excludeDefaults").text(String.valueOf(reporting.isExcludeDefaults())).endTag(this.NAMESPACE, "excludeDefaults");
            }
            if (reporting.getOutputDirectory() != null) {
                serializer.startTag(this.NAMESPACE, "outputDirectory").text(reporting.getOutputDirectory()).endTag(this.NAMESPACE, "outputDirectory");
            }
            if (reporting.getPlugins() != null && reporting.getPlugins().size() > 0) {
                serializer.startTag(this.NAMESPACE, "plugins");
                Iterator iter = reporting.getPlugins().iterator();
                while (iter.hasNext()) {
                    ReportPlugin o = (ReportPlugin)iter.next();
                    this.writeReportPlugin(o, "plugin", serializer);
                }
                serializer.endTag(this.NAMESPACE, "plugins");
            }
            serializer.endTag(this.NAMESPACE, tagName);
        }
    }

    private void writeRepository(Repository repository, String tagName, XmlSerializer serializer) throws IOException {
        if (repository != null) {
            serializer.startTag(this.NAMESPACE, tagName);
            if (repository.getReleases() != null) {
                this.writeRepositoryPolicy(repository.getReleases(), "releases", serializer);
            }
            if (repository.getSnapshots() != null) {
                this.writeRepositoryPolicy(repository.getSnapshots(), "snapshots", serializer);
            }
            if (repository.getId() != null) {
                serializer.startTag(this.NAMESPACE, "id").text(repository.getId()).endTag(this.NAMESPACE, "id");
            }
            if (repository.getName() != null) {
                serializer.startTag(this.NAMESPACE, "name").text(repository.getName()).endTag(this.NAMESPACE, "name");
            }
            if (repository.getUrl() != null) {
                serializer.startTag(this.NAMESPACE, "url").text(repository.getUrl()).endTag(this.NAMESPACE, "url");
            }
            if (repository.getLayout() != null && !repository.getLayout().equals("default")) {
                serializer.startTag(this.NAMESPACE, "layout").text(repository.getLayout()).endTag(this.NAMESPACE, "layout");
            }
            serializer.endTag(this.NAMESPACE, tagName);
        }
    }

    private void writeRepositoryBase(RepositoryBase repositoryBase, String tagName, XmlSerializer serializer) throws IOException {
        if (repositoryBase != null) {
            serializer.startTag(this.NAMESPACE, tagName);
            if (repositoryBase.getId() != null) {
                serializer.startTag(this.NAMESPACE, "id").text(repositoryBase.getId()).endTag(this.NAMESPACE, "id");
            }
            if (repositoryBase.getName() != null) {
                serializer.startTag(this.NAMESPACE, "name").text(repositoryBase.getName()).endTag(this.NAMESPACE, "name");
            }
            if (repositoryBase.getUrl() != null) {
                serializer.startTag(this.NAMESPACE, "url").text(repositoryBase.getUrl()).endTag(this.NAMESPACE, "url");
            }
            if (repositoryBase.getLayout() != null && !repositoryBase.getLayout().equals("default")) {
                serializer.startTag(this.NAMESPACE, "layout").text(repositoryBase.getLayout()).endTag(this.NAMESPACE, "layout");
            }
            serializer.endTag(this.NAMESPACE, tagName);
        }
    }

    private void writeRepositoryPolicy(RepositoryPolicy repositoryPolicy, String tagName, XmlSerializer serializer) throws IOException {
        if (repositoryPolicy != null) {
            serializer.startTag(this.NAMESPACE, tagName);
            if (!repositoryPolicy.isEnabled()) {
                serializer.startTag(this.NAMESPACE, "enabled").text(String.valueOf(repositoryPolicy.isEnabled())).endTag(this.NAMESPACE, "enabled");
            }
            if (repositoryPolicy.getUpdatePolicy() != null) {
                serializer.startTag(this.NAMESPACE, "updatePolicy").text(repositoryPolicy.getUpdatePolicy()).endTag(this.NAMESPACE, "updatePolicy");
            }
            if (repositoryPolicy.getChecksumPolicy() != null) {
                serializer.startTag(this.NAMESPACE, "checksumPolicy").text(repositoryPolicy.getChecksumPolicy()).endTag(this.NAMESPACE, "checksumPolicy");
            }
            serializer.endTag(this.NAMESPACE, tagName);
        }
    }

    private void writeResource(Resource resource, String tagName, XmlSerializer serializer) throws IOException {
        if (resource != null) {
            Iterator iter;
            serializer.startTag(this.NAMESPACE, tagName);
            if (resource.getTargetPath() != null) {
                serializer.startTag(this.NAMESPACE, "targetPath").text(resource.getTargetPath()).endTag(this.NAMESPACE, "targetPath");
            }
            if (resource.isFiltering()) {
                serializer.startTag(this.NAMESPACE, "filtering").text(String.valueOf(resource.isFiltering())).endTag(this.NAMESPACE, "filtering");
            }
            if (resource.getDirectory() != null) {
                serializer.startTag(this.NAMESPACE, "directory").text(resource.getDirectory()).endTag(this.NAMESPACE, "directory");
            }
            if (resource.getIncludes() != null && resource.getIncludes().size() > 0) {
                serializer.startTag(this.NAMESPACE, "includes");
                iter = resource.getIncludes().iterator();
                while (iter.hasNext()) {
                    String include = (String)iter.next();
                    serializer.startTag(this.NAMESPACE, "include").text(include).endTag(this.NAMESPACE, "include");
                }
                serializer.endTag(this.NAMESPACE, "includes");
            }
            if (resource.getExcludes() != null && resource.getExcludes().size() > 0) {
                serializer.startTag(this.NAMESPACE, "excludes");
                iter = resource.getExcludes().iterator();
                while (iter.hasNext()) {
                    String exclude = (String)iter.next();
                    serializer.startTag(this.NAMESPACE, "exclude").text(exclude).endTag(this.NAMESPACE, "exclude");
                }
                serializer.endTag(this.NAMESPACE, "excludes");
            }
            serializer.endTag(this.NAMESPACE, tagName);
        }
    }

    private void writeScm(Scm scm, String tagName, XmlSerializer serializer) throws IOException {
        if (scm != null) {
            serializer.startTag(this.NAMESPACE, tagName);
            if (scm.getConnection() != null) {
                serializer.startTag(this.NAMESPACE, "connection").text(scm.getConnection()).endTag(this.NAMESPACE, "connection");
            }
            if (scm.getDeveloperConnection() != null) {
                serializer.startTag(this.NAMESPACE, "developerConnection").text(scm.getDeveloperConnection()).endTag(this.NAMESPACE, "developerConnection");
            }
            if (scm.getTag() != null && !scm.getTag().equals("HEAD")) {
                serializer.startTag(this.NAMESPACE, "tag").text(scm.getTag()).endTag(this.NAMESPACE, "tag");
            }
            if (scm.getUrl() != null) {
                serializer.startTag(this.NAMESPACE, "url").text(scm.getUrl()).endTag(this.NAMESPACE, "url");
            }
            serializer.endTag(this.NAMESPACE, tagName);
        }
    }

    private void writeSite(Site site, String tagName, XmlSerializer serializer) throws IOException {
        if (site != null) {
            serializer.startTag(this.NAMESPACE, tagName);
            if (site.getId() != null) {
                serializer.startTag(this.NAMESPACE, "id").text(site.getId()).endTag(this.NAMESPACE, "id");
            }
            if (site.getName() != null) {
                serializer.startTag(this.NAMESPACE, "name").text(site.getName()).endTag(this.NAMESPACE, "name");
            }
            if (site.getUrl() != null) {
                serializer.startTag(this.NAMESPACE, "url").text(site.getUrl()).endTag(this.NAMESPACE, "url");
            }
            serializer.endTag(this.NAMESPACE, tagName);
        }
    }
}

