/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.xnio.channels;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.jboss.xnio.Buffers;
import org.jboss.xnio.IoHandler;
import org.jboss.xnio.channels.AllocatedMessageChannel;
import org.jboss.xnio.channels.ChannelOption;
import org.jboss.xnio.channels.Configurable;
import org.jboss.xnio.channels.StreamChannel;
import org.jboss.xnio.channels.UnsupportedOptionException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class StreamChannelAllocatedMessageChannelHandler
implements IoHandler<AllocatedMessageChannel> {
    private final IoHandler<? super StreamChannel> handler;
    private final AtomicBoolean isnew = new AtomicBoolean(true);
    private final AtomicBoolean closed = new AtomicBoolean();
    private volatile StreamChannelImpl streamChannel;
    private final Lock readLock = new ReentrantLock();
    private ByteBuffer readBuffer;

    StreamChannel getChannel(AllocatedMessageChannel channel) {
        if (this.isnew.getAndSet(false)) {
            this.streamChannel = new StreamChannelImpl(channel);
        }
        return this.streamChannel;
    }

    public StreamChannelAllocatedMessageChannelHandler(IoHandler<? super StreamChannel> handler) {
        this.handler = handler;
    }

    @Override
    public void handleOpened(AllocatedMessageChannel channel) {
        if (this.isnew.getAndSet(false)) {
            this.streamChannel = new StreamChannelImpl(channel);
        }
        this.handler.handleOpened(this.streamChannel);
    }

    @Override
    public void handleClosed(AllocatedMessageChannel channel) {
        this.handler.handleClosed(this.streamChannel);
    }

    @Override
    public void handleReadable(AllocatedMessageChannel channel) {
        this.handler.handleReadable(this.streamChannel);
    }

    @Override
    public void handleWritable(AllocatedMessageChannel channel) {
        this.handler.handleWritable(this.streamChannel);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class StreamChannelImpl
    implements StreamChannel {
        private final AllocatedMessageChannel messageChannel;

        private StreamChannelImpl(AllocatedMessageChannel messageChannel) {
            this.messageChannel = messageChannel;
        }

        @Override
        public boolean isOpen() {
            return false;
        }

        @Override
        public void close() throws IOException {
            if (!StreamChannelAllocatedMessageChannelHandler.this.closed.getAndSet(true)) {
                this.messageChannel.close();
            }
        }

        @Override
        public void suspendReads() {
            this.messageChannel.suspendReads();
        }

        @Override
        public void resumeReads() {
            this.messageChannel.resumeReads();
        }

        @Override
        public void shutdownReads() throws IOException {
            this.messageChannel.shutdownReads();
        }

        @Override
        public void awaitReadable() throws IOException {
            this.messageChannel.awaitReadable();
        }

        @Override
        public void awaitReadable(long time, TimeUnit timeUnit) throws IOException {
            this.messageChannel.awaitReadable(time, timeUnit);
        }

        @Override
        public <T> T getOption(ChannelOption<T> option) throws UnsupportedOptionException, IOException {
            return this.messageChannel.getOption(option);
        }

        @Override
        public Set<ChannelOption<?>> getOptions() {
            return this.messageChannel.getOptions();
        }

        @Override
        public <T> Configurable setOption(ChannelOption<T> option, T value) throws IllegalArgumentException, IOException {
            return this.messageChannel.setOption(option, value);
        }

        @Override
        public void suspendWrites() {
            this.messageChannel.suspendWrites();
        }

        @Override
        public void resumeWrites() {
            this.messageChannel.resumeWrites();
        }

        @Override
        public void shutdownWrites() throws IOException {
            this.messageChannel.shutdownWrites();
        }

        @Override
        public void awaitWritable() throws IOException {
            this.messageChannel.awaitWritable();
        }

        @Override
        public void awaitWritable(long time, TimeUnit timeUnit) throws IOException {
            this.messageChannel.awaitWritable(time, timeUnit);
        }

        @Override
        public int write(ByteBuffer src) throws IOException {
            int c = src.remaining();
            return this.messageChannel.send(src) ? c : 0;
        }

        @Override
        public long write(ByteBuffer[] srcs, int offset, int length) throws IOException {
            long c = 0L;
            for (int i = 0; i < length; ++i) {
                c += (long)srcs[i].remaining();
            }
            return this.messageChannel.send(srcs, offset, length) ? c : 0L;
        }

        @Override
        public long write(ByteBuffer[] srcs) throws IOException {
            return this.write(srcs, 0, srcs.length);
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public int read(ByteBuffer dst) throws IOException {
            int cnt = 0;
            StreamChannelAllocatedMessageChannelHandler.this.readLock.lock();
            try {
                ByteBuffer readBuffer = StreamChannelAllocatedMessageChannelHandler.this.readBuffer;
                try {
                    int dstRemaining;
                    while (true) {
                        if (readBuffer == null && (readBuffer = this.messageChannel.receive()) == null) {
                            int n = cnt;
                            return n;
                        }
                        dstRemaining = dst.remaining();
                        int readBufferRemaining = readBuffer.remaining();
                        if (readBufferRemaining >= dstRemaining) break;
                        dst.put(readBuffer);
                        cnt += readBufferRemaining;
                        readBuffer = null;
                    }
                    dst.put(Buffers.slice(readBuffer, dstRemaining));
                    int n = cnt += dstRemaining;
                    return n;
                }
                finally {
                    StreamChannelAllocatedMessageChannelHandler.this.readBuffer = readBuffer;
                }
            }
            finally {
                StreamChannelAllocatedMessageChannelHandler.this.readLock.unlock();
            }
        }

        /*
         * Exception decompiling
         */
        @Override
        public long read(ByteBuffer[] dsts, int offset, int length) throws IOException {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        @Override
        public long read(ByteBuffer[] dsts) throws IOException {
            return this.read(dsts, 0, dsts.length);
        }
    }
}

