/*
 * Decompiled with CFR 0.152.
 */
package EDU.oswego.cs.dl.util.concurrent.misc;

import EDU.oswego.cs.dl.util.concurrent.BrokenBarrierException;
import EDU.oswego.cs.dl.util.concurrent.Channel;
import EDU.oswego.cs.dl.util.concurrent.CyclicBarrier;
import EDU.oswego.cs.dl.util.concurrent.misc.ChanRNG;
import EDU.oswego.cs.dl.util.concurrent.misc.Fraction;
import EDU.oswego.cs.dl.util.concurrent.misc.RNG;
import EDU.oswego.cs.dl.util.concurrent.misc.TestLoop;

class PCTestLoop
extends TestLoop {
    final Channel primaryChannel;
    final Channel sharedChannel;

    public PCTestLoop(RNG sh, RNG pri, Fraction pshr, int it, CyclicBarrier br, Channel shChan, Channel priChan) {
        super(sh, pri, pshr, it, br);
        this.sharedChannel = shChan;
        this.primaryChannel = priChan;
    }

    public Runnable testLoop(final boolean isProducer) {
        return new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public void run() {
                int delta = -1;
                Thread.currentThread().setPriority(5 + delta);
                int itersPerBarrier = RNG.itersPerBarrier.get();
                try {
                    int nshared = (int)((double)PCTestLoop.this.iters * PCTestLoop.this.pshared.asDouble());
                    int nprimary = PCTestLoop.this.iters - nshared;
                    int idx = PCTestLoop.this.firstidx;
                    PCTestLoop.this.barrier.barrier();
                    ChanRNG target = (ChanRNG)PCTestLoop.this.primary;
                    int i = PCTestLoop.this.iters;
                    while (i > 0) {
                        ++idx;
                        if (i % itersPerBarrier == 0) {
                            PCTestLoop.this.primary.exchange();
                        } else {
                            Channel c;
                            if (nshared > 0 && PCTestLoop.this.useShared[idx % PCTestLoop.this.useShared.length]) {
                                --nshared;
                                c = PCTestLoop.this.sharedChannel;
                            } else {
                                --nprimary;
                                c = PCTestLoop.this.primaryChannel;
                            }
                            long rnd = isProducer ? target.producerNext(c) : target.consumerNext(c);
                            if (rnd % 2L == 0L && Thread.currentThread().isInterrupted()) {
                                return;
                            }
                        }
                        --i;
                    }
                    return;
                }
                catch (BrokenBarrierException ex) {
                    try {
                        PCTestLoop.this.barrier.barrier();
                        return;
                    }
                    catch (InterruptedException ex2) {
                        Thread.currentThread().interrupt();
                        return;
                    }
                    catch (BrokenBarrierException ex3) {
                        return;
                    }
                    finally {
                        Thread.currentThread().setPriority(5);
                    }
                }
                catch (InterruptedException ex) {
                    Thread.currentThread().interrupt();
                    return;
                }
                finally {
                    try {
                        PCTestLoop.this.barrier.barrier();
                    }
                    catch (InterruptedException ex) {
                        Thread.currentThread().interrupt();
                    }
                    catch (BrokenBarrierException brokenBarrierException) {
                    }
                    finally {
                        Thread.currentThread().setPriority(5);
                    }
                }
            }
        };
    }
}

