/*
 * Decompiled with CFR 0.152.
 */
package xdoclet.modules.ejb.home;

import org.apache.commons.logging.Log;
import xdoclet.XDocletException;
import xdoclet.XDocletMessages;
import xdoclet.modules.ejb.AbstractEjbCodeGeneratorSubTask;
import xdoclet.modules.ejb.XDocletModulesEjbMessages;
import xdoclet.modules.ejb.home.HomeTagsHandler;
import xdoclet.modules.ejb.intf.InterfaceTagsHandler;
import xdoclet.tagshandler.PackageTagsHandler;
import xdoclet.util.LogUtil;
import xdoclet.util.Translator;
import xjavadoc.XClass;
import xjavadoc.XTag;

public class HomeInterfaceSubTask
extends AbstractEjbCodeGeneratorSubTask {
    public static final String DEFAULT_HOMEINTERFACE_CLASS_PATTERN = "{0}Home";
    protected static final String DEFAULT_TEMPLATE_FILE = "resources/home.xdt";
    protected String homeClassPattern;

    public HomeInterfaceSubTask() {
        this.setTemplateURL(((Object)((Object)this)).getClass().getResource(DEFAULT_TEMPLATE_FILE));
        this.setDestinationFile(this.getHomeClassPattern() + ".java");
        this.addOfType("javax.ejb.EntityBean");
        this.addOfType("javax.ejb.SessionBean");
    }

    public String getHomeClassPattern() {
        if (this.homeClassPattern != null) {
            return this.homeClassPattern;
        }
        return DEFAULT_HOMEINTERFACE_CLASS_PATTERN;
    }

    public void setPattern(String new_pattern) {
        Log log = LogUtil.getLog(HomeInterfaceSubTask.class, (String)"setPattern");
        log.debug((Object)("Set pattern to " + new_pattern));
        this.homeClassPattern = new_pattern;
    }

    public void validateOptions() throws XDocletException {
        super.validateOptions();
        if (this.getHomeClassPattern() == null || this.getHomeClassPattern().trim().equals("")) {
            throw new XDocletException(Translator.getString(XDocletMessages.class, (String)"PARAMETER_MISSING_OR_EMPTY", (String[])new String[]{"pattern"}));
        }
        if (this.getHomeClassPattern().indexOf("{0}") == -1) {
            throw new XDocletException(Translator.getString(XDocletModulesEjbMessages.class, (String)"PATTERN_HAS_NO_PLACEHOLDER"));
        }
    }

    protected String getGeneratedFileName(XClass clazz) throws XDocletException {
        return PackageTagsHandler.packageNameAsPathFor((String)HomeTagsHandler.getHomeInterface("remote", this.getCurrentClass())) + ".java";
    }

    protected boolean matchesGenerationRules(XClass clazz) throws XDocletException {
        if (!super.matchesGenerationRules(clazz)) {
            return false;
        }
        Log log = LogUtil.getLog(HomeInterfaceSubTask.class, (String)"matchesGenerationRules");
        if (!InterfaceTagsHandler.isRemoteEjb(this.getCurrentClass())) {
            log.debug((Object)("Reject file " + clazz.getQualifiedName() + " because of different view-type"));
            return false;
        }
        XTag interfaceTag = this.getCurrentClass().getDoc().getTag("ejb:home", false);
        if (interfaceTag == null) {
            return true;
        }
        String generate = interfaceTag.getAttributeValue("generate");
        if (generate != null && generate.indexOf("remote") == -1) {
            log.debug((Object)("Skip home interface for " + clazz.getQualifiedName() + " because of generate=" + generate + " flag."));
            return false;
        }
        return true;
    }

    protected void engineStarted() throws XDocletException {
        System.out.println(Translator.getString(XDocletModulesEjbMessages.class, (String)"GENERATING_HOME_FOR", (String[])new String[]{this.getCurrentClass().getQualifiedName()}));
    }
}

