/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.core.client;

import java.io.IOException;
import java.util.Map;
import java.util.Properties;
import javax.xml.soap.MimeHeaders;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPMessage;
import org.jboss.remoting.marshal.Marshaller;
import org.jboss.remoting.marshal.UnMarshaller;
import org.jboss.ws.core.MessageAbstraction;
import org.jboss.ws.core.client.HTTPRemotingConnection;
import org.jboss.ws.core.soap.SOAPMessageMarshaller;
import org.jboss.ws.core.soap.SOAPMessageUnMarshallerHTTP;
import org.jboss.ws.extensions.xop.XOPContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SOAPProtocolConnectionHTTP
extends HTTPRemotingConnection {
    @Override
    public UnMarshaller getUnmarshaller() {
        return new SOAPMessageUnMarshallerHTTP();
    }

    @Override
    public Marshaller getMarshaller() {
        return new SOAPMessageMarshaller();
    }

    @Override
    public MessageAbstraction invoke(MessageAbstraction reqMessage, Object endpoint, boolean oneway) throws IOException {
        try {
            XOPContext.eagerlyCreateAttachments();
            SOAPMessage soapMessage = (SOAPMessage)reqMessage;
            if (reqMessage != null && soapMessage.saveRequired()) {
                soapMessage.saveChanges();
            }
            return super.invoke(reqMessage, endpoint, oneway);
        }
        catch (SOAPException ex) {
            IOException io = new IOException();
            io.initCause(ex);
            throw io;
        }
    }

    @Override
    protected void populateHeaders(MessageAbstraction reqMessage, Map<String, Object> metadata) {
        super.populateHeaders(reqMessage, metadata);
        Properties props = (Properties)metadata.get("HEADER");
        MimeHeaders mimeHeaders = reqMessage.getMimeHeaders();
        String[] action = mimeHeaders.getHeader("SOAPAction");
        if (action != null && action.length > 0) {
            String soapAction = action[0];
            if (!soapAction.startsWith("\"") || !soapAction.endsWith("\"")) {
                soapAction = "\"" + soapAction + "\"";
            }
            props.put("SOAPAction", soapAction);
        } else {
            props.put("SOAPAction", "\"\"");
        }
    }
}

