/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3.interceptor;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import javax.interceptor.InvocationContext;
import org.jboss.aop.joinpoint.Invocation;
import org.jboss.ejb3.EJBContainerInvocation;
import org.jboss.ejb3.interceptor.ClientInterceptorUtil;
import org.jboss.ejb3.interceptor.InterceptorInfo;

public class InvocationContextImpl
implements InvocationContext {
    private int currentInterceptor;
    private int currentMethod;
    private int currentBeanMethod;
    InterceptorInfo[] interceptorInfos;
    Object[] instances;
    private Method[] beanAroundInvokes;
    private Map metadata;
    EJBContainerInvocation wrapped;

    public InvocationContextImpl(EJBContainerInvocation inv, InterceptorInfo[] interceptorInfos, Object[] instances, Method[] beanAroundInvokes) {
        this.wrapped = inv;
        this.beanAroundInvokes = beanAroundInvokes;
        if (interceptorInfos.length != instances.length) {
            throw new RuntimeException("interceptorInfos and instances have different length");
        }
        this.interceptorInfos = interceptorInfos;
        this.instances = instances;
    }

    public Object getTarget() {
        return this.wrapped.getTargetObject();
    }

    public Method getMethod() {
        return this.wrapped.getMethod();
    }

    public Object[] getParameters() {
        return this.wrapped.getArguments();
    }

    public void setParameters(Object[] params) {
        this.wrapped.setArguments(params);
    }

    public Map getContextData() {
        if (this.metadata == null) {
            this.metadata = ClientInterceptorUtil.getClientMetadataMap((Invocation)this.wrapped);
            if (this.metadata == null) {
                this.metadata = new HashMap();
            }
        }
        return this.metadata;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object proceed() throws Exception {
        if (this.currentInterceptor < this.interceptorInfos.length) {
            int oldMethod;
            int oldInterceptor;
            block16: {
                oldInterceptor = this.currentInterceptor;
                oldMethod = this.currentMethod;
                try {
                    Object object;
                    int curr = this.currentInterceptor++;
                    int currMethod = this.currentMethod++;
                    InterceptorInfo info = this.interceptorInfos[curr];
                    if (currMethod == info.getAroundInvokes().length) {
                        curr = this.currentInterceptor;
                        this.currentMethod = 0;
                        currMethod = this.currentMethod++;
                        InterceptorInfo interceptorInfo = info = curr < this.interceptorInfos.length ? this.interceptorInfos[curr] : null;
                    }
                    if (info == null) break block16;
                    try {
                        object = info.getAroundInvokes()[currMethod].invoke(this.instances[curr], this);
                    }
                    catch (InvocationTargetException e) {
                        if (e.getTargetException() instanceof Exception) {
                            throw (Exception)e.getCause();
                        }
                        throw new RuntimeException(e.getCause());
                    }
                    Object var8_12 = null;
                    this.currentInterceptor = oldInterceptor;
                    this.currentMethod = oldMethod;
                    return object;
                }
                catch (Throwable throwable) {
                    Object var8_14 = null;
                    this.currentInterceptor = oldInterceptor;
                    this.currentMethod = oldMethod;
                    throw throwable;
                }
            }
            Object var8_13 = null;
            this.currentInterceptor = oldInterceptor;
            this.currentMethod = oldMethod;
        }
        if (this.beanAroundInvokes != null && this.currentBeanMethod < this.beanAroundInvokes.length) {
            try {
                try {
                    int curr = this.currentBeanMethod++;
                    Object object = this.beanAroundInvokes[curr].invoke(this.getTarget(), this);
                    Object var10_16 = null;
                    --this.currentBeanMethod;
                    return object;
                }
                catch (InvocationTargetException e) {
                    if (e.getTargetException() instanceof Exception) {
                        throw (Exception)e.getCause();
                    }
                    throw new RuntimeException(e.getCause());
                }
            }
            catch (Throwable throwable) {
                Object var10_17 = null;
                --this.currentBeanMethod;
                throw throwable;
            }
        }
        try {
            return this.wrapped.invokeNext();
        }
        catch (Exception e) {
            throw e;
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
    }
}

