/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.jtests.jms.framework;

import java.util.Properties;
import javax.jms.Topic;
import javax.jms.TopicConnection;
import javax.jms.TopicConnectionFactory;
import javax.jms.TopicPublisher;
import javax.jms.TopicSession;
import javax.jms.TopicSubscriber;
import javax.naming.InitialContext;
import org.jboss.util.NestedRuntimeException;
import org.objectweb.jtests.jms.admin.Admin;
import org.objectweb.jtests.jms.admin.AdminFactory;
import org.objectweb.jtests.jms.framework.JMSTestCase;

public class PubSubTestCase
extends JMSTestCase {
    private Admin admin;
    private InitialContext ctx;
    private static final String TCF_NAME = "testTCF";
    private static final String TOPIC_NAME = "testJoramTopic";
    protected Topic publisherTopic;
    protected TopicPublisher publisher;
    protected TopicConnectionFactory publisherTCF;
    protected TopicConnection publisherConnection;
    protected TopicSession publisherSession;
    protected Topic subscriberTopic;
    protected TopicSubscriber subscriber;
    protected TopicConnectionFactory subscriberTCF;
    protected TopicConnection subscriberConnection;
    protected TopicSession subscriberSession;

    protected void setUp() {
        try {
            Properties props = this.getProviderProperties();
            this.admin = AdminFactory.getAdmin(props);
            this.admin.createTopicConnectionFactory(TCF_NAME);
            this.admin.createTopic(TOPIC_NAME);
            this.ctx = this.admin.createInitialContext();
            this.publisherTCF = (TopicConnectionFactory)this.ctx.lookup(TCF_NAME);
            this.publisherTopic = (Topic)this.ctx.lookup(TOPIC_NAME);
            this.publisherConnection = this.publisherTCF.createTopicConnection();
            this.publisherConnection.setClientID("publisherConnection");
            this.publisherSession = this.publisherConnection.createTopicSession(false, 1);
            this.publisher = this.publisherSession.createPublisher(this.publisherTopic);
            this.subscriberTCF = (TopicConnectionFactory)this.ctx.lookup(TCF_NAME);
            this.subscriberTopic = (Topic)this.ctx.lookup(TOPIC_NAME);
            this.subscriberConnection = this.subscriberTCF.createTopicConnection();
            this.subscriberConnection.setClientID("subscriberConnection");
            this.subscriberSession = this.subscriberConnection.createTopicSession(false, 1);
            this.subscriber = this.subscriberSession.createSubscriber(this.subscriberTopic);
            this.publisherConnection.start();
            this.subscriberConnection.start();
        }
        catch (Exception e) {
            throw new NestedRuntimeException((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void tearDown() {
        try {
            try {
                this.publisherConnection.close();
                this.subscriberConnection.close();
                this.admin.deleteTopicConnectionFactory(TCF_NAME);
                this.admin.deleteTopic(TOPIC_NAME);
            }
            catch (Exception exception) {
                Object var3_2 = null;
                this.publisherTopic = null;
                this.publisher = null;
                this.publisherTCF = null;
                this.publisherSession = null;
                this.publisherConnection = null;
                this.subscriberTopic = null;
                this.subscriber = null;
                this.subscriberTCF = null;
                this.subscriberSession = null;
                this.subscriberConnection = null;
            }
            Object var3_1 = null;
            this.publisherTopic = null;
            this.publisher = null;
            this.publisherTCF = null;
            this.publisherSession = null;
            this.publisherConnection = null;
            this.subscriberTopic = null;
            this.subscriber = null;
            this.subscriberTCF = null;
            this.subscriberSession = null;
            this.subscriberConnection = null;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.publisherTopic = null;
            this.publisher = null;
            this.publisherTCF = null;
            this.publisherSession = null;
            this.publisherConnection = null;
            this.subscriberTopic = null;
            this.subscriber = null;
            this.subscriberTCF = null;
            this.subscriberSession = null;
            this.subscriberConnection = null;
            throw throwable;
        }
    }

    public PubSubTestCase(String name) {
        super(name);
    }
}

