/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.jms.management.impl;

import java.util.List;
import javax.management.MBeanInfo;
import javax.management.NotCompliantMBeanException;
import javax.management.StandardMBean;
import org.hornetq.api.core.Pair;
import org.hornetq.api.core.TransportConfiguration;
import org.hornetq.api.core.management.Parameter;
import org.hornetq.api.jms.management.ConnectionFactoryControl;
import org.hornetq.core.management.impl.MBeanInfoHelper;
import org.hornetq.jms.client.HornetQConnectionFactory;
import org.hornetq.jms.server.JMSServerManager;

public class JMSConnectionFactoryControlImpl
extends StandardMBean
implements ConnectionFactoryControl {
    private final HornetQConnectionFactory cf;
    private final String name;
    private final JMSServerManager jmsManager;

    public JMSConnectionFactoryControlImpl(HornetQConnectionFactory cf, JMSServerManager jmsManager, String name) throws NotCompliantMBeanException {
        super(ConnectionFactoryControl.class);
        this.cf = cf;
        this.name = name;
        this.jmsManager = jmsManager;
    }

    @Override
    public String[] getJNDIBindings() {
        return this.jmsManager.getJNDIOnConnectionFactory(this.name);
    }

    @Override
    public String getClientID() {
        return this.cf.getClientID();
    }

    @Override
    public long getClientFailureCheckPeriod() {
        return this.cf.getClientFailureCheckPeriod();
    }

    @Override
    public long getDiscoveryRefreshTimeout() {
        return this.cf.getDiscoveryRefreshTimeout();
    }

    @Override
    public String getConnectionLoadBalancingPolicyClassName() {
        return this.cf.getConnectionLoadBalancingPolicyClassName();
    }

    @Override
    public void setDiscoveryRefreshTimeout(long discoveryRefreshTimeout) {
        this.cf.setDiscoveryRefreshTimeout(discoveryRefreshTimeout);
    }

    @Override
    public long getDiscoveryInitialWaitTimeout() {
        return this.cf.getDiscoveryInitialWaitTimeout();
    }

    @Override
    public void setDiscoveryInitialWaitTimeout(long discoveryInitialWaitTimeout) {
        this.cf.setDiscoveryInitialWaitTimeout(discoveryInitialWaitTimeout);
    }

    @Override
    public void setClientID(String clientID) {
        this.cf.setClientID(clientID);
    }

    @Override
    public void setDupsOKBatchSize(int dupsOKBatchSize) {
        this.cf.setDupsOKBatchSize(dupsOKBatchSize);
    }

    @Override
    public void setTransactionBatchSize(int transactionBatchSize) {
        this.cf.setTransactionBatchSize(transactionBatchSize);
    }

    @Override
    public void setClientFailureCheckPeriod(long clientFailureCheckPeriod) {
        this.cf.setClientFailureCheckPeriod(clientFailureCheckPeriod);
    }

    @Override
    public void setConnectionTTL(long connectionTTL) {
        this.cf.setConnectionTTL(connectionTTL);
    }

    @Override
    public void setCallTimeout(long callTimeout) {
        this.cf.setCallTimeout(callTimeout);
    }

    @Override
    public void setConsumerWindowSize(int consumerWindowSize) {
        this.cf.setConsumerWindowSize(consumerWindowSize);
    }

    @Override
    public void setConsumerMaxRate(int consumerMaxRate) {
        this.cf.setConsumerMaxRate(consumerMaxRate);
    }

    @Override
    public void setConfirmationWindowSize(int confirmationWindowSize) {
        this.cf.setConfirmationWindowSize(confirmationWindowSize);
    }

    @Override
    public void setProducerMaxRate(int producerMaxRate) {
        this.cf.setProducerMaxRate(producerMaxRate);
    }

    @Override
    public int getProducerWindowSize() {
        return this.cf.getProducerWindowSize();
    }

    @Override
    public void setProducerWindowSize(int producerWindowSize) {
        this.cf.setProducerWindowSize(producerWindowSize);
    }

    @Override
    public void setCacheLargeMessagesClient(boolean cacheLargeMessagesClient) {
        this.cf.setCacheLargeMessagesClient(cacheLargeMessagesClient);
    }

    @Override
    public boolean isCacheLargeMessagesClient() {
        return this.cf.isCacheLargeMessagesClient();
    }

    @Override
    public void setMinLargeMessageSize(int minLargeMessageSize) {
        this.cf.setMinLargeMessageSize(minLargeMessageSize);
    }

    @Override
    public void setBlockOnNonDurableSend(boolean blockOnNonDurableSend) {
        this.cf.setBlockOnNonDurableSend(blockOnNonDurableSend);
    }

    @Override
    public void setBlockOnAcknowledge(boolean blockOnAcknowledge) {
        this.cf.setBlockOnAcknowledge(blockOnAcknowledge);
    }

    @Override
    public void setBlockOnDurableSend(boolean blockOnDurableSend) {
        this.cf.setBlockOnDurableSend(blockOnDurableSend);
    }

    @Override
    public void setAutoGroup(boolean autoGroup) {
        this.cf.setAutoGroup(autoGroup);
    }

    @Override
    public void setPreAcknowledge(boolean preAcknowledge) {
        this.cf.setPreAcknowledge(preAcknowledge);
    }

    @Override
    public void setMaxRetryInterval(long retryInterval) {
        this.cf.setMaxRetryInterval(retryInterval);
    }

    @Override
    public void setRetryIntervalMultiplier(double retryIntervalMultiplier) {
        this.cf.setRetryIntervalMultiplier(retryIntervalMultiplier);
    }

    @Override
    public void setReconnectAttempts(int reconnectAttempts) {
        this.cf.setReconnectAttempts(reconnectAttempts);
    }

    @Override
    public void setFailoverOnInitialConnection(boolean failover) {
        this.cf.setFailoverOnInitialConnection(failover);
    }

    @Override
    public void setFailoverOnServerShutdown(boolean failoverOnServerShutdown) {
        this.cf.setFailoverOnServerShutdown(failoverOnServerShutdown);
    }

    @Override
    public boolean isUseGlobalPools() {
        return this.cf.isUseGlobalPools();
    }

    @Override
    public void setScheduledThreadPoolMaxSize(int scheduledThreadPoolMaxSize) {
        this.cf.setScheduledThreadPoolMaxSize(scheduledThreadPoolMaxSize);
    }

    @Override
    public int getThreadPoolMaxSize() {
        return this.cf.getThreadPoolMaxSize();
    }

    @Override
    public void setThreadPoolMaxSize(int threadPoolMaxSize) {
        this.cf.setThreadPoolMaxSize(threadPoolMaxSize);
    }

    @Override
    public int getInitialMessagePacketSize() {
        return this.cf.getInitialMessagePacketSize();
    }

    @Override
    public void setGroupID(String groupID) {
        this.cf.setGroupID(groupID);
    }

    @Override
    public String getGroupID() {
        return this.cf.getGroupID();
    }

    @Override
    public void setInitialMessagePacketSize(int size) {
        this.cf.setInitialMessagePacketSize(size);
    }

    @Override
    public void setUseGlobalPools(boolean useGlobalPools) {
        this.cf.setUseGlobalPools(useGlobalPools);
    }

    @Override
    public int getScheduledThreadPoolMaxSize() {
        return this.cf.getScheduledThreadPoolMaxSize();
    }

    @Override
    public void setRetryInterval(long retryInterval) {
        this.cf.setRetryInterval(retryInterval);
    }

    @Override
    public long getMaxRetryInterval() {
        return this.cf.getMaxRetryInterval();
    }

    @Override
    public void setConnectionLoadBalancingPolicyClassName(String connectionLoadBalancingPolicyClassName) {
        this.cf.setConnectionLoadBalancingPolicyClassName(connectionLoadBalancingPolicyClassName);
    }

    @Override
    public List<Pair<TransportConfiguration, TransportConfiguration>> getStaticConnectors() {
        return this.cf.getStaticConnectors();
    }

    @Override
    public void setStaticConnectors(List<Pair<TransportConfiguration, TransportConfiguration>> staticConnectors) {
        this.cf.setStaticConnectors(staticConnectors);
    }

    @Override
    public String getLocalBindAddress() {
        return this.cf.getLocalBindAddress();
    }

    @Override
    public void setLocalBindAddress(String localBindAddress) {
        this.cf.setLocalBindAddress(localBindAddress);
    }

    @Override
    public String getDiscoveryAddress() {
        return this.cf.getDiscoveryAddress();
    }

    @Override
    public void setDiscoveryAddress(String discoveryAddress) {
        this.cf.setDiscoveryAddress(discoveryAddress);
    }

    @Override
    public int getDiscoveryPort() {
        return this.cf.getDiscoveryPort();
    }

    @Override
    public void setDiscoveryPort(int discoveryPort) {
        this.cf.setDiscoveryPort(discoveryPort);
    }

    @Override
    public void addJNDI(@Parameter(name="jndiBinding", desc="the name of the binding for JNDI") String jndi) throws Exception {
        this.jmsManager.addConnectionFactoryToJNDI(this.name, jndi);
    }

    @Override
    public long getCallTimeout() {
        return this.cf.getCallTimeout();
    }

    @Override
    public int getConsumerMaxRate() {
        return this.cf.getConsumerMaxRate();
    }

    @Override
    public int getConsumerWindowSize() {
        return this.cf.getConsumerWindowSize();
    }

    @Override
    public int getProducerMaxRate() {
        return this.cf.getProducerMaxRate();
    }

    @Override
    public int getConfirmationWindowSize() {
        return this.cf.getConfirmationWindowSize();
    }

    @Override
    public int getDupsOKBatchSize() {
        return this.cf.getDupsOKBatchSize();
    }

    @Override
    public boolean isBlockOnAcknowledge() {
        return this.cf.isBlockOnAcknowledge();
    }

    @Override
    public boolean isBlockOnNonDurableSend() {
        return this.cf.isBlockOnNonDurableSend();
    }

    @Override
    public boolean isBlockOnDurableSend() {
        return this.cf.isBlockOnDurableSend();
    }

    @Override
    public boolean isPreAcknowledge() {
        return this.cf.isPreAcknowledge();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public long getConnectionTTL() {
        return this.cf.getConnectionTTL();
    }

    @Override
    public int getReconnectAttempts() {
        return this.cf.getReconnectAttempts();
    }

    @Override
    public boolean isFailoverOnInitialConnection() {
        return this.cf.isFailoverOnInitialConnection();
    }

    @Override
    public boolean isFailoverOnServerShutdown() {
        return this.cf.isFailoverOnServerShutdown();
    }

    @Override
    public int getMinLargeMessageSize() {
        return this.cf.getMinLargeMessageSize();
    }

    @Override
    public long getRetryInterval() {
        return this.cf.getRetryInterval();
    }

    @Override
    public double getRetryIntervalMultiplier() {
        return this.cf.getRetryIntervalMultiplier();
    }

    @Override
    public int getTransactionBatchSize() {
        return this.cf.getTransactionBatchSize();
    }

    @Override
    public boolean isAutoGroup() {
        return this.cf.isAutoGroup();
    }

    @Override
    public MBeanInfo getMBeanInfo() {
        MBeanInfo info = super.getMBeanInfo();
        return new MBeanInfo(info.getClassName(), info.getDescription(), info.getAttributes(), info.getConstructors(), MBeanInfoHelper.getMBeanOperationsInfo(ConnectionFactoryControl.class), info.getNotifications());
    }
}

