/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.core.paging.impl;

import java.text.DecimalFormat;
import java.util.HashSet;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.hornetq.api.core.SimpleString;
import org.hornetq.core.journal.SequentialFile;
import org.hornetq.core.journal.SequentialFileFactory;
import org.hornetq.core.logging.Logger;
import org.hornetq.core.paging.Page;
import org.hornetq.core.paging.PageTransactionInfo;
import org.hornetq.core.paging.PagedMessage;
import org.hornetq.core.paging.PagingManager;
import org.hornetq.core.paging.PagingStoreFactory;
import org.hornetq.core.paging.impl.PageImpl;
import org.hornetq.core.paging.impl.PagedMessageImpl;
import org.hornetq.core.paging.impl.TestSupportPageStore;
import org.hornetq.core.persistence.StorageManager;
import org.hornetq.core.postoffice.DuplicateIDCache;
import org.hornetq.core.postoffice.PostOffice;
import org.hornetq.core.server.LargeServerMessage;
import org.hornetq.core.server.ServerMessage;
import org.hornetq.core.settings.impl.AddressFullMessagePolicy;
import org.hornetq.core.settings.impl.AddressSettings;
import org.hornetq.core.transaction.Transaction;
import org.hornetq.core.transaction.impl.TransactionImpl;

public class PagingStoreImpl
implements TestSupportPageStore {
    private static final Logger log = Logger.getLogger(PagingStoreImpl.class);
    private final SimpleString address;
    private final StorageManager storageManager;
    private final PostOffice postOffice;
    private final DecimalFormat format = new DecimalFormat("000000000");
    private final AtomicInteger currentPageSize = new AtomicInteger(0);
    private final SimpleString storeName;
    private volatile SequentialFileFactory fileFactory;
    private final PagingStoreFactory storeFactory;
    private final long maxSize;
    private final long pageSize;
    private final AddressFullMessagePolicy addressFullMessagePolicy;
    private boolean printedDropMessagesWarning;
    private final PagingManager pagingManager;
    private final Executor executor;
    private final AtomicLong sizeInBytes = new AtomicLong();
    private final AtomicBoolean depaging = new AtomicBoolean(false);
    private volatile int numberOfPages;
    private volatile int firstPageId;
    private volatile int currentPageId;
    private volatile Page currentPage;
    private final ReentrantLock writeLock = new ReentrantLock();
    private final DuplicateIDCache duplicateCache;
    private final ReadWriteLock currentPageLock = new ReentrantReadWriteLock();
    private volatile boolean running = false;
    protected final boolean syncNonTransactional;
    private static final boolean isTrace = log.isTraceEnabled();
    private Queue<OurRunnable> onMemoryFreedRunnables = new ConcurrentLinkedQueue<OurRunnable>();
    private final Runnable memoryFreedRunnablesExecutor = new MemoryFreedRunnablesExecutor();

    private static void trace(String message) {
        log.trace(message);
    }

    public PagingStoreImpl(SimpleString address, PagingManager pagingManager, StorageManager storageManager, PostOffice postOffice, SequentialFileFactory fileFactory, PagingStoreFactory storeFactory, SimpleString storeName, AddressSettings addressSettings, Executor executor, boolean syncNonTransactional) {
        if (pagingManager == null) {
            throw new IllegalStateException("Paging Manager can't be null");
        }
        this.address = address;
        this.storageManager = storageManager;
        this.postOffice = postOffice;
        this.storeName = storeName;
        this.maxSize = addressSettings.getMaxSizeBytes();
        this.pageSize = addressSettings.getPageSizeBytes();
        this.addressFullMessagePolicy = addressSettings.getAddressFullMessagePolicy();
        if (this.addressFullMessagePolicy == AddressFullMessagePolicy.PAGE && this.maxSize != -1L && this.pageSize >= this.maxSize) {
            throw new IllegalStateException("pageSize for address " + address + " >= maxSize. Normally pageSize should" + " be significantly smaller than maxSize, ms: " + this.maxSize + " ps " + this.pageSize);
        }
        this.executor = executor;
        this.pagingManager = pagingManager;
        this.fileFactory = fileFactory;
        this.storeFactory = storeFactory;
        this.syncNonTransactional = syncNonTransactional;
        this.duplicateCache = postOffice == null ? null : postOffice.getDuplicateIDCache(storeName);
    }

    @Override
    public SimpleString getAddress() {
        return this.address;
    }

    @Override
    public long getAddressSize() {
        return this.sizeInBytes.get();
    }

    @Override
    public long getMaxSize() {
        return this.maxSize;
    }

    @Override
    public AddressFullMessagePolicy getAddressFullMessagePolicy() {
        return this.addressFullMessagePolicy;
    }

    @Override
    public long getPageSizeBytes() {
        return this.pageSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isPaging() {
        this.currentPageLock.readLock().lock();
        try {
            if (this.addressFullMessagePolicy == AddressFullMessagePolicy.BLOCK) {
                boolean bl = false;
                return bl;
            }
            if (this.addressFullMessagePolicy == AddressFullMessagePolicy.DROP) {
                boolean bl = this.isFull();
                return bl;
            }
            boolean bl = this.currentPage != null;
            return bl;
        }
        finally {
            this.currentPageLock.readLock().unlock();
        }
    }

    @Override
    public int getNumberOfPages() {
        return this.numberOfPages;
    }

    @Override
    public SimpleString getStoreName() {
        return this.storeName;
    }

    @Override
    public boolean page(ServerMessage message, long transactionID) throws Exception {
        return this.page(message, transactionID, false);
    }

    @Override
    public boolean page(ServerMessage message) throws Exception {
        return this.page(message, -1L, this.syncNonTransactional && message.isDurable());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void sync() throws Exception {
        this.currentPageLock.readLock().lock();
        try {
            if (this.currentPage != null) {
                this.currentPage.sync();
            }
        }
        finally {
            this.currentPageLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean startDepaging() {
        boolean bl;
        if (!this.running) {
            return false;
        }
        this.currentPageLock.readLock().lock();
        try {
            if (this.currentPage == null) {
                boolean bl2 = false;
                this.currentPageLock.readLock().unlock();
                return bl2;
            }
        }
        catch (Throwable throwable) {
            this.currentPageLock.readLock().unlock();
            throw throwable;
        }
        {
            PagingStoreImpl pagingStoreImpl = this;
            synchronized (pagingStoreImpl) {
                if (!this.depaging.get()) {
                    this.depaging.set(true);
                    DepageRunnable depageAction = new DepageRunnable(this.executor);
                    this.executor.execute(depageAction);
                    boolean bl3 = true;
                    // MONITOREXIT @DISABLED, blocks:[1, 5, 7] lbl20 : MonitorExitStatement: MONITOREXIT : var1_2
                    this.currentPageLock.readLock().unlock();
                    return bl3;
                }
                bl = false;
            }
        }
        this.currentPageLock.readLock().unlock();
        return bl;
    }

    @Override
    public synchronized boolean isStarted() {
        return this.running;
    }

    @Override
    public synchronized void stop() throws Exception {
        if (this.running) {
            this.running = false;
            final CountDownLatch latch = new CountDownLatch(1);
            this.executor.execute(new Runnable(){

                @Override
                public void run() {
                    latch.countDown();
                }
            });
            if (!latch.await(60L, TimeUnit.SECONDS)) {
                log.warn("Timed out on waiting PagingStore " + this.address + " to shutdown");
            }
            if (this.currentPage != null) {
                this.currentPage.close();
                this.currentPage = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void start() throws Exception {
        this.writeLock.lock();
        try {
            if (this.running) {
                return;
            }
            this.currentPageLock.writeLock().lock();
            try {
                this.running = true;
                this.firstPageId = Integer.MAX_VALUE;
                if (this.fileFactory != null) {
                    this.currentPageId = 0;
                    this.currentPage = null;
                    List<String> files = this.fileFactory.listFiles("page");
                    this.numberOfPages = files.size();
                    for (String fileName : files) {
                        int fileId = PagingStoreImpl.getPageIdFromFileName(fileName);
                        if (fileId > this.currentPageId) {
                            this.currentPageId = fileId;
                        }
                        if (fileId >= this.firstPageId) continue;
                        this.firstPageId = fileId;
                    }
                    if (this.numberOfPages != 0) {
                        this.startPaging();
                    }
                }
            }
            finally {
                this.currentPageLock.writeLock().unlock();
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean startPaging() {
        if (!this.running) {
            return false;
        }
        this.currentPageLock.readLock().lock();
        try {
            if (this.currentPage != null) {
                boolean bl = false;
                return bl;
            }
        }
        finally {
            this.currentPageLock.readLock().unlock();
        }
        this.writeLock.lock();
        try {
            if (this.currentPage == null) {
                try {
                    this.openNewPage();
                }
                catch (Exception e) {
                    log.warn("IO Error, impossible to start paging", e);
                    boolean bl = false;
                    this.writeLock.unlock();
                    return bl;
                }
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    @Override
    public Page getCurrentPage() {
        return this.currentPage;
    }

    @Override
    public Page createPage(int page) throws Exception {
        String fileName = this.createFileName(page);
        if (this.fileFactory == null) {
            this.fileFactory = this.storeFactory.newFileFactory(this.getStoreName());
        }
        SequentialFile file = this.fileFactory.createSequentialFile(fileName, 1000);
        file.open();
        file.position(0L);
        file.close();
        return new PageImpl(this.storeName, this.storageManager, this.fileFactory, file, page);
    }

    @Override
    public void forceAnotherPage() throws Exception {
        this.openNewPage();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Page depage() throws Exception {
        this.writeLock.lock();
        this.currentPageLock.writeLock().lock();
        try {
            Page returnPage;
            if (!this.running) {
                Page page = null;
                return page;
            }
            if (this.numberOfPages == 0) {
                Page page = null;
                return page;
            }
            --this.numberOfPages;
            if (this.currentPageId == this.firstPageId) {
                this.firstPageId = Integer.MAX_VALUE;
                if (this.currentPage == null) {
                    throw new IllegalStateException("CurrentPage is null");
                }
                Page returnPage2 = this.currentPage;
                returnPage2.close();
                this.currentPage = null;
                if (returnPage2.getNumberOfMessages() == 0) {
                    returnPage2.open();
                    returnPage2.delete();
                    Page page = null;
                    return page;
                }
                this.openNewPage();
                Page page = returnPage2;
                return page;
            }
            Page page = returnPage = this.createPage(this.firstPageId++);
            return page;
        }
        finally {
            this.currentPageLock.writeLock().unlock();
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean readPage() throws Exception {
        Page page = this.depage();
        if (page == null) {
            return false;
        }
        page.open();
        List<PagedMessage> messages = null;
        try {
            messages = page.read();
        }
        finally {
            try {
                page.close();
            }
            catch (Throwable throwable) {}
        }
        if (this.onDepage(page.getPageId(), this.storeName, messages)) {
            if (page.delete() && this.duplicateCache != null) {
                this.duplicateCache.deleteFromCache(this.generateDuplicateID(page.getPageId()));
            }
            return true;
        }
        return false;
    }

    @Override
    public void executeRunnableWhenMemoryAvailable(Runnable runnable) {
        if (this.addressFullMessagePolicy == AddressFullMessagePolicy.BLOCK && this.maxSize != -1L && this.sizeInBytes.get() > this.maxSize) {
            OurRunnable ourRunnable = new OurRunnable(runnable);
            this.onMemoryFreedRunnables.add(ourRunnable);
            if (this.sizeInBytes.get() <= this.maxSize) {
                ourRunnable.run();
            }
            return;
        }
        runnable.run();
    }

    @Override
    public void addSize(int size) {
        if (this.addressFullMessagePolicy == AddressFullMessagePolicy.BLOCK) {
            long newSize;
            if (this.maxSize != -1L && (newSize = this.sizeInBytes.addAndGet(size)) <= this.maxSize && !this.onMemoryFreedRunnables.isEmpty()) {
                this.executor.execute(this.memoryFreedRunnablesExecutor);
            }
            return;
        }
        if (this.addressFullMessagePolicy == AddressFullMessagePolicy.PAGE) {
            long addressSize = this.sizeInBytes.addAndGet(size);
            if (size > 0) {
                if (this.maxSize > 0L && addressSize > this.maxSize && this.startPaging() && isTrace) {
                    PagingStoreImpl.trace("Starting paging on " + this.getStoreName() + ", size = " + addressSize + ", maxSize=" + this.maxSize);
                }
            } else if (this.maxSize > 0L && this.currentPage != null && addressSize <= this.maxSize - this.pageSize && !this.depaging.get() && this.startDepaging() && isTrace) {
                PagingStoreImpl.trace("Starting depaging Thread, size = " + addressSize);
            }
            return;
        }
        if (this.addressFullMessagePolicy == AddressFullMessagePolicy.DROP) {
            this.sizeInBytes.addAndGet(size);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean page(ServerMessage message, long transactionID, boolean sync) throws Exception {
        if (!this.running) {
            throw new IllegalStateException("PagingStore(" + this.getStoreName() + ") not initialized");
        }
        boolean full = this.isFull();
        if (this.addressFullMessagePolicy == AddressFullMessagePolicy.DROP) {
            if (full) {
                if (!this.printedDropMessagesWarning) {
                    this.printedDropMessagesWarning = true;
                    log.warn("Messages are being dropped on address " + this.getStoreName());
                }
                return true;
            }
            return false;
        }
        if (this.addressFullMessagePolicy == AddressFullMessagePolicy.BLOCK) {
            return false;
        }
        this.currentPageLock.readLock().lock();
        try {
            if (this.currentPage == null) {
                boolean bl = false;
                return bl;
            }
        }
        finally {
            this.currentPageLock.readLock().unlock();
        }
        this.writeLock.lock();
        try {
            PagedMessageImpl pagedMessage;
            int bytesToWrite;
            if (this.currentPage == null) {
                boolean bl = false;
                return bl;
            }
            if (!message.isDurable()) {
                message.bodyChanged();
            }
            if ((long)this.currentPageSize.addAndGet(bytesToWrite = (pagedMessage = transactionID != -1L ? new PagedMessageImpl(message, transactionID) : new PagedMessageImpl(message)).getEncodeSize() + 6) > this.pageSize && this.currentPage.getNumberOfMessages() > 0) {
                this.currentPageLock.writeLock().lock();
                try {
                    this.openNewPage();
                    this.currentPageSize.addAndGet(bytesToWrite);
                }
                finally {
                    this.currentPageLock.writeLock().unlock();
                }
            }
            this.currentPageLock.readLock().lock();
            try {
                this.currentPage.write(pagedMessage);
                if (sync) {
                    this.currentPage.sync();
                }
                boolean bl = true;
                this.currentPageLock.readLock().unlock();
                return bl;
            }
            catch (Throwable throwable) {
                this.currentPageLock.readLock().unlock();
                throw throwable;
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    private boolean onDepage(int pageId, SimpleString address, List<PagedMessage> pagedMessages) throws Exception {
        if (isTrace) {
            PagingStoreImpl.trace("Depaging....");
        }
        if (pagedMessages.size() == 0) {
            return true;
        }
        byte[] duplicateIdForPage = this.generateDuplicateID(pageId);
        TransactionImpl depageTransaction = new TransactionImpl(this.storageManager);
        if (this.duplicateCache != null) {
            if (this.duplicateCache.contains(duplicateIdForPage)) {
                log.warn("Page " + pageId + " had been processed already but the file wasn't removed as a crash happened. Ignoring this page");
                return true;
            }
            this.duplicateCache.addToCache(duplicateIdForPage, depageTransaction);
        }
        depageTransaction.putProperty(3, true);
        HashSet<PageTransactionInfo> pageTransactionsToUpdate = new HashSet<PageTransactionInfo>();
        for (PagedMessage pagedMessage : pagedMessages) {
            LargeServerMessage largeMsg;
            ServerMessage message = pagedMessage.getMessage(this.storageManager);
            if (message.isLargeMessage() && !(largeMsg = (LargeServerMessage)message).isFileExists()) {
                log.warn("File for large message " + largeMsg.getMessageID() + " doesn't exist, so ignoring depage for this large message");
                continue;
            }
            long transactionIdDuringPaging = pagedMessage.getTransactionID();
            PageTransactionInfo pageUserTransaction = null;
            if (transactionIdDuringPaging >= 0L) {
                pageUserTransaction = this.pagingManager.getTransaction(transactionIdDuringPaging);
                if (pageUserTransaction == null) {
                    log.warn("Transaction " + pagedMessage.getTransactionID() + " used during paging not found");
                    continue;
                }
                while (this.running && !pageUserTransaction.waitCompletion(500)) {
                    if (!isTrace) continue;
                    PagingStoreImpl.trace("Waiting pageTransaction to complete");
                }
                if (!this.running) break;
                if (!pageUserTransaction.isCommit()) {
                    if (!isTrace) continue;
                    PagingStoreImpl.trace("Rollback was called after prepare, ignoring message " + message);
                    continue;
                }
            }
            this.postOffice.route(message, depageTransaction, false);
            if (depageTransaction.getState() == Transaction.State.ROLLBACK_ONLY) break;
            if (pageUserTransaction == null || !message.isDurable()) continue;
            pageUserTransaction.decrement();
            pageTransactionsToUpdate.add(pageUserTransaction);
        }
        if (!this.running) {
            depageTransaction.rollback();
            return false;
        }
        for (PageTransactionInfo pageWithTransaction : pageTransactionsToUpdate) {
            depageTransaction.setContainsPersistent();
            if (pageWithTransaction.getNumberOfMessages() == 0) {
                this.storageManager.deletePageTransactional(depageTransaction.getID(), pageWithTransaction.getRecordID());
                this.pagingManager.removeTransaction(pageWithTransaction.getTransactionID());
                continue;
            }
            this.storageManager.storePageTransaction(depageTransaction.getID(), pageWithTransaction);
        }
        depageTransaction.commit();
        this.storageManager.waitOnOperations();
        if (isTrace) {
            PagingStoreImpl.trace("Depage committed, running = " + this.running);
        }
        return true;
    }

    private byte[] generateDuplicateID(int pageId) {
        byte[] duplicateIdForPage = new SimpleString("page-" + pageId).getData();
        return duplicateIdForPage;
    }

    private boolean isAddressFull(long nextPageSize) {
        return this.maxSize > 0L && this.getAddressSize() + nextPageSize > this.maxSize;
    }

    private synchronized boolean clearDepage() {
        boolean addressFull = this.isAddressFull(this.getPageSizeBytes());
        if (isTrace) {
            PagingStoreImpl.trace("Clear Depage on Address = " + this.getStoreName() + " addressSize = " + this.getAddressSize() + " addressMax " + this.maxSize + " isPaging = " + this.isPaging() + " addressFull = " + addressFull);
        }
        if (addressFull || !this.isPaging()) {
            this.depaging.set(false);
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void openNewPage() throws Exception {
        this.currentPageLock.writeLock().lock();
        try {
            ++this.numberOfPages;
            ++this.currentPageId;
            if (this.currentPageId < this.firstPageId) {
                this.firstPageId = this.currentPageId;
            }
            if (this.currentPage != null) {
                this.currentPage.close();
            }
            this.currentPage = this.createPage(this.currentPageId);
            this.currentPageSize.set(0);
            this.currentPage.open();
        }
        finally {
            this.currentPageLock.writeLock().unlock();
        }
    }

    private String createFileName(int pageID) {
        return this.format.format(pageID) + ".page";
    }

    private static int getPageIdFromFileName(String fileName) {
        return Integer.parseInt(fileName.substring(0, fileName.indexOf(46)));
    }

    private boolean isFull() {
        return this.maxSize > 0L && this.getAddressSize() > this.maxSize;
    }

    private class DepageRunnable
    implements Runnable {
        private final Executor followingExecutor;

        public DepageRunnable(Executor followingExecutor) {
            this.followingExecutor = followingExecutor;
        }

        @Override
        public void run() {
            try {
                if (PagingStoreImpl.this.running) {
                    if (!PagingStoreImpl.this.isAddressFull(PagingStoreImpl.this.getPageSizeBytes())) {
                        PagingStoreImpl.this.readPage();
                    }
                    if (PagingStoreImpl.this.running && !PagingStoreImpl.this.clearDepage()) {
                        this.followingExecutor.execute(this);
                    }
                }
            }
            catch (Throwable e) {
                log.error(e, e);
            }
        }
    }

    class OurRunnable
    implements Runnable {
        boolean ran;
        final Runnable runnable;

        OurRunnable(Runnable runnable) {
            this.runnable = runnable;
        }

        @Override
        public synchronized void run() {
            if (!this.ran) {
                this.runnable.run();
                this.ran = true;
            }
        }
    }

    private class MemoryFreedRunnablesExecutor
    implements Runnable {
        private MemoryFreedRunnablesExecutor() {
        }

        @Override
        public void run() {
            Runnable runnable;
            while ((runnable = (Runnable)PagingStoreImpl.this.onMemoryFreedRunnables.poll()) != null) {
                runnable.run();
            }
        }
    }
}

