/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.virtual.plugins.registry;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.List;
import java.util.Set;
import org.jboss.logging.Logger;
import org.jboss.virtual.VFSUtils;
import org.jboss.virtual.VirtualFile;
import org.jboss.virtual.spi.TempInfo;
import org.jboss.virtual.spi.VFSContext;
import org.jboss.virtual.spi.VFSContextConstraints;
import org.jboss.virtual.spi.VirtualFileHandler;
import org.jboss.virtual.spi.cache.VFSCache;
import org.jboss.virtual.spi.cache.VFSCacheFactory;
import org.jboss.virtual.spi.registry.VFSRegistry;

public class DefaultVFSRegistry
extends VFSRegistry {
    private static boolean forceCanonical = AccessController.doPrivileged(new CheckForceCanonical());

    protected VFSCache getCache() {
        return VFSCacheFactory.getInstance();
    }

    protected boolean isCacheable(VFSContext context) {
        Set<VFSContextConstraints> constraints = context.getConstraints();
        return constraints != null && constraints.contains((Object)VFSContextConstraints.CACHEABLE);
    }

    public void addContext(VFSContext context) {
        if (this.isCacheable(context)) {
            this.getCache().putContext(context);
        }
    }

    public void removeContext(VFSContext context) {
        if (this.isCacheable(context)) {
            this.getCache().removeContext(context);
        }
    }

    protected static URI canonicalize(URI uri) throws IOException {
        if (forceCanonical) {
            String path = new File(uri.getPath()).getCanonicalPath();
            try {
                return new URI(uri.getScheme(), uri.getHost(), path, uri.getQuery(), uri.getFragment());
            }
            catch (URISyntaxException e) {
                IOException ioe = new IOException();
                ioe.initCause(e);
                throw ioe;
            }
        }
        return uri;
    }

    public VFSContext getContext(URI uri) throws IOException {
        String relativePath;
        if (uri == null) {
            throw new IllegalArgumentException("Null uri");
        }
        uri = DefaultVFSRegistry.canonicalize(uri);
        VFSContext context = this.getCache().findContext(uri);
        if (context != null && (relativePath = VFSUtils.getRelativePath(context, uri)).length() == 0) {
            return context;
        }
        return null;
    }

    public VirtualFile getFile(URI uri) throws IOException {
        if (uri == null) {
            throw new IllegalArgumentException("Null uri");
        }
        uri = DefaultVFSRegistry.canonicalize(uri);
        VFSContext context = this.getCache().findContext(uri);
        if (context != null) {
            String relativePath = VFSUtils.getRelativePath(context, uri);
            TempInfo ti = context.getFurthestParentTemp(relativePath);
            if (ti != null) {
                String path = ti.getPath();
                String subpath = relativePath.substring(path.length());
                VirtualFileHandler child = this.findHandler(ti.getHandler(), subpath, true);
                if (child != null) {
                    return child.getVirtualFile();
                }
            }
            VirtualFileHandler root = context.getRoot();
            VirtualFileHandler child = this.findHandler(root, relativePath, false);
            return child.getVirtualFile();
        }
        return null;
    }

    protected VirtualFileHandler findHandler(VirtualFileHandler root, String path, boolean allowNotFound) throws IOException {
        VirtualFileHandler child = root.getChild(path);
        if (child == null && !allowNotFound) {
            List<VirtualFileHandler> children = root.getChildren(true);
            throw new IOException("Child not found " + path + " for " + root + ", available children: " + children);
        }
        return child;
    }

    static {
        if (forceCanonical) {
            Logger.getLogger(DefaultVFSRegistry.class).info((Object)"VFS force canonical lookup is enabled.");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class CheckForceCanonical
    implements PrivilegedAction<Boolean> {
        private CheckForceCanonical() {
        }

        @Override
        public Boolean run() {
            String forceString = System.getProperty("jboss.vfs.forceCanonical", "false");
            return Boolean.valueOf(forceString);
        }
    }
}

