/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.utils;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.hornetq.core.logging.Logger;
import org.hornetq.core.version.Version;
import org.hornetq.core.version.impl.VersionImpl;

public class VersionLoader {
    private static final Logger log = Logger.getLogger(VersionLoader.class);
    public static final String PROP_FILE_NAME = "hornetq-version.properties";
    private static Version version;

    public static Version getVersion() {
        if (version == null) {
            throw new RuntimeException("hornetq-version.properties is not available");
        }
        return version;
    }

    private static Version load() {
        Properties versionProps = new Properties();
        InputStream in = VersionImpl.class.getClassLoader().getResourceAsStream(PROP_FILE_NAME);
        try {
            if (in == null) {
                throw new RuntimeException("hornetq-version.properties is not available");
            }
            try {
                versionProps.load(in);
                String versionName = versionProps.getProperty("hornetq.version.versionName");
                int majorVersion = Integer.valueOf(versionProps.getProperty("hornetq.version.majorVersion"));
                int minorVersion = Integer.valueOf(versionProps.getProperty("hornetq.version.minorVersion"));
                int microVersion = Integer.valueOf(versionProps.getProperty("hornetq.version.microVersion"));
                int incrementingVersion = Integer.valueOf(versionProps.getProperty("hornetq.version.incrementingVersion"));
                String versionSuffix = versionProps.getProperty("hornetq.version.versionSuffix");
                String nettyVersion = versionProps.getProperty("hornetq.netty.version");
                VersionImpl versionImpl = new VersionImpl(versionName, majorVersion, minorVersion, microVersion, incrementingVersion, versionSuffix, nettyVersion);
                return versionImpl;
            }
            catch (IOException e) {
                throw new RuntimeException("unable to load hornetq-version.properties", e);
            }
        }
        finally {
            try {
                in.close();
            }
            catch (Throwable ignored) {}
        }
    }

    static {
        try {
            version = VersionLoader.load();
        }
        catch (Throwable e) {
            version = null;
            log.error(e.getMessage(), e);
        }
    }
}

