/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juddi.handler;

import org.apache.juddi.datatype.RegistryObject;
import org.apache.juddi.datatype.publisher.Publisher;
import org.apache.juddi.handler.AbstractHandler;
import org.apache.juddi.handler.HandlerMaker;
import org.apache.juddi.util.Config;
import org.apache.juddi.util.xml.XMLUtils;
import org.w3c.dom.Element;

public class PublisherHandler
extends AbstractHandler {
    public static final String TAG_NAME = "publisher";

    protected PublisherHandler(HandlerMaker maker) {
    }

    public RegistryObject unmarshal(Element element) {
        String attrValue;
        Publisher obj = new Publisher();
        obj.setPublisherID(element.getAttribute("publisherID"));
        obj.setName(element.getAttribute("publisherName"));
        String admin = element.getAttribute("admin");
        if (admin != null && admin.length() > 0) {
            obj.setAdminValue(admin);
        } else {
            obj.setAdmin(false);
        }
        String enabled = element.getAttribute("enabled");
        if (enabled != null && enabled.length() > 0) {
            obj.setEnabledValue(enabled);
        } else {
            obj.setAdmin(false);
        }
        String emailAddress = element.getAttribute("emailAddress");
        if (emailAddress != null && emailAddress.length() > 0) {
            obj.setEmailAddress(emailAddress);
        }
        try {
            attrValue = element.getAttribute("maxBusinesses");
            if (attrValue != null && attrValue.length() > 0) {
                obj.setMaxBusinesses(Integer.parseInt(attrValue));
            } else {
                obj.setMaxBusinesses(Config.getMaxBusinessesPerPublisher());
            }
        }
        catch (Exception ex) {
            obj.setMaxBusinesses(Config.getMaxBusinessesPerPublisher());
        }
        try {
            attrValue = element.getAttribute("maxServicesPerBusiness");
            if (attrValue != null && attrValue.length() > 0) {
                obj.setMaxServicesPerBusiness(Integer.parseInt(attrValue));
            } else {
                obj.setMaxServicesPerBusiness(Config.getMaxServicesPerBusiness());
            }
        }
        catch (Exception ex) {
            obj.setMaxServicesPerBusiness(Config.getMaxServicesPerBusiness());
        }
        try {
            attrValue = element.getAttribute("maxBindingsPerService");
            if (attrValue != null && attrValue.length() > 0) {
                obj.setMaxBindingsPerService(Integer.parseInt(attrValue));
            } else {
                obj.setMaxBindingsPerService(Config.getMaxBindingsPerService());
            }
        }
        catch (Exception ex) {
            obj.setMaxBindingsPerService(Config.getMaxBindingsPerService());
        }
        try {
            attrValue = element.getAttribute("maxTModels");
            if (attrValue != null && attrValue.length() > 0) {
                obj.setMaxTModels(Integer.parseInt(attrValue));
            } else {
                obj.setMaxTModels(Config.getMaxTModelsPerPublisher());
            }
        }
        catch (Exception ex) {
            obj.setMaxTModels(Config.getMaxTModelsPerPublisher());
        }
        return obj;
    }

    public void marshal(RegistryObject object, Element parent) {
        Publisher publisher = (Publisher)object;
        String generic = this.getGeneric(null);
        String namespace = this.getUDDINamespace(generic);
        Element element = parent.getOwnerDocument().createElementNS(namespace, TAG_NAME);
        String publisherID = publisher.getPublisherID();
        if (publisherID != null && publisherID.length() > 0) {
            element.setAttribute("publisherID", publisherID);
        } else {
            element.setAttribute("publisherID", "");
        }
        String publisherName = publisher.getName();
        if (publisherName != null && publisherName.length() > 0) {
            element.setAttribute("publisherName", publisherName);
        } else {
            element.setAttribute("publisherName", "");
        }
        element.setAttribute("admin", String.valueOf(publisher.isAdmin()));
        element.setAttribute("enabled", String.valueOf(publisher.isEnabled()));
        String emailAddress = publisher.getEmailAddress();
        if (emailAddress != null && emailAddress.length() > 0) {
            element.setAttribute("emailAddress", emailAddress);
        }
        element.setAttribute("maxBusinessEntities", String.valueOf(publisher.getMaxBusinesses()));
        element.setAttribute("maxServicesPerBusiness", String.valueOf(publisher.getMaxServicesPerBusiness()));
        element.setAttribute("maxBindingsPerService", String.valueOf(publisher.getMaxBindingsPerService()));
        element.setAttribute("maxTModels", String.valueOf(publisher.getMaxTModels()));
        parent.appendChild(element);
    }

    public static void main(String[] args) throws Exception {
        HandlerMaker maker = HandlerMaker.getInstance();
        AbstractHandler handler = maker.lookup(TAG_NAME);
        Element parent = XMLUtils.newRootElement();
        Element child = null;
        Publisher publisher = new Publisher();
        publisher.setPublisherID("bcrosby");
        publisher.setName("Bing Crosby");
        publisher.setEmailAddress("bcrosby@juddi.org");
        publisher.setAdmin(true);
        publisher.setEnabled(true);
        publisher.setMaxBusinesses(5);
        publisher.setMaxServicesPerBusiness(10);
        publisher.setMaxBindingsPerService(25);
        publisher.setMaxTModels(10);
        System.out.println();
        RegistryObject regObject = publisher;
        handler.marshal(regObject, parent);
        child = (Element)parent.getFirstChild();
        parent.removeChild(child);
        XMLUtils.writeXML(child, System.out);
        System.out.println();
        regObject = handler.unmarshal(child);
        handler.marshal(regObject, parent);
        child = (Element)parent.getFirstChild();
        parent.removeChild(child);
        XMLUtils.writeXML(child, System.out);
    }
}

