/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.artifact.ant;

import hidden.org.codehaus.plexus.util.ReaderFactory;
import hidden.org.codehaus.plexus.util.introspection.ReflectionValueExtractor;
import hidden.org.codehaus.plexus.util.xml.XmlStreamReader;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.Hashtable;
import java.util.List;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.ant.AbstractArtifactWithRepositoryTask;
import org.apache.maven.artifact.ant.AttachedArtifact;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.metadata.ArtifactMetadataSource;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.resolver.ArtifactNotFoundException;
import org.apache.maven.artifact.resolver.ArtifactResolutionException;
import org.apache.maven.artifact.resolver.ArtifactResolver;
import org.apache.maven.model.Build;
import org.apache.maven.model.CiManagement;
import org.apache.maven.model.DependencyManagement;
import org.apache.maven.model.DistributionManagement;
import org.apache.maven.model.IssueManagement;
import org.apache.maven.model.Model;
import org.apache.maven.model.Organization;
import org.apache.maven.model.Parent;
import org.apache.maven.model.Reporting;
import org.apache.maven.model.Scm;
import org.apache.maven.model.io.xpp3.MavenXpp3Reader;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectBuilder;
import org.apache.maven.project.MavenProjectHelper;
import org.apache.maven.project.ProjectBuildingException;
import org.apache.maven.project.artifact.MavenMetadataSource;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.PropertyHelper;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;

public class Pom
extends AbstractArtifactWithRepositoryTask {
    private String refid;
    private String antId;
    private MavenProject mavenProject;
    private File file;
    private final POMPropertyHelper helper = new POMPropertyHelper();

    public String getRefid() {
        return this.refid;
    }

    public void setRefid(String refid) {
        this.refid = refid;
    }

    public void setId(String id) {
        this.antId = id;
    }

    protected Pom getInstance() {
        Pom instance = this;
        if (this.refid != null && (instance = (Pom)((Object)this.getProject().getReference(this.refid))) == null) {
            throw new BuildException("Invalid reference: '" + this.refid + "'");
        }
        return instance;
    }

    public void setMavenProject(MavenProject mavenProject) {
        this.getInstance().mavenProject = mavenProject;
    }

    public File getFile() {
        return this.getInstance().file;
    }

    public void setFile(File file) {
        this.file = file;
    }

    public Artifact getArtifact() {
        return this.getMavenProject().getArtifact();
    }

    public void attach(AttachedArtifact attached) {
        MavenProjectHelper helper = (MavenProjectHelper)this.lookup(MavenProjectHelper.ROLE);
        MavenProject project = this.getMavenProject();
        if (attached.getClassifier() != null) {
            helper.attachArtifact(project, attached.getType(), attached.getClassifier(), attached.getFile());
        } else {
            helper.attachArtifact(project, attached.getType(), attached.getFile());
        }
    }

    public List getAttachedArtifacts() {
        return this.getMavenProject().getAttachedArtifacts();
    }

    void initialise(MavenProjectBuilder builder, ArtifactRepository localRepository) {
        if (this.mavenProject != null) {
            this.log("POM is already initialized for: " + this.mavenProject.getId(), 4);
            return;
        }
        if (this.file != null) {
            this.checkParentPom();
            try {
                this.mavenProject = builder.build(this.file, localRepository, this.getProfileManager());
            }
            catch (ProjectBuildingException e) {
                throw new BuildException("Unable to initialize POM " + this.file.getName() + ": " + e.getMessage(), (Throwable)e);
            }
        } else if (this.refid != null) {
            this.getInstance().initialise(builder, localRepository);
        }
    }

    private void checkParentPom() {
        Model model = null;
        try {
            XmlStreamReader reader = ReaderFactory.newXmlReader(this.file);
            model = new MavenXpp3Reader().read(reader);
        }
        catch (IOException e) {
            throw new BuildException("IO error while reading pom: " + e.getMessage(), (Throwable)e);
        }
        catch (XmlPullParserException e) {
            throw new BuildException("Error parsing pom: " + e.getMessage(), (Throwable)e);
        }
        if (model.getParent() != null && model.getParent().getRelativePath() != null) {
            Parent parent = model.getParent();
            String groupId = parent.getGroupId();
            String artifactId = parent.getArtifactId();
            String version = parent.getVersion();
            ArtifactFactory factory = (ArtifactFactory)this.lookup(ArtifactFactory.ROLE);
            Artifact parentArtifact = factory.createParentArtifact(groupId, artifactId, version);
            try {
                MavenMetadataSource metadataSource = (MavenMetadataSource)this.lookup(ArtifactMetadataSource.ROLE);
                ArtifactResolver resolver = (ArtifactResolver)this.lookup(ArtifactResolver.ROLE);
                List remoteRepositories = this.createRemoteArtifactRepositories(model.getRepositories());
                resolver.resolveTransitively(Collections.singleton(parentArtifact), this.createDummyArtifact(), this.createLocalArtifactRepository(), remoteRepositories, (ArtifactMetadataSource)metadataSource, null);
            }
            catch (ArtifactResolutionException e) {
                this.log("Error downloading parent pom " + parent.getId() + ": " + e.getMessage(), 1);
            }
            catch (ArtifactNotFoundException e) {
                throw new BuildException("Unable to download parent pom " + parent.getId() + " in remote repository: " + e.getMessage(), (Throwable)e);
            }
        }
    }

    protected MavenProject getMavenProject() {
        return this.getInstance().mavenProject;
    }

    public String getArtifactId() {
        return this.getMavenProject().getArtifactId();
    }

    public Build getBuild() {
        return this.getMavenProject().getBuild();
    }

    public CiManagement getCiManagement() {
        return this.getMavenProject().getCiManagement();
    }

    public List getContributors() {
        return this.getMavenProject().getContributors();
    }

    public List getDependencies() {
        return this.getMavenProject().getDependencies();
    }

    public DependencyManagement getDependencyManagement() {
        return this.getMavenProject().getDependencyManagement();
    }

    public String getDescription() {
        return this.getMavenProject().getDescription();
    }

    public List getDevelopers() {
        return this.getMavenProject().getDevelopers();
    }

    public DistributionManagement getDistributionManagement() {
        return this.getMavenProject().getDistributionManagement();
    }

    public String getGroupId() {
        return this.getMavenProject().getGroupId();
    }

    public String getInceptionYear() {
        return this.getMavenProject().getInceptionYear();
    }

    public IssueManagement getIssueManagement() {
        return this.getMavenProject().getIssueManagement();
    }

    public List getLicenses() {
        return this.getMavenProject().getLicenses();
    }

    public List getMailingLists() {
        return this.getMavenProject().getMailingLists();
    }

    public String getModelVersion() {
        return this.getMavenProject().getModelVersion();
    }

    public List getModules() {
        return this.getMavenProject().getModules();
    }

    public String getName() {
        return this.getMavenProject().getName();
    }

    public Organization getOrganization() {
        return this.getMavenProject().getOrganization();
    }

    public String getPackaging() {
        return this.getMavenProject().getPackaging();
    }

    public List getPluginRepositories() {
        return this.getMavenProject().getPluginRepositories();
    }

    public Reporting getReporting() {
        return this.getMavenProject().getReporting();
    }

    public List getRepositories() {
        return this.getMavenProject().getRepositories();
    }

    public Scm getScm() {
        return this.getMavenProject().getScm();
    }

    public String getUrl() {
        return this.getMavenProject().getUrl();
    }

    public String getVersion() {
        return this.getMavenProject().getVersion();
    }

    public String getId() {
        return this.getMavenProject().getId();
    }

    protected void doExecute() {
        ArtifactRepository localRepo = this.createLocalArtifactRepository();
        MavenProjectBuilder projectBuilder = (MavenProjectBuilder)this.lookup(MavenProjectBuilder.ROLE);
        this.initialise(projectBuilder, localRepo);
        Project project = this.getProject();
        project.addReference(this.antId, (Object)this);
        PropertyHelper phelper = PropertyHelper.getPropertyHelper((Project)project);
        this.helper.setNext(phelper.getNext());
        this.helper.setProject(project);
        phelper.setNext((PropertyHelper)this.helper);
    }

    private class POMPropertyHelper
    extends PropertyHelper {
        private POMPropertyHelper() {
        }

        public Object getPropertyHook(String ns, String name, boolean user) {
            String prefix = Pom.this.antId + ".";
            if (!name.startsWith(prefix)) {
                return super.getPropertyHook(ns, name, user);
            }
            try {
                String expression = name.substring(prefix.length());
                return this.getPOMValue("project." + expression);
            }
            catch (Exception ex) {
                ex.printStackTrace();
                return null;
            }
        }

        private Object getPOMValue(String expression) {
            Object value = null;
            try {
                if (expression.startsWith("project.properties.")) {
                    expression = expression.substring(19);
                    value = ((Hashtable)Pom.this.getMavenProject().getProperties()).get(expression);
                } else {
                    value = ReflectionValueExtractor.evaluate(expression, Pom.this.getMavenProject());
                }
            }
            catch (Exception e) {
                throw new BuildException("Error extracting expression from POM", (Throwable)e);
            }
            return value;
        }
    }
}

