/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aop.microcontainer.aspects.jndi;

import java.io.Serializable;
import java.util.Properties;
import javax.naming.Context;
import javax.naming.InitialContext;
import org.jboss.aop.advice.Interceptor;
import org.jboss.aop.joinpoint.Invocation;
import org.jboss.aop.joinpoint.MethodInvocation;
import org.jboss.aop.microcontainer.aspects.jndi.JndiBinding;
import org.jboss.kernel.spi.dependency.KernelControllerContext;
import org.jboss.logging.Logger;
import org.jboss.util.naming.Util;

public class JndiIntroduction
implements Interceptor,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final Logger log = Logger.getLogger(JndiIntroduction.class);
    private Properties env;

    public String getName() {
        return this.getClass().getName();
    }

    public Properties getEnv() {
        return this.env;
    }

    public void setEnv(Properties env) {
        this.env = env;
    }

    public Object invoke(Invocation invocation) throws Throwable {
        if (!(invocation instanceof MethodInvocation)) {
            throw new IllegalStateException("Invocation is not an instance of MethodInvocation: " + invocation);
        }
        MethodInvocation mi = (MethodInvocation)invocation;
        KernelControllerContext context = (KernelControllerContext)mi.getArguments()[0];
        boolean trace = log.isTraceEnabled();
        JndiBinding bindingInfo = (JndiBinding)invocation.resolveClassAnnotation(JndiBinding.class);
        if (trace) {
            log.trace((Object)("Checking method: " + mi.getMethod() + ", bindingInfo: " + bindingInfo));
        }
        if ("setKernelControllerContext".equals(mi.getMethod().getName()) && bindingInfo != null) {
            String[] aliases;
            InitialContext ctx = new InitialContext(this.env);
            Object target = context.getTarget();
            Util.bind((Context)ctx, (String)bindingInfo.name(), (Object)target);
            if (trace) {
                log.trace((Object)("Bound to: " + bindingInfo.name()));
            }
            if ((aliases = bindingInfo.aliases()) != null) {
                for (String name : aliases) {
                    Util.bind((Context)ctx, (String)name, (Object)target);
                    if (!trace) continue;
                    log.trace((Object)("Bound to alias: " + bindingInfo.name()));
                }
            }
        } else if (bindingInfo != null) {
            String[] aliases;
            InitialContext ctx = new InitialContext(this.env);
            Util.unbind((Context)ctx, (String)bindingInfo.name());
            if (trace) {
                log.trace((Object)("Unbound: " + bindingInfo.name()));
            }
            if ((aliases = bindingInfo.aliases()) != null) {
                for (String name : aliases) {
                    Util.unbind((Context)ctx, (String)name);
                    if (!trace) continue;
                    log.trace((Object)("Unbound alias: " + bindingInfo.name()));
                }
            }
        } else if (trace) {
            log.trace((Object)"Ignoring null binding info");
        }
        return null;
    }
}

