/*
 * JBoss, Home of Professional Open Source.
 * Copyright 2006, Red Hat Middleware LLC, and individual contributors
 * as indicated by the @author tags. See the copyright.txt file in the
 * distribution for a full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */

package org.jboss.web.tomcat.service.session.distributedcache.impl.jbc;

import org.jboss.cache.Fqn;
import org.jboss.cache.notifications.annotation.NodeActivated;
import org.jboss.cache.notifications.event.NodeActivatedEvent;
import org.jboss.web.tomcat.service.session.distributedcache.spi.LocalDistributableSessionManager;

/**
 * Listener for JBoss Cache activation events.  Triggers updates of
 * the passivation counter.
 * 
 * @author <a href="brian.stansberry@jboss.com">Brian Stansberry</a>
 * @version $Revision: 64678 $
 */
@org.jboss.cache.notifications.annotation.CacheListener
public class PassivationListener extends CacheListenerBase
{

   PassivationListener(LocalDistributableSessionManager manager, String contextHostPath)
   {      
      super(manager, contextHostPath);
   }
   
   // NOTE: Don't track passivation from here -- we know in JBossCacheManager
   // when we trigger a passivation. Avoid spurious listener callbacks to
   // webapps that aren't interested.
   
//   @NodePassivated
//   public void nodePassivated(NodePassivatedEvent event)
//   {
//      Fqn fqn = event.getFqn();
//      if (isFqnForOurWebapp(fqn, isBuddyFqn(fqn)))
//      {
//         manager_.sessionPassivated();
//      }
//   }
   
   // We do want activation callbacks, as JBossCacheManager can't readily
   // track whether a cache read is going to result in an activation
   
   @NodeActivated
   public void nodeActivated(NodeActivatedEvent event)
   {
      @SuppressWarnings("unchecked")
      Fqn<String> fqn = event.getFqn();
      int baseIdx = getJSessionIndex(fqn, isBuddyFqn(fqn));
      if (isFqnSessionRootSized(fqn, baseIdx) 
            && isFqnForOurWebapp(fqn, baseIdx))
      {
         manager_.sessionActivated();
      }
      
   }

}
