/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.type;

import java.io.Serializable;
import java.lang.reflect.Method;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Map;
import java.util.Properties;
import org.dom4j.Element;
import org.dom4j.Node;
import org.hibernate.EntityMode;
import org.hibernate.FetchMode;
import org.hibernate.HibernateException;
import org.hibernate.MappingException;
import org.hibernate.engine.CascadeStyle;
import org.hibernate.engine.Mapping;
import org.hibernate.engine.SessionFactoryImplementor;
import org.hibernate.engine.SessionImplementor;
import org.hibernate.type.AbstractComponentType;
import org.hibernate.type.AbstractType;
import org.hibernate.type.Type;
import org.hibernate.type.TypeFactory;
import org.hibernate.usertype.CompositeUserType;

public class CompositeCustomType
extends AbstractType
implements AbstractComponentType {
    private final CompositeUserType userType;
    private final String name;

    public CompositeCustomType(Class userTypeClass, Properties parameters) throws MappingException {
        this.name = userTypeClass.getName();
        if (!CompositeUserType.class.isAssignableFrom(userTypeClass)) {
            throw new MappingException("Custom type does not implement CompositeUserType: " + userTypeClass.getName());
        }
        try {
            this.userType = (CompositeUserType)userTypeClass.newInstance();
        }
        catch (InstantiationException ie) {
            throw new MappingException("Cannot instantiate custom type: " + userTypeClass.getName());
        }
        catch (IllegalAccessException iae) {
            throw new MappingException("IllegalAccessException trying to instantiate custom type: " + userTypeClass.getName());
        }
        TypeFactory.injectParameters(this.userType, parameters);
    }

    @Override
    public boolean isMethodOf(Method method) {
        return false;
    }

    @Override
    public Type[] getSubtypes() {
        return this.userType.getPropertyTypes();
    }

    @Override
    public String[] getPropertyNames() {
        return this.userType.getPropertyNames();
    }

    @Override
    public Object[] getPropertyValues(Object component, SessionImplementor session) throws HibernateException {
        return this.getPropertyValues(component, session.getEntityMode());
    }

    @Override
    public Object[] getPropertyValues(Object component, EntityMode entityMode) throws HibernateException {
        int len = this.getSubtypes().length;
        Object[] result = new Object[len];
        for (int i = 0; i < len; ++i) {
            result[i] = this.getPropertyValue(component, i);
        }
        return result;
    }

    @Override
    public void setPropertyValues(Object component, Object[] values, EntityMode entityMode) throws HibernateException {
        for (int i = 0; i < values.length; ++i) {
            this.userType.setPropertyValue(component, i, values[i]);
        }
    }

    @Override
    public Object getPropertyValue(Object component, int i, SessionImplementor session) throws HibernateException {
        return this.getPropertyValue(component, i);
    }

    public Object getPropertyValue(Object component, int i) throws HibernateException {
        return this.userType.getPropertyValue(component, i);
    }

    @Override
    public CascadeStyle getCascadeStyle(int i) {
        return CascadeStyle.NONE;
    }

    @Override
    public FetchMode getFetchMode(int i) {
        return FetchMode.DEFAULT;
    }

    @Override
    public boolean isComponentType() {
        return true;
    }

    @Override
    public Object deepCopy(Object value, EntityMode entityMode, SessionFactoryImplementor factory) throws HibernateException {
        return this.userType.deepCopy(value);
    }

    @Override
    public Object assemble(Serializable cached, SessionImplementor session, Object owner) throws HibernateException {
        return this.userType.assemble(cached, session, owner);
    }

    @Override
    public Serializable disassemble(Object value, SessionImplementor session, Object owner) throws HibernateException {
        return this.userType.disassemble(value, session);
    }

    @Override
    public Object replace(Object original, Object target, SessionImplementor session, Object owner, Map copyCache) throws HibernateException {
        return this.userType.replace(original, target, session, owner);
    }

    @Override
    public boolean isEqual(Object x, Object y, EntityMode entityMode) throws HibernateException {
        return this.userType.equals(x, y);
    }

    @Override
    public int getHashCode(Object x, EntityMode entityMode) {
        return this.userType.hashCode(x);
    }

    @Override
    public int getColumnSpan(Mapping mapping) throws MappingException {
        Type[] types = this.userType.getPropertyTypes();
        int n = 0;
        for (int i = 0; i < types.length; ++i) {
            n += types[i].getColumnSpan(mapping);
        }
        return n;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Class getReturnedClass() {
        return this.userType.returnedClass();
    }

    @Override
    public boolean isMutable() {
        return this.userType.isMutable();
    }

    @Override
    public Object nullSafeGet(ResultSet rs, String columnName, SessionImplementor session, Object owner) throws HibernateException, SQLException {
        return this.userType.nullSafeGet(rs, new String[]{columnName}, session, owner);
    }

    @Override
    public Object nullSafeGet(ResultSet rs, String[] names, SessionImplementor session, Object owner) throws HibernateException, SQLException {
        return this.userType.nullSafeGet(rs, names, session, owner);
    }

    @Override
    public void nullSafeSet(PreparedStatement st, Object value, int index, SessionImplementor session) throws HibernateException, SQLException {
        this.userType.nullSafeSet(st, value, index, session);
    }

    @Override
    public void nullSafeSet(PreparedStatement st, Object value, int index, boolean[] settable, SessionImplementor session) throws HibernateException, SQLException {
        this.userType.nullSafeSet(st, value, index, session);
    }

    @Override
    public int[] sqlTypes(Mapping mapping) throws MappingException {
        Type[] types = this.userType.getPropertyTypes();
        int[] result = new int[this.getColumnSpan(mapping)];
        int n = 0;
        for (int i = 0; i < types.length; ++i) {
            int[] sqlTypes = types[i].sqlTypes(mapping);
            for (int k = 0; k < sqlTypes.length; ++k) {
                result[n++] = sqlTypes[k];
            }
        }
        return result;
    }

    @Override
    public String toLoggableString(Object value, SessionFactoryImplementor factory) throws HibernateException {
        return value == null ? "null" : value.toString();
    }

    @Override
    public boolean[] getPropertyNullability() {
        return null;
    }

    @Override
    public Object fromXMLNode(Node xml, Mapping factory) throws HibernateException {
        return xml;
    }

    @Override
    public void setToXMLNode(Node node, Object value, SessionFactoryImplementor factory) throws HibernateException {
        CompositeCustomType.replaceNode(node, (Element)value);
    }

    @Override
    public boolean[] toColumnNullness(Object value, Mapping mapping) {
        boolean[] result = new boolean[this.getColumnSpan(mapping)];
        if (value == null) {
            return result;
        }
        Object[] values = this.getPropertyValues(value, EntityMode.POJO);
        int loc = 0;
        Type[] propertyTypes = this.getSubtypes();
        for (int i = 0; i < propertyTypes.length; ++i) {
            boolean[] propertyNullness = propertyTypes[i].toColumnNullness(values[i], mapping);
            System.arraycopy(propertyNullness, 0, result, loc, propertyNullness.length);
            loc += propertyNullness.length;
        }
        return result;
    }

    @Override
    public boolean isDirty(Object old, Object current, boolean[] checkable, SessionImplementor session) throws HibernateException {
        return this.isDirty(old, current, session);
    }

    @Override
    public boolean isEmbedded() {
        return false;
    }
}

