/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.core.protocol.core.impl.wireformat;

import org.hornetq.api.core.HornetQBuffer;
import org.hornetq.core.protocol.core.impl.PacketImpl;

public abstract class SessionContinuationMessage
extends PacketImpl {
    public static final int SESSION_CONTINUATION_BASE_SIZE = 18;
    protected byte[] body;
    protected boolean continues;

    public SessionContinuationMessage(byte type, byte[] body, boolean continues) {
        super(type);
        this.body = body;
        this.continues = continues;
    }

    public SessionContinuationMessage(byte type) {
        super(type);
    }

    public byte[] getBody() {
        return this.body;
    }

    public boolean isContinues() {
        return this.continues;
    }

    public void encodeRest(HornetQBuffer buffer) {
        buffer.writeInt(this.body.length);
        buffer.writeBytes(this.body);
        buffer.writeBoolean(this.continues);
    }

    public void decodeRest(HornetQBuffer buffer) {
        int size = buffer.readInt();
        this.body = new byte[size];
        buffer.readBytes(this.body);
        this.continues = buffer.readBoolean();
    }
}

