/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.metadata.validation.validator.ejb.jboss;

import javax.jws.WebService;
import org.jboss.logging.Logger;
import org.jboss.metadata.ejb.jboss.JBossSessionBeanMetaData;
import org.jboss.metadata.ejb.spec.BusinessLocalsMetaData;
import org.jboss.metadata.ejb.spec.BusinessRemotesMetaData;
import org.jboss.metadata.validation.ValidationException;
import org.jboss.metadata.validation.validator.ejb.JBossEjb3SessionBeanValidatorBase;

public class AtleastOneBusinessInterfaceValidator
extends JBossEjb3SessionBeanValidatorBase {
    private static Logger logger = Logger.getLogger(AtleastOneBusinessInterfaceValidator.class);
    private ClassLoader classLoader;

    public AtleastOneBusinessInterfaceValidator(ClassLoader cl) {
        this.classLoader = cl;
    }

    protected void validate(JBossSessionBeanMetaData smd) throws ValidationException {
        BusinessLocalsMetaData businessLocals = smd.getBusinessLocals();
        if (businessLocals != null && !businessLocals.isEmpty()) {
            return;
        }
        BusinessRemotesMetaData businessRemotes = smd.getBusinessRemotes();
        if (businessRemotes != null && !businessRemotes.isEmpty()) {
            return;
        }
        String localHome = smd.getLocalHome();
        if (localHome != null) {
            return;
        }
        String remoteHome = smd.getHome();
        if (remoteHome != null) {
            return;
        }
        try {
            String endpointInterface;
            Class<?> beanClass = this.classLoader.loadClass(smd.getEjbClass());
            WebService webService = beanClass.getAnnotation(WebService.class);
            if (webService != null && (endpointInterface = webService.endpointInterface()) != null) {
                if (logger.isTraceEnabled()) {
                    logger.trace((Object)("Bean class " + smd.getEjbClass() + " has an endpoint interface " + endpointInterface + " - marking the bean as valid"));
                }
                return;
            }
        }
        catch (ClassNotFoundException cnfe) {
            throw new RuntimeException("Error loading bean class " + smd.getEjbClass());
        }
        throw new ValidationException("JBMETA-201 - Bean class " + smd.getEjbClass() + " for bean " + smd.getEjbName() + " has no local, webservice endpointInterface or remote interfaces defined and does not implement at least one business interface");
    }
}

