/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.utils;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.hornetq.api.core.HornetQBuffer;
import org.hornetq.api.core.PropertyConversionException;
import org.hornetq.api.core.SimpleString;
import org.hornetq.core.logging.Logger;

public class TypedProperties {
    private static final Logger log = Logger.getLogger(TypedProperties.class);
    private static final SimpleString HQ_PROPNAME = new SimpleString("_HQ_");
    private Map<SimpleString, PropertyValue> properties;
    private volatile int size;
    private boolean internalProperties;

    public TypedProperties() {
    }

    public int getMemoryOffset() {
        return this.properties == null ? 0 : this.size + 8 * this.properties.size();
    }

    public TypedProperties(TypedProperties other) {
        this.properties = other.properties == null ? null : new HashMap<SimpleString, PropertyValue>(other.properties);
        this.size = other.size;
    }

    public boolean hasInternalProperties() {
        return this.internalProperties;
    }

    public void putBooleanProperty(SimpleString key, boolean value) {
        this.checkCreateProperties();
        this.doPutValue(key, new BooleanValue(value));
    }

    public void putByteProperty(SimpleString key, byte value) {
        this.checkCreateProperties();
        this.doPutValue(key, new ByteValue(value));
    }

    public void putBytesProperty(SimpleString key, byte[] value) {
        this.checkCreateProperties();
        this.doPutValue(key, value == null ? new NullValue() : new BytesValue(value));
    }

    public void putShortProperty(SimpleString key, short value) {
        this.checkCreateProperties();
        this.doPutValue(key, new ShortValue(value));
    }

    public void putIntProperty(SimpleString key, int value) {
        this.checkCreateProperties();
        this.doPutValue(key, new IntValue(value));
    }

    public void putLongProperty(SimpleString key, long value) {
        this.checkCreateProperties();
        this.doPutValue(key, new LongValue(value));
    }

    public void putFloatProperty(SimpleString key, float value) {
        this.checkCreateProperties();
        this.doPutValue(key, new FloatValue(value));
    }

    public void putDoubleProperty(SimpleString key, double value) {
        this.checkCreateProperties();
        this.doPutValue(key, new DoubleValue(value));
    }

    public void putSimpleStringProperty(SimpleString key, SimpleString value) {
        this.checkCreateProperties();
        this.doPutValue(key, value == null ? new NullValue() : new StringValue(value));
    }

    public void putCharProperty(SimpleString key, char value) {
        this.checkCreateProperties();
        this.doPutValue(key, new CharValue(value));
    }

    public void putTypedProperties(TypedProperties otherProps) {
        if (otherProps == null || otherProps.properties == null) {
            return;
        }
        this.checkCreateProperties();
        Set<Map.Entry<SimpleString, PropertyValue>> otherEntries = otherProps.properties.entrySet();
        for (Map.Entry<SimpleString, PropertyValue> otherEntry : otherEntries) {
            this.doPutValue(otherEntry.getKey(), otherEntry.getValue());
        }
    }

    public Object getProperty(SimpleString key) {
        return this.doGetProperty(key);
    }

    public Boolean getBooleanProperty(SimpleString key) throws PropertyConversionException {
        Object value = this.doGetProperty(key);
        if (value == null) {
            return Boolean.valueOf(null);
        }
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        if (value instanceof SimpleString) {
            return (boolean)Boolean.valueOf(((SimpleString)value).toString());
        }
        throw new PropertyConversionException("Invalid conversion");
    }

    public Byte getByteProperty(SimpleString key) throws PropertyConversionException {
        Object value = this.doGetProperty(key);
        if (value == null) {
            return Byte.valueOf(null);
        }
        if (value instanceof Byte) {
            return (Byte)value;
        }
        if (value instanceof SimpleString) {
            return Byte.parseByte(((SimpleString)value).toString());
        }
        throw new PropertyConversionException("Invalid conversion");
    }

    public Character getCharProperty(SimpleString key) throws PropertyConversionException {
        Object value = this.doGetProperty(key);
        if (value == null) {
            throw new NullPointerException("Invalid conversion");
        }
        if (value instanceof Character) {
            return Character.valueOf(((Character)value).charValue());
        }
        throw new PropertyConversionException("Invalid conversion");
    }

    public byte[] getBytesProperty(SimpleString key) throws PropertyConversionException {
        Object value = this.doGetProperty(key);
        if (value == null) {
            return null;
        }
        if (value instanceof byte[]) {
            return (byte[])value;
        }
        throw new PropertyConversionException("Invalid conversion");
    }

    public Double getDoubleProperty(SimpleString key) throws PropertyConversionException {
        Object value = this.doGetProperty(key);
        if (value == null) {
            return Double.valueOf(null);
        }
        if (value instanceof Float) {
            return ((Float)value).doubleValue();
        }
        if (value instanceof Double) {
            return (Double)value;
        }
        if (value instanceof SimpleString) {
            return Double.parseDouble(((SimpleString)value).toString());
        }
        throw new PropertyConversionException("Invalid conversion");
    }

    public Integer getIntProperty(SimpleString key) throws PropertyConversionException {
        Object value = this.doGetProperty(key);
        if (value == null) {
            return Integer.valueOf(null);
        }
        if (value instanceof Integer) {
            return (Integer)value;
        }
        if (value instanceof Byte) {
            return ((Byte)value).intValue();
        }
        if (value instanceof Short) {
            return ((Short)value).intValue();
        }
        if (value instanceof SimpleString) {
            return Integer.parseInt(((SimpleString)value).toString());
        }
        throw new PropertyConversionException("Invalid conversion");
    }

    public Long getLongProperty(SimpleString key) throws PropertyConversionException {
        Object value = this.doGetProperty(key);
        if (value == null) {
            return Long.valueOf(null);
        }
        if (value instanceof Long) {
            return (Long)value;
        }
        if (value instanceof Byte) {
            return ((Byte)value).longValue();
        }
        if (value instanceof Short) {
            return ((Short)value).longValue();
        }
        if (value instanceof Integer) {
            return ((Integer)value).longValue();
        }
        if (value instanceof SimpleString) {
            return Long.parseLong(((SimpleString)value).toString());
        }
        throw new PropertyConversionException("Invalid conversion");
    }

    public Short getShortProperty(SimpleString key) throws PropertyConversionException {
        Object value = this.doGetProperty(key);
        if (value == null) {
            return Short.valueOf(null);
        }
        if (value instanceof Byte) {
            return ((Byte)value).shortValue();
        }
        if (value instanceof Short) {
            return (Short)value;
        }
        if (value instanceof SimpleString) {
            return Short.parseShort(((SimpleString)value).toString());
        }
        throw new PropertyConversionException("Invalid Conversion.");
    }

    public Float getFloatProperty(SimpleString key) throws PropertyConversionException {
        Object value = this.doGetProperty(key);
        if (value == null) {
            return Float.valueOf(null);
        }
        if (value instanceof Float) {
            return Float.valueOf(((Float)value).floatValue());
        }
        if (value instanceof SimpleString) {
            return Float.valueOf(Float.parseFloat(((SimpleString)value).toString()));
        }
        throw new PropertyConversionException("Invalid conversion: " + key);
    }

    public SimpleString getSimpleStringProperty(SimpleString key) throws PropertyConversionException {
        Object value = this.doGetProperty(key);
        if (value == null) {
            return null;
        }
        if (value instanceof SimpleString) {
            return (SimpleString)value;
        }
        if (value instanceof Boolean) {
            return new SimpleString(value.toString());
        }
        if (value instanceof Character) {
            return new SimpleString(value.toString());
        }
        if (value instanceof Byte) {
            return new SimpleString(value.toString());
        }
        if (value instanceof Short) {
            return new SimpleString(value.toString());
        }
        if (value instanceof Integer) {
            return new SimpleString(value.toString());
        }
        if (value instanceof Long) {
            return new SimpleString(value.toString());
        }
        if (value instanceof Float) {
            return new SimpleString(value.toString());
        }
        if (value instanceof Double) {
            return new SimpleString(value.toString());
        }
        throw new PropertyConversionException("Invalid conversion");
    }

    public Object removeProperty(SimpleString key) {
        return this.doRemoveProperty(key);
    }

    public boolean containsProperty(SimpleString key) {
        if (this.size == 0) {
            return false;
        }
        return this.properties.containsKey(key);
    }

    public Set<SimpleString> getPropertyNames() {
        if (this.size == 0) {
            return Collections.emptySet();
        }
        return this.properties.keySet();
    }

    public synchronized void decode(HornetQBuffer buffer) {
        byte b = buffer.readByte();
        if (b == 0) {
            this.properties = null;
        } else {
            int numHeaders = buffer.readInt();
            this.properties = new HashMap<SimpleString, PropertyValue>(numHeaders);
            this.size = 0;
            block13: for (int i = 0; i < numHeaders; ++i) {
                int len = buffer.readInt();
                byte[] data = new byte[len];
                buffer.readBytes(data);
                SimpleString key = new SimpleString(data);
                byte type = buffer.readByte();
                switch (type) {
                    case 0: {
                        PropertyValue val = new NullValue();
                        this.doPutValue(key, val);
                        continue block13;
                    }
                    case 11: {
                        PropertyValue val = new CharValue(buffer);
                        this.doPutValue(key, val);
                        continue block13;
                    }
                    case 2: {
                        PropertyValue val = new BooleanValue(buffer);
                        this.doPutValue(key, val);
                        continue block13;
                    }
                    case 3: {
                        PropertyValue val = new ByteValue(buffer);
                        this.doPutValue(key, val);
                        continue block13;
                    }
                    case 4: {
                        PropertyValue val = new BytesValue(buffer);
                        this.doPutValue(key, val);
                        continue block13;
                    }
                    case 5: {
                        PropertyValue val = new ShortValue(buffer);
                        this.doPutValue(key, val);
                        continue block13;
                    }
                    case 6: {
                        PropertyValue val = new IntValue(buffer);
                        this.doPutValue(key, val);
                        continue block13;
                    }
                    case 7: {
                        PropertyValue val = new LongValue(buffer);
                        this.doPutValue(key, val);
                        continue block13;
                    }
                    case 8: {
                        PropertyValue val = new FloatValue(buffer);
                        this.doPutValue(key, val);
                        continue block13;
                    }
                    case 9: {
                        PropertyValue val = new DoubleValue(buffer);
                        this.doPutValue(key, val);
                        continue block13;
                    }
                    case 10: {
                        PropertyValue val = new StringValue(buffer);
                        this.doPutValue(key, val);
                        continue block13;
                    }
                    default: {
                        throw new IllegalArgumentException("Invalid type: " + type);
                    }
                }
            }
        }
    }

    public synchronized void encode(HornetQBuffer buffer) {
        if (this.properties == null) {
            buffer.writeByte((byte)0);
        } else {
            buffer.writeByte((byte)1);
            buffer.writeInt(this.properties.size());
            for (Map.Entry<SimpleString, PropertyValue> entry : this.properties.entrySet()) {
                SimpleString s = entry.getKey();
                byte[] data = s.getData();
                buffer.writeInt(data.length);
                buffer.writeBytes(data);
                entry.getValue().write(buffer);
            }
        }
    }

    public int getEncodeSize() {
        if (this.properties == null) {
            return 1;
        }
        return 5 + this.size;
    }

    public void clear() {
        if (this.properties != null) {
            this.properties.clear();
        }
    }

    public String toString() {
        return "TypedProperties[" + this.properties + "]";
    }

    private void checkCreateProperties() {
        if (this.properties == null) {
            this.properties = new HashMap<SimpleString, PropertyValue>();
        }
    }

    private synchronized void doPutValue(SimpleString key, PropertyValue value) {
        PropertyValue oldValue;
        if (key.startsWith(HQ_PROPNAME)) {
            this.internalProperties = true;
        }
        this.size = (oldValue = this.properties.put(key, value)) != null ? (this.size += value.encodeSize() - oldValue.encodeSize()) : (this.size += SimpleString.sizeofString(key) + value.encodeSize());
    }

    private synchronized Object doRemoveProperty(SimpleString key) {
        if (this.properties == null) {
            return null;
        }
        PropertyValue val = this.properties.remove(key);
        if (val == null) {
            return null;
        }
        this.size -= SimpleString.sizeofString(key) + val.encodeSize();
        return val.getValue();
    }

    private synchronized Object doGetProperty(Object key) {
        if (this.size == 0) {
            return null;
        }
        PropertyValue val = this.properties.get(key);
        if (val == null) {
            return null;
        }
        return val.getValue();
    }

    private static final class StringValue
    extends PropertyValue {
        final SimpleString val;

        public StringValue(SimpleString val) {
            this.val = val;
        }

        public StringValue(HornetQBuffer buffer) {
            this.val = buffer.readSimpleString();
        }

        @Override
        public Object getValue() {
            return this.val;
        }

        @Override
        public void write(HornetQBuffer buffer) {
            buffer.writeByte((byte)10);
            buffer.writeSimpleString(this.val);
        }

        @Override
        public int encodeSize() {
            return 1 + SimpleString.sizeofString(this.val);
        }
    }

    private static final class CharValue
    extends PropertyValue {
        final char val;

        public CharValue(char val) {
            this.val = val;
        }

        public CharValue(HornetQBuffer buffer) {
            this.val = (char)buffer.readShort();
        }

        @Override
        public Object getValue() {
            return Character.valueOf(this.val);
        }

        @Override
        public void write(HornetQBuffer buffer) {
            buffer.writeByte((byte)11);
            buffer.writeShort((short)this.val);
        }

        @Override
        public int encodeSize() {
            return 3;
        }
    }

    private static final class DoubleValue
    extends PropertyValue {
        final double val;

        public DoubleValue(double val) {
            this.val = val;
        }

        public DoubleValue(HornetQBuffer buffer) {
            this.val = Double.longBitsToDouble(buffer.readLong());
        }

        @Override
        public Object getValue() {
            return this.val;
        }

        @Override
        public void write(HornetQBuffer buffer) {
            buffer.writeByte((byte)9);
            buffer.writeLong(Double.doubleToLongBits(this.val));
        }

        @Override
        public int encodeSize() {
            return 9;
        }
    }

    private static final class FloatValue
    extends PropertyValue {
        final float val;

        public FloatValue(float val) {
            this.val = val;
        }

        public FloatValue(HornetQBuffer buffer) {
            this.val = Float.intBitsToFloat(buffer.readInt());
        }

        @Override
        public Object getValue() {
            return Float.valueOf(this.val);
        }

        @Override
        public void write(HornetQBuffer buffer) {
            buffer.writeByte((byte)8);
            buffer.writeInt(Float.floatToIntBits(this.val));
        }

        @Override
        public int encodeSize() {
            return 5;
        }
    }

    private static final class LongValue
    extends PropertyValue {
        final long val;

        public LongValue(long val) {
            this.val = val;
        }

        public LongValue(HornetQBuffer buffer) {
            this.val = buffer.readLong();
        }

        @Override
        public Object getValue() {
            return this.val;
        }

        @Override
        public void write(HornetQBuffer buffer) {
            buffer.writeByte((byte)7);
            buffer.writeLong(this.val);
        }

        @Override
        public int encodeSize() {
            return 9;
        }
    }

    private static final class IntValue
    extends PropertyValue {
        final int val;

        public IntValue(int val) {
            this.val = val;
        }

        public IntValue(HornetQBuffer buffer) {
            this.val = buffer.readInt();
        }

        @Override
        public Object getValue() {
            return this.val;
        }

        @Override
        public void write(HornetQBuffer buffer) {
            buffer.writeByte((byte)6);
            buffer.writeInt(this.val);
        }

        @Override
        public int encodeSize() {
            return 5;
        }
    }

    private static final class ShortValue
    extends PropertyValue {
        final short val;

        public ShortValue(short val) {
            this.val = val;
        }

        public ShortValue(HornetQBuffer buffer) {
            this.val = buffer.readShort();
        }

        @Override
        public Object getValue() {
            return this.val;
        }

        @Override
        public void write(HornetQBuffer buffer) {
            buffer.writeByte((byte)5);
            buffer.writeShort(this.val);
        }

        @Override
        public int encodeSize() {
            return 3;
        }
    }

    private static final class BytesValue
    extends PropertyValue {
        final byte[] val;

        public BytesValue(byte[] val) {
            this.val = val;
        }

        public BytesValue(HornetQBuffer buffer) {
            int len = buffer.readInt();
            this.val = new byte[len];
            buffer.readBytes(this.val);
        }

        @Override
        public Object getValue() {
            return this.val;
        }

        @Override
        public void write(HornetQBuffer buffer) {
            buffer.writeByte((byte)4);
            buffer.writeInt(this.val.length);
            buffer.writeBytes(this.val);
        }

        @Override
        public int encodeSize() {
            return 5 + this.val.length;
        }
    }

    private static final class ByteValue
    extends PropertyValue {
        final byte val;

        public ByteValue(byte val) {
            this.val = val;
        }

        public ByteValue(HornetQBuffer buffer) {
            this.val = buffer.readByte();
        }

        @Override
        public Object getValue() {
            return this.val;
        }

        @Override
        public void write(HornetQBuffer buffer) {
            buffer.writeByte((byte)3);
            buffer.writeByte(this.val);
        }

        @Override
        public int encodeSize() {
            return 2;
        }
    }

    private static final class BooleanValue
    extends PropertyValue {
        final boolean val;

        public BooleanValue(boolean val) {
            this.val = val;
        }

        public BooleanValue(HornetQBuffer buffer) {
            this.val = buffer.readBoolean();
        }

        @Override
        public Object getValue() {
            return this.val;
        }

        @Override
        public void write(HornetQBuffer buffer) {
            buffer.writeByte((byte)2);
            buffer.writeBoolean(this.val);
        }

        @Override
        public int encodeSize() {
            return 2;
        }
    }

    private static final class NullValue
    extends PropertyValue {
        @Override
        public Object getValue() {
            return null;
        }

        @Override
        public void write(HornetQBuffer buffer) {
            buffer.writeByte((byte)0);
        }

        @Override
        public int encodeSize() {
            return 1;
        }
    }

    private static abstract class PropertyValue {
        private PropertyValue() {
        }

        abstract Object getValue();

        abstract void write(HornetQBuffer var1);

        abstract int encodeSize();

        public String toString() {
            return "" + this.getValue();
        }
    }
}

