/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.core.server.impl;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executor;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.hornetq.api.core.Message;
import org.hornetq.api.core.SimpleString;
import org.hornetq.core.filter.Filter;
import org.hornetq.core.logging.Logger;
import org.hornetq.core.paging.cursor.PageSubscription;
import org.hornetq.core.paging.cursor.PagedReference;
import org.hornetq.core.persistence.StorageManager;
import org.hornetq.core.postoffice.Bindings;
import org.hornetq.core.postoffice.DuplicateIDCache;
import org.hornetq.core.postoffice.PostOffice;
import org.hornetq.core.server.Consumer;
import org.hornetq.core.server.HandleStatus;
import org.hornetq.core.server.MessageReference;
import org.hornetq.core.server.Queue;
import org.hornetq.core.server.RoutingContext;
import org.hornetq.core.server.ScheduledDeliveryHandler;
import org.hornetq.core.server.ServerMessage;
import org.hornetq.core.server.cluster.impl.Redistributor;
import org.hornetq.core.server.impl.ScheduledDeliveryHandlerImpl;
import org.hornetq.core.settings.HierarchicalRepository;
import org.hornetq.core.settings.impl.AddressSettings;
import org.hornetq.core.transaction.Transaction;
import org.hornetq.core.transaction.TransactionOperation;
import org.hornetq.core.transaction.impl.TransactionImpl;
import org.hornetq.utils.ConcurrentHashSet;
import org.hornetq.utils.Future;
import org.hornetq.utils.LinkedListIterator;
import org.hornetq.utils.PriorityLinkedList;
import org.hornetq.utils.PriorityLinkedListImpl;

public class QueueImpl
implements Queue {
    private static final Logger log = Logger.getLogger(QueueImpl.class);
    private static final boolean isTrace = log.isTraceEnabled();
    public static final int REDISTRIBUTOR_BATCH_SIZE = 100;
    public static final int NUM_PRIORITIES = 10;
    public static final int MAX_DELIVERIES_IN_LOOP = 1000;
    public static final int CHECK_QUEUE_SIZE_PERIOD = 100;
    private static final int DELIVERY_TIMEOUT = 1000;
    private final long id;
    private final SimpleString name;
    private volatile Filter filter;
    private final boolean durable;
    private final boolean temporary;
    private final PostOffice postOffice;
    private final PageSubscription pageSubscription;
    private final LinkedListIterator<PagedReference> pageIterator;
    private final ConcurrentLinkedQueue<MessageReference> intermediateMessageReferences = new ConcurrentLinkedQueue();
    private final PriorityLinkedList<MessageReference> messageReferences = new PriorityLinkedListImpl<MessageReference>(10);
    private final AtomicInteger pagedReferences = new AtomicInteger(0);
    private final AtomicInteger queueMemorySize = new AtomicInteger(0);
    private final List<ConsumerHolder> consumerList = new ArrayList<ConsumerHolder>();
    private final ScheduledDeliveryHandler scheduledDeliveryHandler;
    private long messagesAdded;
    protected final AtomicInteger deliveringCount = new AtomicInteger(0);
    private boolean paused;
    private final Runnable deliverRunner = new DeliverRunner();
    private volatile boolean depagePending = false;
    private final Runnable depageRunner = new DepageRunner();
    private final StorageManager storageManager;
    private final HierarchicalRepository<AddressSettings> addressSettingsRepository;
    private final ScheduledExecutorService scheduledExecutor;
    private final SimpleString address;
    private Redistributor redistributor;
    private final Set<ScheduledFuture<?>> futures = new ConcurrentHashSet();
    private ScheduledFuture<?> redistributorFuture;
    private ScheduledFuture<?> checkQueueSizeFuture;
    private final Set<Consumer> consumerSet = new HashSet<Consumer>();
    private final Map<SimpleString, Consumer> groups = new HashMap<SimpleString, Consumer>();
    private volatile SimpleString expiryAddress;
    private int pos;
    private final Executor executor;
    private volatile int consumerWithFilterCount;
    private final Runnable concurrentPoller = new ConcurrentPoller();
    private boolean internalQueue;
    private volatile boolean checkDirect;
    private volatile boolean directDeliver = true;

    public String debug() {
        StringWriter str = new StringWriter();
        PrintWriter out = new PrintWriter(str);
        out.println("queueMemorySize=" + this.queueMemorySize);
        for (ConsumerHolder holder : this.consumerList) {
            out.println("consumer: " + holder.consumer.debug());
        }
        for (MessageReference reference : this.intermediateMessageReferences) {
            out.print("Intermediate reference:" + reference);
        }
        if (this.intermediateMessageReferences.isEmpty()) {
            out.println("No intermediate references");
        }
        boolean foundRef = false;
        LinkedListIterator<MessageReference> iter = this.messageReferences.iterator();
        while (iter.hasNext()) {
            foundRef = true;
            out.println("reference = " + iter.next());
        }
        if (!foundRef) {
            out.println("No permanent references on queue");
        }
        System.out.println(str.toString());
        return str.toString();
    }

    public QueueImpl(long id, SimpleString address, SimpleString name, Filter filter, boolean durable, boolean temporary, ScheduledExecutorService scheduledExecutor, PostOffice postOffice, StorageManager storageManager, HierarchicalRepository<AddressSettings> addressSettingsRepository, Executor executor) {
        this(id, address, name, filter, null, durable, temporary, scheduledExecutor, postOffice, storageManager, addressSettingsRepository, executor);
    }

    public QueueImpl(long id, SimpleString address, SimpleString name, Filter filter, PageSubscription pageSubscription, boolean durable, boolean temporary, ScheduledExecutorService scheduledExecutor, PostOffice postOffice, StorageManager storageManager, HierarchicalRepository<AddressSettings> addressSettingsRepository, Executor executor) {
        this.id = id;
        this.address = address;
        this.name = name;
        this.filter = filter;
        this.pageSubscription = pageSubscription;
        this.durable = durable;
        this.temporary = temporary;
        this.postOffice = postOffice;
        this.storageManager = storageManager;
        this.addressSettingsRepository = addressSettingsRepository;
        this.scheduledExecutor = scheduledExecutor;
        this.scheduledDeliveryHandler = new ScheduledDeliveryHandlerImpl(scheduledExecutor);
        this.expiryAddress = addressSettingsRepository != null ? addressSettingsRepository.getMatch(address.toString()).getExpiryAddress() : null;
        if (pageSubscription != null) {
            pageSubscription.setQueue(this);
            this.pageIterator = pageSubscription.iterator();
        } else {
            this.pageIterator = null;
        }
        this.executor = executor;
        this.checkQueueSizeFuture = scheduledExecutor.scheduleWithFixedDelay(new Runnable(){

            @Override
            public void run() {
                QueueImpl.this.checkDirect = true;
            }
        }, 100L, 100L, TimeUnit.MILLISECONDS);
    }

    public SimpleString getRoutingName() {
        return this.name;
    }

    public SimpleString getUniqueName() {
        return this.name;
    }

    public boolean isExclusive() {
        return false;
    }

    @Override
    public void route(ServerMessage message, RoutingContext context) throws Exception {
        context.addQueue(this.address, this);
    }

    @Override
    public boolean isDurable() {
        return this.durable;
    }

    @Override
    public boolean isTemporary() {
        return this.temporary;
    }

    @Override
    public SimpleString getName() {
        return this.name;
    }

    @Override
    public SimpleString getAddress() {
        return this.address;
    }

    @Override
    public long getID() {
        return this.id;
    }

    @Override
    public PageSubscription getPageSubscription() {
        return this.pageSubscription;
    }

    @Override
    public Filter getFilter() {
        return this.filter;
    }

    @Override
    public synchronized void addHead(MessageReference ref) {
        if (this.scheduledDeliveryHandler.checkAndSchedule(ref, false)) {
            return;
        }
        this.internalAddHead(ref);
        this.directDeliver = false;
    }

    @Override
    public synchronized void reload(MessageReference ref) {
        this.queueMemorySize.addAndGet(ref.getMessageMemoryEstimate());
        if (!this.scheduledDeliveryHandler.checkAndSchedule(ref, true)) {
            this.internalAddTail(ref);
        }
        this.directDeliver = false;
        ++this.messagesAdded;
    }

    @Override
    public void addTail(MessageReference ref) {
        this.addTail(ref, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addTail(MessageReference ref, boolean direct) {
        if (this.scheduledDeliveryHandler.checkAndSchedule(ref, true)) {
            QueueImpl queueImpl = this;
            synchronized (queueImpl) {
                ++this.messagesAdded;
            }
            return;
        }
        if (this.checkDirect) {
            if (direct && !this.directDeliver && this.intermediateMessageReferences.isEmpty() && this.messageReferences.isEmpty() && !this.pageIterator.hasNext() && !this.pageSubscription.isPaging() && this.flushExecutor()) {
                this.directDeliver = true;
            }
            this.checkDirect = false;
        }
        if (direct && this.directDeliver && this.deliverDirect(ref)) {
            return;
        }
        this.queueMemorySize.addAndGet(ref.getMessageMemoryEstimate());
        this.intermediateMessageReferences.add(ref);
        this.directDeliver = false;
        this.getExecutor().execute(this.concurrentPoller);
    }

    @Override
    public void forceDelivery() {
        if (this.pageSubscription != null && this.pageSubscription.isPaging()) {
            if (isTrace) {
                log.trace("Force delivery scheduling depage");
            }
            this.scheduleDepage();
        }
        if (isTrace) {
            log.trace("Force delivery deliverying async");
        }
        this.deliverAsync();
    }

    @Override
    public void deliverAsync() {
        try {
            this.getExecutor().execute(this.deliverRunner);
        }
        catch (RejectedExecutionException rejectedExecutionException) {
            // empty catch block
        }
    }

    @Override
    public void close() throws Exception {
        if (this.checkQueueSizeFuture != null) {
            this.checkQueueSizeFuture.cancel(false);
        }
        this.getExecutor().execute(new Runnable(){

            @Override
            public void run() {
                try {
                    QueueImpl.this.cancelRedistributor();
                }
                catch (Exception e) {
                    log.warn(e.getMessage(), e);
                }
            }
        });
    }

    @Override
    public Executor getExecutor() {
        if (this.pageSubscription != null && this.pageSubscription.isPaging()) {
            return this.pageSubscription.getExecutor();
        }
        return this.executor;
    }

    public void deliverNow() {
        this.deliverAsync();
        this.flushExecutor();
    }

    @Override
    public boolean flushExecutor() {
        Future future = new Future();
        this.getExecutor().execute(future);
        boolean ok = future.await(10000L);
        if (!ok) {
            log.warn("Couldn't finish waiting executors. Try increasing the thread pool size", new Exception("trace"));
        }
        return ok;
    }

    @Override
    public synchronized void addConsumer(Consumer consumer) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(this + " adding consumer " + consumer);
        }
        this.cancelRedistributor();
        if (consumer.getFilter() != null) {
            ++this.consumerWithFilterCount;
        }
        this.consumerList.add(new ConsumerHolder(consumer));
        this.consumerSet.add(consumer);
    }

    @Override
    public synchronized void removeConsumer(Consumer consumer) throws Exception {
        Iterator<ConsumerHolder> iter = this.consumerList.iterator();
        while (iter.hasNext()) {
            ConsumerHolder holder = iter.next();
            if (holder.consumer != consumer) continue;
            if (holder.iter != null) {
                holder.iter.close();
            }
            iter.remove();
            break;
        }
        if (this.pos > 0 && this.pos >= this.consumerList.size()) {
            this.pos = this.consumerList.size() - 1;
        }
        this.consumerSet.remove(consumer);
        ArrayList<SimpleString> gids = new ArrayList<SimpleString>();
        for (SimpleString groupID : this.groups.keySet()) {
            if (consumer != this.groups.get(groupID)) continue;
            gids.add(groupID);
        }
        for (SimpleString gid : gids) {
            this.groups.remove(gid);
        }
        if (consumer.getFilter() != null) {
            --this.consumerWithFilterCount;
        }
    }

    @Override
    public synchronized void addRedistributor(long delay) {
        if (this.redistributorFuture != null) {
            this.redistributorFuture.cancel(false);
            this.futures.remove(this.redistributorFuture);
        }
        if (this.redistributor != null) {
            this.deliverAsync();
        }
        if (delay > 0L) {
            if (this.consumerSet.isEmpty()) {
                DelayedAddRedistributor dar = new DelayedAddRedistributor(this.executor);
                this.redistributorFuture = this.scheduledExecutor.schedule(dar, delay, TimeUnit.MILLISECONDS);
                this.futures.add(this.redistributorFuture);
            }
        } else {
            this.internalAddRedistributor(this.executor);
        }
    }

    @Override
    public synchronized void cancelRedistributor() throws Exception {
        if (this.redistributor != null) {
            this.redistributor.stop();
            this.redistributor = null;
            Iterator<ConsumerHolder> iter = this.consumerList.iterator();
            while (iter.hasNext()) {
                ConsumerHolder holder = iter.next();
                if (holder.consumer != this.redistributor) continue;
                iter.remove();
                break;
            }
            if (this.pos > 0 && this.pos >= this.consumerList.size()) {
                this.pos = this.consumerList.size() - 1;
            }
        }
        if (this.redistributorFuture != null) {
            this.redistributorFuture.cancel(false);
            this.redistributorFuture = null;
        }
    }

    protected void finalize() throws Throwable {
        if (this.checkQueueSizeFuture != null) {
            this.checkQueueSizeFuture.cancel(false);
        }
        this.cancelRedistributor();
        super.finalize();
    }

    @Override
    public synchronized int getConsumerCount() {
        return this.consumerSet.size();
    }

    public synchronized Set<Consumer> getConsumers() {
        return this.consumerSet;
    }

    @Override
    public synchronized boolean hasMatchingConsumer(ServerMessage message) {
        for (ConsumerHolder holder : this.consumerList) {
            Consumer consumer = holder.consumer;
            if (consumer instanceof Redistributor) continue;
            Filter filter = consumer.getFilter();
            if (filter == null) {
                return true;
            }
            if (!filter.match(message)) continue;
            return true;
        }
        return false;
    }

    @Override
    public LinkedListIterator<MessageReference> iterator() {
        return new SynchronizedIterator(this.messageReferences.iterator());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized MessageReference removeReferenceWithID(long id) throws Exception {
        LinkedListIterator<MessageReference> iterator = this.iterator();
        try {
            MessageReference removed = null;
            while (iterator.hasNext()) {
                MessageReference ref = (MessageReference)iterator.next();
                if (ref.getMessage().getMessageID() != id) continue;
                iterator.remove();
                this.refRemoved(ref);
                removed = ref;
                break;
            }
            if (removed == null) {
                removed = this.scheduledDeliveryHandler.removeReferenceWithID(id);
            }
            MessageReference messageReference = removed;
            return messageReference;
        }
        finally {
            iterator.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized MessageReference getReference(long id) {
        LinkedListIterator<MessageReference> iterator = this.iterator();
        try {
            while (iterator.hasNext()) {
                MessageReference ref = (MessageReference)iterator.next();
                if (ref.getMessage().getMessageID() != id) continue;
                MessageReference messageReference = ref;
                return messageReference;
            }
            MessageReference messageReference = null;
            return messageReference;
        }
        finally {
            iterator.close();
        }
    }

    @Override
    public long getMessageCount() {
        final CountDownLatch latch = new CountDownLatch(1);
        final AtomicLong count = new AtomicLong(0L);
        this.getExecutor().execute(new Runnable(){

            @Override
            public void run() {
                count.set(QueueImpl.this.getInstantMessageCount());
                latch.countDown();
            }
        });
        try {
            if (!latch.await(10L, TimeUnit.SECONDS)) {
                throw new IllegalStateException("Timed out on waiting for MessageCount");
            }
        }
        catch (Exception e) {
            log.warn(e.getMessage(), e);
        }
        return count.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getInstantMessageCount() {
        QueueImpl queueImpl = this;
        synchronized (queueImpl) {
            if (this.pageSubscription != null) {
                return (long)(this.messageReferences.size() + this.getScheduledCount() + this.deliveringCount.get()) + this.pageSubscription.getMessageCount();
            }
            return this.messageReferences.size() + this.getScheduledCount() + this.deliveringCount.get();
        }
    }

    @Override
    public synchronized int getScheduledCount() {
        return this.scheduledDeliveryHandler.getScheduledCount();
    }

    @Override
    public synchronized List<MessageReference> getScheduledMessages() {
        return this.scheduledDeliveryHandler.getScheduledReferences();
    }

    @Override
    public int getDeliveringCount() {
        return this.deliveringCount.get();
    }

    @Override
    public void acknowledge(MessageReference ref) throws Exception {
        if (ref.isPaged()) {
            this.pageSubscription.ack((PagedReference)ref);
            this.postAcknowledge(ref);
        } else {
            boolean durableRef;
            ServerMessage message = ref.getMessage();
            boolean bl = durableRef = message.isDurable() && this.durable;
            if (durableRef) {
                this.storageManager.storeAcknowledge(this.id, message.getMessageID());
            }
            this.postAcknowledge(ref);
        }
    }

    @Override
    public void acknowledge(Transaction tx, MessageReference ref) throws Exception {
        if (ref.isPaged()) {
            this.pageSubscription.ackTx(tx, (PagedReference)ref);
            this.getRefsOperation(tx).addAck(ref);
        } else {
            boolean durableRef;
            ServerMessage message = ref.getMessage();
            boolean bl = durableRef = message.isDurable() && this.durable;
            if (durableRef) {
                this.storageManager.storeAcknowledgeTransactional(tx.getID(), this.id, message.getMessageID());
                tx.setContainsPersistent();
            }
            this.getRefsOperation(tx).addAck(ref);
        }
    }

    @Override
    public void reacknowledge(Transaction tx, MessageReference ref) throws Exception {
        ServerMessage message = ref.getMessage();
        if (message.isDurable() && this.durable) {
            tx.setContainsPersistent();
        }
        this.getRefsOperation(tx).addAck(ref);
        this.deliveringCount.incrementAndGet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final RefsOperation getRefsOperation(Transaction tx) {
        Transaction transaction = tx;
        synchronized (transaction) {
            RefsOperation oper = (RefsOperation)tx.getProperty(6);
            if (oper == null) {
                oper = new RefsOperation();
                tx.putProperty(6, oper);
                tx.addOperation(oper);
            }
            return oper;
        }
    }

    @Override
    public void cancel(Transaction tx, MessageReference reference) throws Exception {
        this.getRefsOperation(tx).addAck(reference);
    }

    @Override
    public synchronized void cancel(MessageReference reference, long timeBase) throws Exception {
        this.deliveringCount.decrementAndGet();
        if (this.checkRedelivery(reference, timeBase)) {
            if (!this.scheduledDeliveryHandler.checkAndSchedule(reference, false)) {
                this.internalAddHead(reference);
            }
            this.resetAllIterators();
        }
    }

    @Override
    public void expire(MessageReference ref) throws Exception {
        if (this.expiryAddress != null) {
            if (isTrace) {
                log.trace("moving expired reference " + ref + " to address = " + this.expiryAddress + " from queue=" + this.getName());
            }
            this.move(this.expiryAddress, ref, true, false);
        } else {
            if (isTrace) {
                log.trace("expiry is null, just acking expired message for reference " + ref + " from queue=" + this.getName());
            }
            this.acknowledge(ref);
        }
    }

    @Override
    public void setExpiryAddress(SimpleString expiryAddress) {
        this.expiryAddress = expiryAddress;
    }

    @Override
    public void referenceHandled() {
        this.deliveringCount.incrementAndGet();
    }

    @Override
    public long getMessagesAdded() {
        final CountDownLatch latch = new CountDownLatch(1);
        final AtomicLong count = new AtomicLong(0L);
        this.getExecutor().execute(new Runnable(){

            @Override
            public void run() {
                count.set(QueueImpl.this.getInstantMessagesAdded());
                latch.countDown();
            }
        });
        try {
            if (!latch.await(10L, TimeUnit.SECONDS)) {
                throw new IllegalStateException("Timed out on waiting for MessagesAdded");
            }
        }
        catch (Exception e) {
            log.warn(e.getMessage(), e);
        }
        return count.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getInstantMessagesAdded() {
        QueueImpl queueImpl = this;
        synchronized (queueImpl) {
            if (this.pageSubscription != null) {
                return this.messagesAdded + this.pageSubscription.getCounter().getValue() - (long)this.pagedReferences.get();
            }
            return this.messagesAdded;
        }
    }

    @Override
    public int deleteAllReferences() throws Exception {
        return this.deleteMatchingReferences(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized int deleteMatchingReferences(Filter filter) throws Exception {
        int count = 0;
        TransactionImpl tx = new TransactionImpl(this.storageManager);
        LinkedListIterator<MessageReference> iter = this.iterator();
        try {
            while (iter.hasNext()) {
                MessageReference ref = (MessageReference)iter.next();
                if (filter != null && !filter.match(ref.getMessage())) continue;
                this.deliveringCount.incrementAndGet();
                this.acknowledge(tx, ref);
                iter.remove();
                this.refRemoved(ref);
                ++count;
            }
            List<MessageReference> cancelled = this.scheduledDeliveryHandler.cancel(filter);
            for (MessageReference messageReference : cancelled) {
                this.deliveringCount.incrementAndGet();
                this.acknowledge(tx, messageReference);
                ++count;
            }
            if (this.pageIterator != null) {
                while (this.pageIterator.hasNext()) {
                    PagedReference reference = (PagedReference)this.pageIterator.next();
                    this.pageIterator.remove();
                    if (filter == null || filter.match(reference.getMessage())) {
                        ++count;
                        this.pageSubscription.ack(reference);
                        continue;
                    }
                    this.addTail(reference, false);
                }
            }
            tx.commit();
            if (filter != null && this.pageIterator != null) {
                this.scheduleDepage();
            }
            int n = count;
            return n;
        }
        finally {
            iter.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized boolean deleteReference(long messageID) throws Exception {
        boolean deleted = false;
        TransactionImpl tx = new TransactionImpl(this.storageManager);
        LinkedListIterator<MessageReference> iter = this.iterator();
        try {
            while (iter.hasNext()) {
                MessageReference ref = (MessageReference)iter.next();
                if (ref.getMessage().getMessageID() != messageID) continue;
                this.deliveringCount.incrementAndGet();
                this.acknowledge(tx, ref);
                iter.remove();
                this.refRemoved(ref);
                deleted = true;
                break;
            }
            tx.commit();
            boolean bl = deleted;
            return bl;
        }
        finally {
            iter.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized boolean expireReference(long messageID) throws Exception {
        LinkedListIterator<MessageReference> iter = this.iterator();
        try {
            while (iter.hasNext()) {
                MessageReference ref = (MessageReference)iter.next();
                if (ref.getMessage().getMessageID() != messageID) continue;
                this.deliveringCount.incrementAndGet();
                this.expire(ref);
                iter.remove();
                this.refRemoved(ref);
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            iter.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized int expireReferences(Filter filter) throws Exception {
        TransactionImpl tx = new TransactionImpl(this.storageManager);
        int count = 0;
        LinkedListIterator<MessageReference> iter = this.iterator();
        try {
            while (iter.hasNext()) {
                MessageReference ref = (MessageReference)iter.next();
                if (filter != null && !filter.match(ref.getMessage())) continue;
                this.deliveringCount.incrementAndGet();
                this.expire(tx, ref);
                iter.remove();
                this.refRemoved(ref);
                ++count;
            }
            tx.commit();
            int n = count;
            return n;
        }
        finally {
            iter.close();
        }
    }

    @Override
    public void expireReferences() throws Exception {
        this.getExecutor().execute(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                QueueImpl queueImpl = QueueImpl.this;
                synchronized (queueImpl) {
                    block10: {
                        LinkedListIterator<MessageReference> iter = QueueImpl.this.iterator();
                        block8: while (true) {
                            while (iter.hasNext()) {
                                MessageReference ref = (MessageReference)iter.next();
                                try {
                                    if (!ref.getMessage().isExpired()) continue block8;
                                    QueueImpl.this.deliveringCount.incrementAndGet();
                                    QueueImpl.this.expire(ref);
                                    iter.remove();
                                    QueueImpl.this.refRemoved(ref);
                                    continue block8;
                                }
                                catch (Exception e) {
                                    log.warn("Error expiring reference " + ref, e);
                                }
                            }
                            break block10;
                            {
                                continue block8;
                                break;
                            }
                            break;
                        }
                        finally {
                            iter.close();
                        }
                    }
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized boolean sendMessageToDeadLetterAddress(long messageID) throws Exception {
        LinkedListIterator<MessageReference> iter = this.iterator();
        try {
            while (iter.hasNext()) {
                MessageReference ref = (MessageReference)iter.next();
                if (ref.getMessage().getMessageID() != messageID) continue;
                this.deliveringCount.incrementAndGet();
                this.sendToDeadLetterAddress(ref);
                iter.remove();
                this.refRemoved(ref);
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            iter.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized int sendMessagesToDeadLetterAddress(Filter filter) throws Exception {
        int count = 0;
        LinkedListIterator<MessageReference> iter = this.iterator();
        try {
            while (iter.hasNext()) {
                MessageReference ref = (MessageReference)iter.next();
                if (filter != null && !filter.match(ref.getMessage())) continue;
                this.deliveringCount.incrementAndGet();
                this.sendToDeadLetterAddress(ref);
                iter.remove();
                this.refRemoved(ref);
                ++count;
            }
            int n = count;
            return n;
        }
        finally {
            iter.close();
        }
    }

    @Override
    public boolean moveReference(long messageID, SimpleString toAddress) throws Exception {
        return this.moveReference(messageID, toAddress, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized boolean moveReference(long messageID, SimpleString toAddress, boolean rejectDuplicate) throws Exception {
        LinkedListIterator<MessageReference> iter = this.iterator();
        try {
            while (iter.hasNext()) {
                MessageReference ref = (MessageReference)iter.next();
                if (ref.getMessage().getMessageID() != messageID) continue;
                iter.remove();
                this.refRemoved(ref);
                this.deliveringCount.incrementAndGet();
                try {
                    this.move(toAddress, ref, false, rejectDuplicate);
                }
                catch (Exception e) {
                    this.deliveringCount.decrementAndGet();
                    throw e;
                }
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            iter.close();
        }
    }

    @Override
    public int moveReferences(Filter filter, SimpleString toAddress) throws Exception {
        return this.moveReferences(filter, toAddress, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized int moveReferences(Filter filter, SimpleString toAddress, boolean rejectDuplicates) throws Exception {
        TransactionImpl tx = new TransactionImpl(this.storageManager);
        int count = 0;
        LinkedListIterator<MessageReference> iter = this.iterator();
        try {
            DuplicateIDCache targetDuplicateCache = this.postOffice.getDuplicateIDCache(toAddress);
            while (iter.hasNext()) {
                byte[] duplicateBytes;
                MessageReference ref = (MessageReference)iter.next();
                if (filter != null && !filter.match(ref.getMessage())) continue;
                boolean ignored = false;
                this.deliveringCount.incrementAndGet();
                ++count;
                if (rejectDuplicates && (duplicateBytes = ref.getMessage().getDuplicateIDBytes()) != null && targetDuplicateCache.contains(duplicateBytes)) {
                    log.info("Message with duplicate ID " + ref.getMessage().getDuplicateProperty() + " was already set at " + toAddress + ". Move from " + this.address + " being ignored and message removed from " + this.address);
                    this.acknowledge(tx, ref);
                    ignored = true;
                }
                if (!ignored) {
                    this.move(toAddress, tx, ref, false, rejectDuplicates);
                }
                iter.remove();
            }
            List<MessageReference> cancelled = this.scheduledDeliveryHandler.cancel(filter);
            for (MessageReference ref : cancelled) {
                byte[] duplicateBytes = ref.getMessage().getDuplicateIDBytes();
                if (duplicateBytes != null && targetDuplicateCache.contains(duplicateBytes)) {
                    log.info("Message with duplicate ID " + ref.getMessage().getDuplicateProperty() + " was already set at " + toAddress + ". Move from " + this.address + " being ignored");
                    continue;
                }
                this.deliveringCount.incrementAndGet();
                ++count;
                this.move(toAddress, tx, ref, false, rejectDuplicates);
                this.acknowledge(tx, ref);
            }
            tx.commit();
            int n = count;
            iter.close();
            return n;
        }
        catch (Throwable throwable) {
            try {
                iter.close();
                throw throwable;
            }
            catch (Exception e) {
                this.deliveringCount.addAndGet(-count);
                throw e;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized boolean changeReferencePriority(long messageID, byte newPriority) throws Exception {
        LinkedListIterator<MessageReference> iter = this.iterator();
        try {
            while (iter.hasNext()) {
                MessageReference ref = (MessageReference)iter.next();
                if (ref.getMessage().getMessageID() != messageID) continue;
                iter.remove();
                this.refRemoved(ref);
                ref.getMessage().setPriority(newPriority);
                this.addTail(ref, false);
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            iter.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized int changeReferencesPriority(Filter filter, byte newPriority) throws Exception {
        LinkedListIterator<MessageReference> iter = this.iterator();
        try {
            int count = 0;
            while (iter.hasNext()) {
                MessageReference ref = (MessageReference)iter.next();
                if (filter != null && !filter.match(ref.getMessage())) continue;
                ++count;
                iter.remove();
                this.refRemoved(ref);
                ref.getMessage().setPriority(newPriority);
                this.addTail(ref, false);
            }
            int n = count;
            return n;
        }
        finally {
            iter.close();
        }
    }

    @Override
    public synchronized void resetAllIterators() {
        for (ConsumerHolder holder : this.consumerList) {
            if (holder.iter != null) {
                holder.iter.close();
            }
            holder.iter = null;
        }
    }

    @Override
    public synchronized void pause() {
        this.paused = true;
    }

    @Override
    public synchronized void resume() {
        this.paused = false;
        this.deliverAsync();
    }

    @Override
    public synchronized boolean isPaused() {
        return this.paused;
    }

    @Override
    public boolean isDirectDeliver() {
        return this.directDeliver;
    }

    @Override
    public boolean isInternalQueue() {
        return this.internalQueue;
    }

    @Override
    public void setInternalQueue(boolean internalQueue) {
        this.internalQueue = internalQueue;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof QueueImpl)) {
            return false;
        }
        QueueImpl qother = (QueueImpl)other;
        return this.name.equals(qother.name);
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public String toString() {
        return "QueueImpl[name=" + this.name.toString() + ", postOffice=" + this.postOffice + "]@" + Integer.toHexString(System.identityHashCode(this));
    }

    private void internalAddTail(MessageReference ref) {
        this.refAdded(ref);
        this.messageReferences.addTail(ref, ref.getMessage().getPriority());
    }

    private void internalAddHead(MessageReference ref) {
        this.queueMemorySize.addAndGet(ref.getMessageMemoryEstimate());
        this.refAdded(ref);
        this.messageReferences.addHead(ref, ref.getMessage().getPriority());
    }

    private synchronized void doPoll() {
        MessageReference ref = this.intermediateMessageReferences.poll();
        if (ref != null) {
            this.internalAddTail(ref);
            ++this.messagesAdded;
            if (this.consumerWithFilterCount > 0 || this.messageReferences.size() == 1) {
                this.deliver();
            }
        }
    }

    private synchronized void deliver() {
        if (this.paused || this.consumerList.isEmpty()) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(this + " doing deliver. messageReferences=" + this.messageReferences.size());
        }
        int busyCount = 0;
        int nullRefCount = 0;
        int size = this.consumerList.size();
        int endPos = this.pos == size - 1 ? 0 : size - 1;
        int numRefs = this.messageReferences.size();
        int handled = 0;
        long timeout = System.currentTimeMillis() + 1000L;
        while (handled < numRefs) {
            MessageReference ref;
            if (handled == 1000) {
                this.deliverAsync();
                return;
            }
            if (System.currentTimeMillis() > timeout) {
                if (isTrace) {
                    log.trace("delivery has been running for too long. Scheduling another delivery task now");
                }
                this.deliverAsync();
                return;
            }
            ConsumerHolder holder = this.consumerList.get(this.pos);
            Consumer consumer = holder.consumer;
            if (holder.iter == null) {
                holder.iter = this.messageReferences.iterator();
            }
            if ((ref = holder.iter.hasNext() ? (MessageReference)holder.iter.next() : null) == null) {
                ++nullRefCount;
            } else {
                HandleStatus status;
                SimpleString groupID;
                if (this.checkExpired(ref)) {
                    if (isTrace) {
                        log.trace("Reference " + ref + " being expired");
                    }
                    holder.iter.remove();
                    this.refRemoved(ref);
                    ++handled;
                    continue;
                }
                Consumer groupConsumer = null;
                if (isTrace) {
                    log.trace("Queue " + this.getName() + " is delivering reference " + ref);
                }
                if ((groupID = ref.getMessage().getSimpleStringProperty(Message.HDR_GROUP_ID)) != null && (groupConsumer = this.groups.get(groupID)) != null) {
                    consumer = groupConsumer;
                }
                if ((status = this.handle(ref, consumer)) == HandleStatus.HANDLED) {
                    holder.iter.remove();
                    this.refRemoved(ref);
                    if (groupID != null && groupConsumer == null) {
                        this.groups.put(groupID, consumer);
                    }
                    ++handled;
                } else if (status == HandleStatus.BUSY) {
                    holder.iter.repeat();
                    ++busyCount;
                } else if (status == HandleStatus.NO_MATCH) {
                    // empty if block
                }
            }
            if (this.pos == endPos) {
                if (nullRefCount + busyCount == size) {
                    if (!log.isDebugEnabled()) break;
                    log.debug(this + "::All the consumers were busy, giving up now");
                    break;
                }
                busyCount = 0;
                nullRefCount = 0;
            }
            ++this.pos;
            if (this.pos != size) continue;
            this.pos = 0;
        }
        if (this.pageIterator != null && this.messageReferences.size() == 0 && this.pageSubscription.isPaging() && this.pageIterator.hasNext() && !this.depagePending) {
            this.scheduleDepage();
        }
    }

    private void refRemoved(MessageReference ref) {
        this.queueMemorySize.addAndGet(-ref.getMessageMemoryEstimate());
        if (ref.isPaged()) {
            this.pagedReferences.decrementAndGet();
        }
    }

    protected void refAdded(MessageReference ref) {
        if (ref.isPaged()) {
            this.pagedReferences.incrementAndGet();
        }
    }

    private void scheduleDepage() {
        if (!this.depagePending) {
            if (isTrace) {
                log.trace("Scheduling depage for queue " + this.getName());
            }
            this.depagePending = true;
            this.pageSubscription.getExecutor().execute(this.depageRunner);
        }
    }

    private synchronized void depage() {
        this.depagePending = false;
        if (this.paused || this.pageIterator == null) {
            return;
        }
        long maxSize = this.pageSubscription.getPagingStore().getPageSizeBytes();
        long timeout = System.currentTimeMillis() + 1000L;
        if (isTrace) {
            log.trace("QueueMemorySize before depage on queue=" + this.getName() + " is " + this.queueMemorySize.get());
        }
        this.directDeliver = false;
        int depaged = 0;
        while (timeout > System.currentTimeMillis() && (long)this.queueMemorySize.get() < maxSize && this.pageIterator.hasNext()) {
            ++depaged;
            PagedReference reference = (PagedReference)this.pageIterator.next();
            if (isTrace) {
                log.trace("Depaging reference " + reference + " on queue " + this.getName());
            }
            this.addTail(reference, false);
            this.pageIterator.remove();
        }
        if (log.isDebugEnabled()) {
            if (depaged == 0 && (long)this.queueMemorySize.get() >= maxSize) {
                log.debug("Couldn't depage any message as the maxSize on the queue was achieved. There are too many pending messages to be acked in reference to the page configuration");
            }
            if (log.isDebugEnabled()) {
                log.debug("Queue Memory Size after depage on queue=" + this.getName() + " is " + this.queueMemorySize.get() + " with maxSize = " + maxSize + ". Depaged " + depaged + " messages, pendingDelivery=" + this.messageReferences.size() + ", intermediateMessageReferences= " + this.intermediateMessageReferences.size() + ", queueDelivering=" + this.deliveringCount.get());
            }
        }
        this.deliverAsync();
    }

    private void internalAddRedistributor(Executor executor) {
        if (this.consumerSet.isEmpty() && this.redistributor == null) {
            this.redistributor = new Redistributor(this, this.storageManager, this.postOffice, executor, 100);
            this.consumerList.add(new ConsumerHolder(this.redistributor));
            this.redistributor.start();
            this.deliverAsync();
        }
    }

    @Override
    public boolean checkRedelivery(MessageReference reference, long timeBase) throws Exception {
        AddressSettings addressSettings;
        int maxDeliveries;
        ServerMessage message = reference.getMessage();
        if (this.internalQueue) {
            if (isTrace) {
                log.trace("Queue " + this.getName() + " is an internal queue, no checkRedelivery");
            }
            return true;
        }
        if (!this.internalQueue && message.isDurable() && this.durable && !reference.isPaged()) {
            this.storageManager.updateDeliveryCount(reference);
        }
        if ((maxDeliveries = (addressSettings = this.addressSettingsRepository.getMatch(this.address.toString())).getMaxDeliveryAttempts()) > 0 && reference.getDeliveryCount() >= maxDeliveries) {
            if (isTrace) {
                log.trace("Sending reference " + reference + " to DLA = " + addressSettings.getDeadLetterAddress() + " since ref.getDeliveryCount=" + reference.getDeliveryCount() + "and maxDeliveries=" + maxDeliveries + " from queue=" + this.getName());
            }
            this.sendToDeadLetterAddress(reference, addressSettings.getDeadLetterAddress());
            return false;
        }
        long redeliveryDelay = addressSettings.getRedeliveryDelay();
        if (redeliveryDelay > 0L) {
            if (isTrace) {
                log.trace("Setting redeliveryDelay=" + redeliveryDelay + " on reference=" + reference);
            }
            reference.setScheduledDeliveryTime(timeBase + redeliveryDelay);
            if (!reference.isPaged() && message.isDurable() && this.durable) {
                this.storageManager.updateScheduledDeliveryTime(reference);
            }
        }
        this.deliveringCount.decrementAndGet();
        return true;
    }

    public int getNumberOfReferences() {
        return this.messageReferences.size();
    }

    private void move(SimpleString toAddress, Transaction tx, MessageReference ref, boolean expiry, boolean rejectDuplicate) throws Exception {
        ServerMessage copyMessage = this.makeCopy(ref, expiry);
        copyMessage.setAddress(toAddress);
        this.postOffice.route(copyMessage, tx, false, rejectDuplicate);
        this.acknowledge(tx, ref);
    }

    private ServerMessage makeCopy(MessageReference ref, boolean expiry) throws Exception {
        ServerMessage message = ref.getMessage();
        long newID = this.storageManager.generateUniqueID();
        ServerMessage copy = message.makeCopyForExpiryOrDLA(newID, expiry);
        return copy;
    }

    private void expire(Transaction tx, MessageReference ref) throws Exception {
        SimpleString expiryAddress = this.addressSettingsRepository.getMatch(this.address.toString()).getExpiryAddress();
        if (expiryAddress != null) {
            Bindings bindingList = this.postOffice.getBindingsForAddress(expiryAddress);
            if (bindingList.getBindings().isEmpty()) {
                log.warn("Message has expired. No bindings for Expiry Address " + expiryAddress + " so dropping it");
            } else {
                this.move(expiryAddress, tx, ref, true, true);
            }
        } else {
            log.warn("Message has expired. No expiry queue configured for queue " + this.name + " so dropping it");
            this.acknowledge(tx, ref);
        }
    }

    private void sendToDeadLetterAddress(MessageReference ref) throws Exception {
        this.sendToDeadLetterAddress(ref, this.addressSettingsRepository.getMatch(this.address.toString()).getDeadLetterAddress());
    }

    private void sendToDeadLetterAddress(MessageReference ref, SimpleString deadLetterAddress) throws Exception {
        if (deadLetterAddress != null) {
            Bindings bindingList = this.postOffice.getBindingsForAddress(deadLetterAddress);
            if (bindingList.getBindings().isEmpty()) {
                log.warn("Message " + ref + " has exceeded max delivery attempts. No bindings for Dead Letter Address " + deadLetterAddress + " so dropping it");
            } else {
                log.warn("Message " + ref + " has reached maximum delivery attempts, sending it to Dead Letter Address " + deadLetterAddress + " from " + this.name);
                this.move(deadLetterAddress, ref, false, false);
            }
        } else {
            log.warn("Message has exceeded max delivery attempts. No Dead Letter Address configured for queue " + this.name + " so dropping it");
            this.acknowledge(ref);
        }
    }

    private void move(SimpleString address, MessageReference ref, boolean expiry, boolean rejectDuplicate) throws Exception {
        TransactionImpl tx = new TransactionImpl(this.storageManager);
        ServerMessage copyMessage = this.makeCopy(ref, expiry);
        copyMessage.setAddress(address);
        this.postOffice.route(copyMessage, tx, false, rejectDuplicate);
        this.acknowledge(tx, ref);
        tx.commit();
    }

    private synchronized boolean deliverDirect(MessageReference ref) {
        if (this.paused || this.consumerList.isEmpty()) {
            return false;
        }
        if (this.checkExpired(ref)) {
            return true;
        }
        int startPos = this.pos;
        int size = this.consumerList.size();
        do {
            HandleStatus status;
            ConsumerHolder holder = this.consumerList.get(this.pos);
            Consumer consumer = holder.consumer;
            Consumer groupConsumer = null;
            SimpleString groupID = ref.getMessage().getSimpleStringProperty(Message.HDR_GROUP_ID);
            if (groupID != null && (groupConsumer = this.groups.get(groupID)) != null) {
                consumer = groupConsumer;
            }
            ++this.pos;
            if (this.pos == size) {
                this.pos = 0;
            }
            if ((status = this.handle(ref, consumer)) != HandleStatus.HANDLED) continue;
            if (groupID != null && groupConsumer == null) {
                this.groups.put(groupID, consumer);
            }
            ++this.messagesAdded;
            return true;
        } while (this.pos != startPos);
        return false;
    }

    private boolean checkExpired(MessageReference reference) {
        if (reference.getMessage().isExpired()) {
            if (isTrace) {
                log.trace("Reference " + reference + " is expired");
            }
            reference.handled();
            try {
                this.expire(reference);
            }
            catch (Exception e) {
                log.error("Failed to expire ref", e);
            }
            return true;
        }
        return false;
    }

    private synchronized HandleStatus handle(MessageReference reference, Consumer consumer) {
        HandleStatus status;
        try {
            status = consumer.handle(reference);
        }
        catch (Throwable t) {
            log.warn("removing consumer which did not handle a message, consumer=" + consumer + ", message=" + reference, t);
            try {
                this.removeConsumer(consumer);
            }
            catch (Exception e) {
                log.error("Failed to remove consumer", e);
            }
            return HandleStatus.BUSY;
        }
        if (status == null) {
            throw new IllegalStateException("ClientConsumer.handle() should never return null");
        }
        return status;
    }

    private void postAcknowledge(MessageReference ref) {
        int count;
        boolean durableRef;
        QueueImpl queue = (QueueImpl)ref.getQueue();
        queue.deliveringCount.decrementAndGet();
        if (ref.isPaged()) {
            return;
        }
        ServerMessage message = ref.getMessage();
        boolean bl = durableRef = message.isDurable() && queue.durable;
        if (durableRef && (count = message.decrementDurableRefCount()) == 0) {
            try {
                this.storageManager.deleteMessage(message.getMessageID());
            }
            catch (Exception e) {
                log.warn("Unable to remove message id = " + message.getMessageID() + " please remove manually", e);
            }
        }
        try {
            message.decrementRefCount();
        }
        catch (Exception e) {
            log.warn("Unable to decrement reference counting", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void postRollback(LinkedList<MessageReference> refs) {
        QueueImpl queueImpl = this;
        synchronized (queueImpl) {
            for (MessageReference ref : refs) {
                this.addHead(ref);
            }
            this.resetAllIterators();
            this.deliverAsync();
        }
    }

    private class SynchronizedIterator
    implements LinkedListIterator<MessageReference> {
        private final LinkedListIterator<MessageReference> iter;

        SynchronizedIterator(LinkedListIterator<MessageReference> iter) {
            this.iter = iter;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void close() {
            QueueImpl queueImpl = QueueImpl.this;
            synchronized (queueImpl) {
                this.iter.close();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void repeat() {
            QueueImpl queueImpl = QueueImpl.this;
            synchronized (queueImpl) {
                this.iter.repeat();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean hasNext() {
            QueueImpl queueImpl = QueueImpl.this;
            synchronized (queueImpl) {
                return this.iter.hasNext();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public MessageReference next() {
            QueueImpl queueImpl = QueueImpl.this;
            synchronized (queueImpl) {
                return (MessageReference)this.iter.next();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void remove() {
            QueueImpl queueImpl = QueueImpl.this;
            synchronized (queueImpl) {
                this.iter.remove();
            }
        }
    }

    private class ConcurrentPoller
    implements Runnable {
        private ConcurrentPoller() {
        }

        @Override
        public void run() {
            QueueImpl.this.doPoll();
        }
    }

    private class DepageRunner
    implements Runnable {
        private DepageRunner() {
        }

        @Override
        public void run() {
            try {
                QueueImpl.this.depage();
            }
            catch (Exception e) {
                log.error("Failed to deliver", e);
            }
        }
    }

    private class DeliverRunner
    implements Runnable {
        private DeliverRunner() {
        }

        @Override
        public void run() {
            try {
                QueueImpl.this.deliver();
            }
            catch (Exception e) {
                log.error("Failed to deliver", e);
            }
        }
    }

    private class DelayedAddRedistributor
    implements Runnable {
        private final Executor executor;

        DelayedAddRedistributor(Executor executor) {
            this.executor = executor;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            QueueImpl queueImpl = QueueImpl.this;
            synchronized (queueImpl) {
                QueueImpl.this.internalAddRedistributor(this.executor);
                QueueImpl.this.futures.remove(this);
            }
        }
    }

    private final class RefsOperation
    implements TransactionOperation {
        List<MessageReference> refsToAck = new ArrayList<MessageReference>();
        List<ServerMessage> pagedMessagesToPostACK = null;

        private RefsOperation() {
        }

        synchronized void addAck(MessageReference ref) {
            this.refsToAck.add(ref);
            if (ref.isPaged()) {
                if (this.pagedMessagesToPostACK == null) {
                    this.pagedMessagesToPostACK = new ArrayList<ServerMessage>();
                }
                this.pagedMessagesToPostACK.add(ref.getMessage());
            }
        }

        @Override
        public void beforeCommit(Transaction tx) throws Exception {
        }

        @Override
        public void afterPrepare(Transaction tx) {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void afterRollback(Transaction tx) {
            HashMap<QueueImpl, LinkedList<MessageReference>> queueMap = new HashMap<QueueImpl, LinkedList<MessageReference>>();
            long timeBase = System.currentTimeMillis();
            for (MessageReference messageReference : this.refsToAck) {
                try {
                    if (!messageReference.getQueue().checkRedelivery(messageReference, timeBase)) continue;
                    LinkedList<MessageReference> toCancel = (LinkedList<MessageReference>)queueMap.get(messageReference.getQueue());
                    if (toCancel == null) {
                        toCancel = new LinkedList<MessageReference>();
                        queueMap.put((QueueImpl)messageReference.getQueue(), toCancel);
                    }
                    toCancel.addFirst(messageReference);
                }
                catch (Exception e) {
                    log.warn("Error on checkDLQ", e);
                }
            }
            for (Map.Entry entry : queueMap.entrySet()) {
                QueueImpl queue;
                LinkedList refs = (LinkedList)entry.getValue();
                QueueImpl queueImpl = queue = (QueueImpl)entry.getKey();
                synchronized (queueImpl) {
                    queue.postRollback(refs);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void afterCommit(Transaction tx) {
            for (MessageReference ref : this.refsToAck) {
                Queue queue = ref.getQueue();
                synchronized (queue) {
                    QueueImpl.this.postAcknowledge(ref);
                }
            }
            if (this.pagedMessagesToPostACK != null) {
                for (ServerMessage msg : this.pagedMessagesToPostACK) {
                    try {
                        msg.decrementRefCount();
                    }
                    catch (Exception e) {
                        log.warn(e.getMessage(), e);
                    }
                }
            }
        }

        @Override
        public void beforePrepare(Transaction tx) throws Exception {
        }

        @Override
        public void beforeRollback(Transaction tx) throws Exception {
        }

        @Override
        public List<MessageReference> getRelatedMessageReferences() {
            return this.refsToAck;
        }
    }

    private static class ConsumerHolder {
        final Consumer consumer;
        LinkedListIterator<MessageReference> iter;

        ConsumerHolder(Consumer consumer) {
            this.consumer = consumer;
        }
    }
}

