/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.classloader.spi.translator;

import java.security.ProtectionDomain;
import java.util.List;
import java.util.ListIterator;
import org.jboss.logging.Logger;
import org.jboss.util.loading.Translator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TranslatorUtils {
    private static final Logger log = Logger.getLogger(TranslatorUtils.class);

    public static byte[] applyTranslatorsOnTransform(List<Translator> translators, ClassLoader classLoader, String className, byte[] byteCode, ProtectionDomain protectionDomain) throws Exception {
        if (translators == null || translators.isEmpty()) {
            return byteCode;
        }
        boolean trace = log.isTraceEnabled();
        byte[] result = byteCode;
        for (Translator translator : translators) {
            if (translator == null) {
                if (!trace) continue;
                log.trace((Object)("Null translator, classLoader: " + classLoader + ", className: " + className));
                continue;
            }
            result = translator.transform(classLoader, className, null, protectionDomain, result);
        }
        return result;
    }

    public static void applyTranslatorsAtUnregister(List<Translator> translators, ClassLoader classLoader) {
        if (translators != null && !translators.isEmpty()) {
            boolean trace = log.isTraceEnabled();
            ListIterator<Translator> iter = translators.listIterator(translators.size() - 1);
            while (iter.hasPrevious()) {
                Translator translator = iter.previous();
                if (translator == null) {
                    if (!trace) continue;
                    log.trace((Object)("Null translator, classLoader: " + classLoader));
                    continue;
                }
                try {
                    translator.unregisterClassLoader(classLoader);
                }
                catch (Exception e) {
                    log.warn((Object)("Exception for translator " + translator + " on CL unregister: " + e));
                }
            }
        }
    }
}

