/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.jaxme.xs.xml;

import java.util.StringTokenizer;

public class XsDerivationSet {
    boolean extensionAllowed;
    boolean restrictionAllowed;

    public boolean isExtensionAllowed() {
        return this.extensionAllowed;
    }

    public void setExtensionAllowed(boolean pExtensionAllowed) {
        this.extensionAllowed = pExtensionAllowed;
    }

    public boolean isRestrictionAllowed() {
        return this.restrictionAllowed;
    }

    public void setRestrictionAllowed(boolean pRestrictionAllowed) {
        this.restrictionAllowed = pRestrictionAllowed;
    }

    public static XsDerivationSet valueOf(String pValue) {
        return new XsDerivationSet(pValue);
    }

    public XsDerivationSet(String pValue) {
        if ("#all".equals(pValue)) {
            this.setExtensionAllowed(true);
            this.setRestrictionAllowed(true);
        } else {
            StringTokenizer st = new StringTokenizer(pValue, " ");
            while (st.hasMoreTokens()) {
                String s = st.nextToken();
                if ("extension".equals(s)) {
                    this.setExtensionAllowed(true);
                    continue;
                }
                if ("restriction".equals(s)) {
                    this.setRestrictionAllowed(true);
                    continue;
                }
                throw new IllegalArgumentException("Invalid derivation set value: " + pValue + "; the token " + s + " did not resolve to either of 'extension' or 'restriction'");
            }
        }
    }

    public String toString() {
        if (this.isExtensionAllowed()) {
            if (this.isRestrictionAllowed()) {
                return "extension restriction";
            }
            return "extension";
        }
        if (this.isRestrictionAllowed()) {
            return "restriction";
        }
        return "";
    }

    public boolean equals(Object o) {
        if (o == null || !XsDerivationSet.class.equals(o.getClass())) {
            return false;
        }
        XsDerivationSet ds = (XsDerivationSet)o;
        return ds.extensionAllowed == this.extensionAllowed && ds.restrictionAllowed == this.restrictionAllowed;
    }

    public int hashCode() {
        int result = 0;
        if (this.extensionAllowed) {
            ++result;
        }
        if (this.restrictionAllowed) {
            result += 2;
        }
        return result;
    }
}

