/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security.xacml.sunxacml.finder;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jboss.security.xacml.sunxacml.EvaluationCtx;
import org.jboss.security.xacml.sunxacml.attr.AttributeValue;
import org.jboss.security.xacml.sunxacml.finder.ResourceFinderModule;
import org.jboss.security.xacml.sunxacml.finder.ResourceFinderResult;

public class ResourceFinder {
    private List allModules = new ArrayList();
    private List childModules = new ArrayList();
    private List descendantModules = new ArrayList();
    private static final Logger logger = Logger.getLogger(ResourceFinder.class.getName());

    public List getModules() {
        return new ArrayList(this.allModules);
    }

    public void setModules(List modules) {
        Iterator it = modules.iterator();
        this.allModules = new ArrayList(modules);
        this.childModules = new ArrayList();
        this.descendantModules = new ArrayList();
        while (it.hasNext()) {
            ResourceFinderModule module = (ResourceFinderModule)it.next();
            if (module.isChildSupported()) {
                this.childModules.add(module);
            }
            if (!module.isDescendantSupported()) continue;
            this.descendantModules.add(module);
        }
    }

    public ResourceFinderResult findChildResources(AttributeValue parentResourceId, EvaluationCtx context) {
        for (ResourceFinderModule module : this.childModules) {
            ResourceFinderResult result = module.findChildResources(parentResourceId, context);
            if (result.isEmpty()) continue;
            return result;
        }
        if (logger.isLoggable(Level.INFO)) {
            logger.info("No ResourceFinderModule existed to handle the children of " + parentResourceId.encode());
        }
        return new ResourceFinderResult();
    }

    public ResourceFinderResult findChildResources(AttributeValue parentResourceId) {
        for (ResourceFinderModule module : this.childModules) {
            ResourceFinderResult result = module.findChildResources(parentResourceId);
            if (result.isEmpty()) continue;
            return result;
        }
        if (logger.isLoggable(Level.INFO)) {
            logger.info("No ResourceFinderModule existed to handle the children of " + parentResourceId.encode());
        }
        return new ResourceFinderResult();
    }

    public ResourceFinderResult findDescendantResources(AttributeValue parentResourceId, EvaluationCtx context) {
        for (ResourceFinderModule module : this.descendantModules) {
            ResourceFinderResult result = module.findDescendantResources(parentResourceId, context);
            if (result.isEmpty()) continue;
            return result;
        }
        if (logger.isLoggable(Level.INFO)) {
            logger.info("No ResourceFinderModule existed to handle the descendants of " + parentResourceId.encode());
        }
        return new ResourceFinderResult();
    }

    public ResourceFinderResult findDescendantResources(AttributeValue parentResourceId) {
        for (ResourceFinderModule module : this.descendantModules) {
            ResourceFinderResult result = module.findDescendantResources(parentResourceId);
            if (result.isEmpty()) continue;
            return result;
        }
        if (logger.isLoggable(Level.INFO)) {
            logger.info("No ResourceFinderModule existed to handle the descendants of " + parentResourceId.encode());
        }
        return new ResourceFinderResult();
    }
}

