/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.core.protocol.core.impl.wireformat;

import javax.transaction.xa.Xid;
import org.hornetq.api.core.HornetQBuffer;
import org.hornetq.core.protocol.core.impl.PacketImpl;
import org.hornetq.utils.XidCodecSupport;

public class SessionXAEndMessage
extends PacketImpl {
    private Xid xid;
    private boolean failed;

    public SessionXAEndMessage(Xid xid, boolean failed) {
        super((byte)52);
        this.xid = xid;
        this.failed = failed;
    }

    public SessionXAEndMessage() {
        super((byte)52);
    }

    public boolean isFailed() {
        return this.failed;
    }

    public Xid getXid() {
        return this.xid;
    }

    public void encodeRest(HornetQBuffer buffer) {
        XidCodecSupport.encodeXid(this.xid, buffer);
        buffer.writeBoolean(this.failed);
    }

    public void decodeRest(HornetQBuffer buffer) {
        this.xid = XidCodecSupport.decodeXid(buffer);
        this.failed = buffer.readBoolean();
    }

    public String toString() {
        return this.getParentString() + ", xid=" + this.xid + ", failed=" + this.failed + "]";
    }

    public boolean equals(Object other) {
        if (!(other instanceof SessionXAEndMessage)) {
            return false;
        }
        SessionXAEndMessage r = (SessionXAEndMessage)other;
        return super.equals(other) && this.xid.equals(r.xid) && this.failed == r.failed;
    }
}

