/*
 * Decompiled with CFR 0.152.
 */
package com.arjuna.ats.arjuna.coordinator;

import com.arjuna.ats.arjuna.common.arjPropertyManager;
import com.arjuna.ats.arjuna.coordinator.Reapable;
import com.arjuna.ats.arjuna.coordinator.TxControl;
import com.arjuna.ats.arjuna.coordinator.TxStats;
import com.arjuna.ats.arjuna.logging.tsLogger;
import com.arjuna.ats.internal.arjuna.coordinator.ReaperElement;
import com.arjuna.ats.internal.arjuna.coordinator.ReaperElementManager;
import com.arjuna.ats.internal.arjuna.coordinator.ReaperThread;
import com.arjuna.ats.internal.arjuna.coordinator.ReaperWorkerThread;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicLong;

public class TransactionReaper {
    public static final String NORMAL = "NORMAL";
    public static final String DYNAMIC = "DYNAMIC";
    public static final String PERIODIC = "PERIODIC";
    public static final long defaultCheckPeriod = 120000L;
    public static final long defaultCancelWaitPeriod = 500L;
    public static final long defaultCancelFailWaitPeriod = 500L;
    public static final int defaultZombieMax = 8;
    private final ReaperElementManager _reaperElements = new ReaperElementManager();
    private final ConcurrentMap<Object, ReaperElement> _timeouts = new ConcurrentHashMap<Object, ReaperElement>();
    private final List<ReaperElement> _workQueue = new LinkedList<ReaperElement>();
    private long _checkPeriod = 0L;
    private final AtomicLong nextDynamicCheckTime = new AtomicLong(Long.MAX_VALUE);
    private long _cancelWaitPeriod = 0L;
    private long _cancelFailWaitPeriod = 0L;
    private int _zombieMax = 0;
    private static volatile TransactionReaper _theReaper = null;
    private static ReaperThread _reaperThread = null;
    private static ReaperWorkerThread _reaperWorkerThread = null;
    private static boolean _dynamic = true;
    private static AtomicLong _lifetime = new AtomicLong(0L);
    private static int _zombieCount = 0;
    private boolean _inShutdown = false;

    private TransactionReaper(long checkPeriod) {
        if (tsLogger.arjLogger.isDebugEnabled()) {
            tsLogger.arjLogger.debug("TransactionReaper::TransactionReaper ( " + checkPeriod + " )");
        }
        this._checkPeriod = checkPeriod;
    }

    public final long checkingPeriod() {
        long waitTime;
        if (_dynamic) {
            return this.nextDynamicCheckTime.get() - System.currentTimeMillis();
        }
        ReaperElement head = this._reaperElements.getFirst();
        if (head != null && head._status != 0 && (waitTime = head.getAbsoluteTimeout() - System.currentTimeMillis()) < this._checkPeriod) {
            return waitTime;
        }
        return this._checkPeriod;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void check() {
        if (tsLogger.arjLogger.isDebugEnabled()) {
            tsLogger.arjLogger.debug("TransactionReaper::check ()");
        }
        while (true) {
            ReaperElement reaperElement;
            Object object = this;
            synchronized (object) {
                long now = System.currentTimeMillis();
                long next = this.nextDynamicCheckTime.get();
                if (tsLogger.arjLoggerI18N.isDebugEnabled()) {
                    tsLogger.arjLoggerI18N.debug("com.arjuna.ats.arjuna.coordinator.TransactionReaper_2", new Object[]{Long.toString(next)});
                }
                if (now < next) {
                    break;
                }
                reaperElement = this._reaperElements.getFirst();
                if (reaperElement == null) {
                    this.nextDynamicCheckTime.set(Long.MAX_VALUE);
                    return;
                }
                long nextTimeout = reaperElement.getAbsoluteTimeout();
                if (nextTimeout > now) {
                    this.nextDynamicCheckTime.set(nextTimeout);
                    return;
                }
            }
            if (tsLogger.arjLoggerI18N.isWarnEnabled()) {
                tsLogger.arjLoggerI18N.warn("com.arjuna.ats.arjuna.coordinator.TransactionReaper_18", new Object[]{reaperElement._control.get_uid(), reaperElement.statusName()});
            }
            object = reaperElement;
            synchronized (object) {
                switch (reaperElement._status) {
                    case 0: {
                        reaperElement._status = 1;
                        this.reinsertElement(reaperElement, this._cancelWaitPeriod);
                        if (tsLogger.arjLogger.isDebugEnabled()) {
                            tsLogger.arjLogger.debug("Reaper scheduling TX for cancellation " + reaperElement._control.get_uid());
                        }
                        List<ReaperElement> now = this._workQueue;
                        synchronized (now) {
                            this._workQueue.add(reaperElement);
                            this._workQueue.notifyAll();
                            break;
                        }
                    }
                    case 1: {
                        this.reinsertElement(reaperElement, this._cancelWaitPeriod);
                        if (!tsLogger.arjLogger.isDebugEnabled()) break;
                        tsLogger.arjLogger.debug("Reaper deferring interrupt for TX scheduled for cancel " + reaperElement._control.get_uid());
                        break;
                    }
                    case 2: {
                        reaperElement._status = 3;
                        reaperElement._worker.interrupt();
                        this.reinsertElement(reaperElement, this._cancelFailWaitPeriod);
                        if (!tsLogger.arjLoggerI18N.isDebugEnabled()) break;
                        tsLogger.arjLoggerI18N.debug("com.arjuna.ats.arjuna.coordinator.TransactionReaper_4", new Object[]{reaperElement._control.get_uid()});
                        break;
                    }
                    case 3: {
                        reaperElement._status = 6;
                        TransactionReaper now = this;
                        synchronized (now) {
                            ++_zombieCount;
                            if (tsLogger.arjLogger.isDebugEnabled()) {
                                tsLogger.arjLogger.debug("Reaper " + Thread.currentThread() + " got a zombie " + reaperElement._worker + " (zombie count now " + _zombieCount + ") cancelling " + reaperElement._control.get_uid());
                            }
                            if (_zombieCount == this._zombieMax && tsLogger.arjLoggerI18N.isErrorEnabled()) {
                                tsLogger.arjLoggerI18N.error("com.arjuna.ats.arjuna.coordinator.TransactionReaper_5", new Object[]{new Integer(_zombieCount)});
                            }
                        }
                        _reaperWorkerThread = new ReaperWorkerThread(_theReaper);
                        _reaperWorkerThread.setDaemon(true);
                        _reaperWorkerThread.start();
                        if (tsLogger.arjLoggerI18N.isWarnEnabled()) {
                            tsLogger.arjLoggerI18N.warn("com.arjuna.ats.arjuna.coordinator.TransactionReaper_6", new Object[]{reaperElement._worker, reaperElement._control.get_uid()});
                        }
                        this.removeElementReaper(reaperElement);
                        try {
                            if (reaperElement._control.preventCommit()) {
                                if (!tsLogger.arjLoggerI18N.isWarnEnabled()) break;
                                tsLogger.arjLoggerI18N.warn("com.arjuna.ats.arjuna.coordinator.TransactionReaper_10", new Object[]{reaperElement._control.get_uid()});
                                break;
                            }
                            if (!tsLogger.arjLoggerI18N.isWarnEnabled()) break;
                            tsLogger.arjLoggerI18N.warn("com.arjuna.ats.arjuna.coordinator.TransactionReaper_11", new Object[]{reaperElement._control.get_uid()});
                        }
                        catch (Exception e1) {
                            if (!tsLogger.arjLoggerI18N.isWarnEnabled()) break;
                            tsLogger.arjLoggerI18N.warn("com.arjuna.ats.arjuna.coordinator.TransactionReaper_12", new Object[]{reaperElement._control.get_uid()}, (Throwable)e1);
                        }
                        break;
                    }
                    case 4: 
                    case 5: {
                        this.removeElementReaper(reaperElement);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reinsertElement(ReaperElement e, long delay) {
        TransactionReaper transactionReaper = this;
        synchronized (transactionReaper) {
            long newWakeup = this._reaperElements.reorder(e, delay);
            this.nextDynamicCheckTime.set(newWakeup);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void waitForCancellations() {
        List<ReaperElement> list = this._workQueue;
        synchronized (list) {
            try {
                while (this._workQueue.isEmpty()) {
                    this._workQueue.wait();
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void doCancellations() {
        while (true) {
            ReaperElement e;
            block38: {
                List<ReaperElement> list = this._workQueue;
                synchronized (list) {
                    try {
                        e = this._workQueue.remove(0);
                    }
                    catch (IndexOutOfBoundsException ioobe) {
                        break;
                    }
                }
                if (tsLogger.arjLogger.isDebugEnabled()) {
                    tsLogger.arjLogger.debug("Reaper Worker " + Thread.currentThread() + " attempting to cancel " + e._control.get_uid());
                }
                boolean cancelled = false;
                Exception exception = null;
                ReaperElement reaperElement = e;
                synchronized (reaperElement) {
                    e._worker = Thread.currentThread();
                    e._status = 2;
                    e.notifyAll();
                }
                try {
                    if (e._control.running() && e._control.cancel() == 4) {
                        cancelled = true;
                        if (TxControl.enableStatistics) {
                            TxStats.incrementTimeouts();
                        }
                    }
                }
                catch (Exception e1) {
                    exception = e1;
                }
                ReaperElement e1 = e;
                synchronized (e1) {
                    if (e._status == 6) {
                        ReaperWorkerThread worker = (ReaperWorkerThread)Thread.currentThread();
                        worker.shutdown();
                        TransactionReaper transactionReaper = this;
                        synchronized (transactionReaper) {
                            --_zombieCount;
                        }
                        if (tsLogger.arjLoggerI18N.isWarnEnabled()) {
                            tsLogger.arjLoggerI18N.warn("com.arjuna.ats.arjuna.coordinator.TransactionReaper_13", new Object[]{Thread.currentThread(), e._control.get_uid(), new Integer(_zombieCount)});
                        }
                        break;
                    }
                    if (cancelled && e._status == 3) {
                        cancelled = false;
                        e._status = 4;
                        e.notifyAll();
                    } else {
                        e._status = cancelled ? 5 : 4;
                        e.notifyAll();
                    }
                }
                if (cancelled) {
                    if (tsLogger.arjLoggerI18N.isWarnEnabled()) {
                        tsLogger.arjLoggerI18N.warn("com.arjuna.ats.arjuna.coordinator.TransactionReaper_7", new Object[]{Thread.currentThread(), e._control.get_uid()});
                    }
                } else if (e._control.running()) {
                    if (exception != null) {
                        if (tsLogger.arjLoggerI18N.isWarnEnabled()) {
                            tsLogger.arjLoggerI18N.warn("com.arjuna.ats.arjuna.coordinator.TransactionReaper_9", new Object[]{Thread.currentThread(), e._control.get_uid()}, (Throwable)exception);
                        }
                    } else if (tsLogger.arjLoggerI18N.isWarnEnabled()) {
                        tsLogger.arjLoggerI18N.warn("com.arjuna.ats.arjuna.coordinator.TransactionReaper_8", new Object[]{Thread.currentThread(), e._control.get_uid()});
                    }
                    try {
                        if (e._control.preventCommit()) {
                            if (tsLogger.arjLoggerI18N.isWarnEnabled()) {
                                tsLogger.arjLoggerI18N.warn("com.arjuna.ats.arjuna.coordinator.TransactionReaper_14", new Object[]{Thread.currentThread(), e._control.get_uid()});
                            }
                        } else if (tsLogger.arjLoggerI18N.isWarnEnabled()) {
                            tsLogger.arjLoggerI18N.warn("com.arjuna.ats.arjuna.coordinator.TransactionReaper_15", new Object[]{Thread.currentThread(), e._control.get_uid()});
                        }
                    }
                    catch (Exception e12) {
                        if (!tsLogger.arjLoggerI18N.isWarnEnabled()) break block38;
                        tsLogger.arjLoggerI18N.warn("com.arjuna.ats.arjuna.coordinator.TransactionReaper_16", new Object[]{Thread.currentThread(), e._control.get_uid()}, (Throwable)e12);
                    }
                }
            }
            this.removeElementReaper(e);
        }
    }

    public final long numberOfTransactions() {
        return this._reaperElements.size();
    }

    public final long numberOfTimeouts() {
        return this._timeouts.size();
    }

    public final void insert(Reapable control, int timeout) {
        if (tsLogger.arjLogger.isDebugEnabled()) {
            tsLogger.arjLogger.debug("TransactionReaper::insert ( " + control + ", " + timeout + " )");
        }
        if (timeout == 0) {
            return;
        }
        ReaperElement reaperElement = new ReaperElement(control, timeout);
        _lifetime.addAndGet(timeout);
        if (this._timeouts.putIfAbsent(reaperElement._control, reaperElement) != null) {
            throw new IllegalStateException(tsLogger.arjLoggerI18N.getString("com.arjuna.ats.arjuna.coordinator.TransactionReaper_1"));
        }
        this._reaperElements.add(reaperElement);
        if (_dynamic && reaperElement.getAbsoluteTimeout() < this.nextDynamicCheckTime.get()) {
            this.updateCheckTimeForEarlierInsert(reaperElement.getAbsoluteTimeout());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateCheckTimeForEarlierInsert(long newCheckTime) {
        TransactionReaper transactionReaper = this;
        synchronized (transactionReaper) {
            long oldCheckTime = this.nextDynamicCheckTime.get();
            while (newCheckTime < oldCheckTime) {
                if (this.nextDynamicCheckTime.compareAndSet(oldCheckTime, newCheckTime)) {
                    this.notifyAll();
                    continue;
                }
                oldCheckTime = this.nextDynamicCheckTime.get();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void remove(Object control) {
        if (tsLogger.arjLogger.isDebugEnabled()) {
            tsLogger.arjLogger.debug("TransactionReaper::remove ( " + control + " )");
        }
        if (control == null) {
            return;
        }
        ReaperElement key = (ReaperElement)this._timeouts.get(control);
        if (key == null) {
            return;
        }
        ReaperElement reaperElement = key;
        synchronized (reaperElement) {
            if (key._status != 0) {
                return;
            }
            this.removeElementClient(key);
        }
    }

    public final long getRemainingTimeoutMills(Object control) {
        if (this._timeouts.isEmpty() || control == null) {
            if (tsLogger.arjLogger.isDebugEnabled()) {
                tsLogger.arjLogger.debug("TransactionReaper::getRemainingTimeout for " + control + " returning 0");
            }
            return 0L;
        }
        ReaperElement reaperElement = (ReaperElement)this._timeouts.get(control);
        long timeout = 0L;
        timeout = reaperElement == null ? 0L : reaperElement.getAbsoluteTimeout() - System.currentTimeMillis();
        if (tsLogger.arjLoggerI18N.isDebugEnabled()) {
            tsLogger.arjLoggerI18N.debug("com.arjuna.ats.arjuna.coordinator.TransactionReaper_17", new Object[]{control, timeout});
        }
        return timeout;
    }

    public final int getTimeout(Object control) {
        if (this._timeouts.isEmpty() || control == null) {
            if (tsLogger.arjLogger.isDebugEnabled()) {
                tsLogger.arjLogger.debug("TransactionReaper::getTimeout for " + control + " returning 0");
            }
            return 0;
        }
        ReaperElement reaperElement = (ReaperElement)this._timeouts.get(control);
        int timeout = reaperElement == null ? 0 : reaperElement._timeout;
        tsLogger.arjLoggerI18N.debug("com.arjuna.ats.arjuna.coordinator.TransactionReaper_3", new Object[]{control, timeout});
        return timeout;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void shutdown(boolean waitForTransactions) {
        TransactionReaper transactionReaper = this;
        synchronized (transactionReaper) {
            this._inShutdown = true;
            if (!waitForTransactions) {
                this._reaperElements.setAllTimeoutsToZero();
            }
            while (!this._reaperElements.isEmpty()) {
                try {
                    this.wait();
                }
                catch (Exception exception) {}
            }
            _reaperThread.shutdown();
            this.notifyAll();
        }
        try {
            _reaperThread.join();
        }
        catch (Exception ex) {
            // empty catch block
        }
        _reaperThread = null;
        List<ReaperElement> ex = this._workQueue;
        synchronized (ex) {
            _reaperWorkerThread.shutdown();
            this._workQueue.notifyAll();
            _reaperWorkerThread.interrupt();
        }
        try {
            _reaperWorkerThread.join();
        }
        catch (Exception exception) {
            // empty catch block
        }
        _reaperWorkerThread = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void removeElementClient(ReaperElement reaperElement) {
        this._reaperElements.remove(reaperElement);
        this._timeouts.remove(reaperElement._control);
        if (this._inShutdown) {
            TransactionReaper transactionReaper = this;
            synchronized (transactionReaper) {
                this.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void removeElementReaper(ReaperElement reaperElement) {
        this._reaperElements.remove(reaperElement);
        this._timeouts.remove(reaperElement._control);
        TransactionReaper transactionReaper = this;
        synchronized (transactionReaper) {
            ReaperElement first = this._reaperElements.getFirst();
            if (first != null) {
                this.nextDynamicCheckTime.set(first.getAbsoluteTimeout());
            } else {
                this.nextDynamicCheckTime.set(Long.MAX_VALUE);
                if (this._inShutdown) {
                    this.notifyAll();
                }
            }
        }
    }

    public static synchronized void instantiate() {
        if (_theReaper == null) {
            String zombieMax;
            String cancelFailWait;
            if (tsLogger.arjLogger.isDebugEnabled()) {
                tsLogger.arjLogger.debug("TransactionReaper::instantiate()");
            }
            _dynamic = true;
            String mode = arjPropertyManager.propertyManager.getProperty("com.arjuna.ats.arjuna.coordinator.txReaperMode");
            if (mode != null) {
                if (mode.compareTo(PERIODIC) == 0) {
                    _dynamic = false;
                }
                if (mode.compareTo(NORMAL) == 0) {
                    _dynamic = false;
                    if (tsLogger.arjLoggerI18N.isWarnEnabled()) {
                        tsLogger.arjLoggerI18N.warn("com.arjuna.ats.arjuna.coordinator.TransactionReaper_19");
                    }
                }
            }
            long checkPeriod = Long.MAX_VALUE;
            if (!_dynamic) {
                String timeoutEnv = arjPropertyManager.propertyManager.getProperty("com.arjuna.ats.arjuna.coordinator.txReaperTimeout");
                if (timeoutEnv != null) {
                    Long l = null;
                    try {
                        l = new Long(timeoutEnv);
                        checkPeriod = l;
                        l = null;
                    }
                    catch (NumberFormatException e) {
                        if (tsLogger.arjLogger.isWarnEnabled()) {
                            tsLogger.arjLogger.warn("TransactionReaper::create - " + e);
                        }
                    }
                } else {
                    checkPeriod = 120000L;
                }
            }
            _theReaper = new TransactionReaper(checkPeriod);
            String cancelWait = arjPropertyManager.propertyManager.getProperty("com.arjuna.ats.arjuna.coordinator.txReaperCancelWaitPeriod");
            if (cancelWait != null) {
                try {
                    TransactionReaper._theReaper._cancelWaitPeriod = Long.valueOf(cancelWait);
                }
                catch (NumberFormatException e) {
                    TransactionReaper._theReaper._cancelWaitPeriod = 500L;
                }
                if (TransactionReaper._theReaper._cancelWaitPeriod < 10L) {
                    TransactionReaper._theReaper._cancelWaitPeriod = 10L;
                }
            } else {
                TransactionReaper._theReaper._cancelWaitPeriod = 500L;
            }
            if ((cancelFailWait = arjPropertyManager.propertyManager.getProperty("com.arjuna.ats.arjuna.coordinator.txReaperCancelFailWaitPeriod")) != null) {
                try {
                    TransactionReaper._theReaper._cancelFailWaitPeriod = Long.valueOf(cancelFailWait);
                }
                catch (NumberFormatException e) {
                    TransactionReaper._theReaper._cancelFailWaitPeriod = 500L;
                }
                if (TransactionReaper._theReaper._cancelFailWaitPeriod < 10L) {
                    TransactionReaper._theReaper._cancelFailWaitPeriod = 10L;
                }
            } else {
                TransactionReaper._theReaper._cancelFailWaitPeriod = 500L;
            }
            if ((zombieMax = arjPropertyManager.propertyManager.getProperty("com.arjuna.ats.arjuna.coordinator.txReaperZombieMax")) != null) {
                try {
                    TransactionReaper._theReaper._zombieMax = Integer.valueOf(zombieMax);
                }
                catch (NumberFormatException e) {
                    TransactionReaper._theReaper._zombieMax = 8;
                }
                if (TransactionReaper._theReaper._zombieMax <= 0) {
                    TransactionReaper._theReaper._zombieMax = 1;
                }
            } else {
                TransactionReaper._theReaper._zombieMax = 8;
            }
            TransactionReaper._theReaper._cancelWaitPeriod = 500L;
            TransactionReaper._theReaper._cancelFailWaitPeriod = 500L;
            TransactionReaper._theReaper._zombieMax = 8;
            _reaperThread = new ReaperThread(_theReaper);
            _reaperThread.setDaemon(true);
            _reaperWorkerThread = new ReaperWorkerThread(_theReaper);
            _reaperWorkerThread.setDaemon(true);
            _reaperThread.start();
            _reaperWorkerThread.start();
        }
    }

    public static TransactionReaper transactionReaper() {
        if (_theReaper == null) {
            TransactionReaper.instantiate();
        }
        return _theReaper;
    }

    public static synchronized void terminate(boolean waitForTransactions) {
        if (_theReaper != null) {
            _theReaper.shutdown(waitForTransactions);
            _theReaper = null;
        }
    }

    public static boolean isDynamic() {
        return _dynamic;
    }

    public static synchronized long transactionLifetime() {
        return _lifetime.get();
    }

    static final synchronized void reset() {
        _theReaper = null;
    }
}

