/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.persistence;

import java.lang.reflect.Method;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import javax.persistence.EntityManager;
import javax.persistence.OptimisticLockException;
import javax.transaction.Synchronization;
import org.jboss.seam.Component;
import org.jboss.seam.Entity;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.Install;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.annotations.intercept.BypassInterceptors;
import org.jboss.seam.annotations.intercept.PostConstruct;
import org.jboss.seam.persistence.EntityManagerProxy;
import org.jboss.seam.persistence.Filter;

@Name(value="org.jboss.seam.persistence.persistenceProvider")
@Scope(value=ScopeType.STATELESS)
@BypassInterceptors
@Install(precedence=0, classDependencies={"javax.persistence.EntityManager"})
public class PersistenceProvider {
    protected Set<Feature> featureSet = new HashSet<Feature>();

    @PostConstruct
    public void init() {
    }

    public boolean supportsFeature(Feature feature) {
        return this.featureSet.contains((Object)feature);
    }

    public void setFlushModeManual(EntityManager entityManager) {
        throw new UnsupportedOperationException("Use of FlushMode.MANUAL requires Hibernate as the persistence provider. Please use Hibernate, a custom persistenceProvider, or remove the MANUAL flush mode setting.");
    }

    public void setRenderFlushMode() {
    }

    public boolean isDirty(EntityManager entityManager) {
        return true;
    }

    public Object getId(Object bean, EntityManager entityManager) {
        return Entity.forBean(bean).getIdentifier(bean);
    }

    public String getName(Object bean, EntityManager entityManager) throws IllegalArgumentException {
        return Entity.forBean(bean).getName();
    }

    public Object getVersion(Object bean, EntityManager entityManager) {
        return Entity.forBean(bean).getVersion(bean);
    }

    public void checkVersion(Object bean, EntityManager entityManager, Object oldVersion, Object version) {
        boolean equal = oldVersion instanceof Date ? ((Date)oldVersion).getTime() == ((Date)version).getTime() : oldVersion.equals(version);
        if (!equal) {
            throw new OptimisticLockException("Current database version number does not match passivated version number");
        }
    }

    public void enableFilter(Filter filter, EntityManager entityManager) {
        throw new UnsupportedOperationException("Use of filters requires Hibernate as the persistence provider. Please use Hibernate or remove the filters configuration.");
    }

    public boolean registerSynchronization(Synchronization sync, EntityManager entityManager) {
        return false;
    }

    public static PersistenceProvider instance() {
        return (PersistenceProvider)Component.getInstance(PersistenceProvider.class, ScopeType.STATELESS);
    }

    public Object proxyDelegate(Object delegate) {
        return delegate;
    }

    public EntityManager proxyEntityManager(EntityManager entityManager) {
        return new EntityManagerProxy(entityManager);
    }

    public Class getBeanClass(Object bean) {
        return Entity.forBean(bean).getBeanClass();
    }

    public Method getPostLoadMethod(Object bean, EntityManager entityManager) {
        return Entity.forBean(bean).getPostLoadMethod();
    }

    public Method getPrePersistMethod(Object bean, EntityManager entityManager) {
        return Entity.forBean(bean).getPrePersistMethod();
    }

    public Method getPreUpdateMethod(Object bean, EntityManager entityManager) {
        return Entity.forBean(bean).getPreUpdateMethod();
    }

    public Method getPreRemoveMethod(Object bean, EntityManager entityManager) {
        return Entity.forBean(bean).getPreRemoveMethod();
    }

    @Deprecated
    public Method getPreRemoveMethod(Class beanClass) {
        return Entity.forClass(beanClass).getPreRemoveMethod();
    }

    @Deprecated
    public Method getPostLoadMethod(Class beanClass) {
        return Entity.forClass(beanClass).getPostLoadMethod();
    }

    @Deprecated
    public Method getPrePersistMethod(Class beanClass) {
        return Entity.forClass(beanClass).getPrePersistMethod();
    }

    @Deprecated
    public Method getPreUpdateMethod(Class beanClass) {
        return Entity.forClass(beanClass).getPreUpdateMethod();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Feature {
        WILDCARD_AS_COUNT_QUERY_SUBJECT;

    }
}

