/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.common.beans.property;

import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.jboss.common.beans.property.PropertyChangeEvent;
import org.jboss.common.beans.property.PropertyChangeListener;
import org.jboss.common.beans.property.PropertyEditor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class PropertyEditorSupport<T>
extends java.beans.PropertyEditorSupport
implements PropertyEditor<T> {
    private T value;
    private final Class<T> type;
    private CopyOnWriteArrayList<java.beans.PropertyChangeListener> listeners = new CopyOnWriteArrayList();

    public PropertyEditorSupport(Class<T> type) {
        super.setSource(this);
        this.type = type;
    }

    public PropertyEditorSupport(Class<T> type, Object source) {
        super.setSource(source);
        this.type = type;
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener<T> listener) {
        if (!this.listeners.contains(listener)) {
            this.listeners.add(listener);
        }
    }

    @Override
    public void addPropertyChangeListener(java.beans.PropertyChangeListener listener) {
        if (!this.listeners.contains(listener)) {
            this.listeners.add(listener);
        }
    }

    @Override
    public String getAsText() {
        return this.value != null ? this.value.toString() : null;
    }

    @Override
    public T getValue() {
        return this.value;
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener<T> listener) {
        this.listeners.remove(listener);
    }

    @Override
    public void removePropertyChangeListener(java.beans.PropertyChangeListener listener) {
        this.listeners.remove(listener);
    }

    @Override
    public void setValue(Object value) {
        T oldValue = this.value;
        if (value == null) {
            this.value = null;
        } else {
            if (!this.type.isAssignableFrom(value.getClass())) {
                throw new IllegalArgumentException("Unsupported value: " + value);
            }
            this.value = this.type.cast(value);
        }
        if (oldValue != this.value) {
            this.firePropertyChange(oldValue, this.value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void firePropertyChange(T oldValue, T newValue) {
        List targets;
        PropertyEditorSupport propertyEditorSupport = this;
        synchronized (propertyEditorSupport) {
            if (this.listeners == null) {
                return;
            }
            targets = (List)this.listeners.clone();
        }
        PropertyChangeEvent<T> evt = new PropertyChangeEvent<T>(this.getSource(), null, oldValue, newValue);
        for (int i = 0; i < targets.size(); ++i) {
            java.beans.PropertyChangeListener target = (java.beans.PropertyChangeListener)targets.get(i);
            try {
                if (target instanceof PropertyChangeListener) {
                    PropertyChangeListener localTarget = (PropertyChangeListener)target;
                    localTarget.propertyChange(evt);
                    continue;
                }
                target.propertyChange(evt);
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    protected Class<T> getType() {
        return this.type;
    }

    @Override
    public abstract void setAsText(String var1) throws IllegalArgumentException;
}

